#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _print_widget_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkDialog\" id=\"dialog1\">"
"    <property name=\"title\">Print Options</property>"
"    <property name=\"type_hint\">GDK_WINDOW_TYPE_HINT_DIALOG</property>"
"    <child internal-child=\"vbox\">"
"      <widget class=\"GtkVBox\" id=\"dialog-vbox1\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkAlignment\" id=\"PrintWidget\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"top_padding\">6</property>"
"            <property name=\"bottom_padding\">6</property>"
"            <property name=\"left_padding\">6</property>"
"            <property name=\"right_padding\">6</property>"
"            <child>"
"              <widget class=\"GtkVBox\" id=\"vbox\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"spacing\">6</property>"
"                <child>"
"                  <widget class=\"GtkCheckButton\" id=\"use_styles\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"label\" translatable=\"yes\">Print using text styles</property>"
"                    <property name=\"use_underline\">True</property>"
"                    <property name=\"response_id\">0</property>"
"                    <property name=\"draw_indicator\">True</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkHBox\" id=\"hbox1\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"spacing\">6</property>"
"                    <child>"
"                      <widget class=\"GtkCheckButton\" id=\"use_custom_font\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"label\" translatable=\"yes\">Use custom font:</property>"
"                        <property name=\"use_underline\">True</property>"
"                        <property name=\"response_id\">0</property>"
"                        <property name=\"draw_indicator\">True</property>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"expand\">False</property>"
"                        <property name=\"fill\">False</property>"
"                      </packing>"
"                    </child>"
"                    <child>"
"                      <widget class=\"GtkFontButton\" id=\"font\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"response_id\">0</property>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"expand\">False</property>"
"                        <property name=\"fill\">False</property>"
"                        <property name=\"position\">1</property>"
"                      </packing>"
"                    </child>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">1</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkCheckButton\" id=\"wrap\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"label\" translatable=\"yes\">Wrap long lines</property>"
"                    <property name=\"use_underline\">True</property>"
"                    <property name=\"response_id\">0</property>"
"                    <property name=\"draw_indicator\">True</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">2</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkCheckButton\" id=\"ellipsize\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"moo_sensitive\">!wrap</property>"
"                    <property name=\"label\" translatable=\"yes\">Ellipsize long lines</property>"
"                    <property name=\"use_underline\">True</property>"
"                    <property name=\"response_id\">0</property>"
"                    <property name=\"draw_indicator\">True</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">3</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkHBox\" id=\"hbox2\">"
"                    <property name=\"visible\">True</property>"
"                    <child>"
"                      <widget class=\"GtkCheckButton\" id=\"line_numbers\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"label\" translatable=\"yes\" comments=\"Part of the phrase &quot;Print line numbers&quot; &quot;every&quot; &quot;1&quot; &quot;lines&quot;\">Print line numbers</property>"
"                        <property name=\"response_id\">0</property>"
"                        <property name=\"draw_indicator\">True</property>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"expand\">False</property>"
"                        <property name=\"fill\">False</property>"
"                      </packing>"
"                    </child>"
"                    <child>"
"                      <widget class=\"GtkHBox\" id=\"line_numbers_hbox\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"spacing\">3</property>"
"                        <child>"
"                          <widget class=\"GtkLabel\" id=\"label10\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\" translatable=\"yes\" comments=\"Part of the phrase &quot;Print line numbers&quot; &quot;every&quot; &quot;1&quot; &quot;lines&quot;\">every</property>"
"                          </widget>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkSpinButton\" id=\"line_numbers_step\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"adjustment\">1 1 100 1 10 10</property>"
"                            <property name=\"climb_rate\">1</property>"
"                            <property name=\"numeric\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                            <property name=\"position\">1</property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkLabel\" id=\"label9\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\" translatable=\"yes\" comments=\"Part of the phrase &quot;Print line numbers&quot; &quot;every&quot; &quot;1&quot; &quot;lines&quot;\">lines</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                            <property name=\"position\">2</property>"
"                          </packing>"
"                        </child>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"expand\">False</property>"
"                        <property name=\"fill\">False</property>"
"                        <property name=\"padding\">3</property>"
"                        <property name=\"position\">1</property>"
"                      </packing>"
"                    </child>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">4</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkNotebook\" id=\"notebook1\">"
"                    <property name=\"visible\">True</property>"
"                    <child>"
"                      <widget class=\"GtkAlignment\" id=\"alignment1\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"top_padding\">6</property>"
"                        <property name=\"bottom_padding\">6</property>"
"                        <property name=\"left_padding\">6</property>"
"                        <property name=\"right_padding\">6</property>"
"                        <child>"
"                          <widget class=\"GtkVBox\" id=\"vbox1\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"spacing\">6</property>"
"                            <child>"
"                              <widget class=\"GtkCheckButton\" id=\"print_header\">"
"                                <property name=\"visible\">True</property>"
"                                <property name=\"label\" translatable=\"yes\">Print header</property>"
"                                <property name=\"use_underline\">True</property>"
"                                <property name=\"response_id\">0</property>"
"                                <property name=\"draw_indicator\">True</property>"
"                              </widget>"
"                              <packing>"
"                                <property name=\"expand\">False</property>"
"                                <property name=\"fill\">False</property>"
"                              </packing>"
"                            </child>"
"                            <child>"
"                              <widget class=\"GtkAlignment\" id=\"header_alignment\">"
"                                <property name=\"visible\">True</property>"
"                                <property name=\"moo_sensitive\">print_header</property>"
"                                <child>"
"                                  <widget class=\"GtkVBox\" id=\"vbox2\">"
"                                    <property name=\"visible\">True</property>"
"                                    <property name=\"spacing\">6</property>"
"                                    <child>"
"                                      <widget class=\"GtkCheckButton\" id=\"header_separator\">"
"                                        <property name=\"visible\">True</property>"
"                                        <property name=\"label\" translatable=\"yes\">Print separator line</property>"
"                                        <property name=\"use_underline\">True</property>"
"                                        <property name=\"response_id\">0</property>"
"                                        <property name=\"draw_indicator\">True</property>"
"                                      </widget>"
"                                      <packing>"
"                                        <property name=\"expand\">False</property>"
"                                        <property name=\"fill\">False</property>"
"                                      </packing>"
"                                    </child>"
"                                    <child>"
"                                      <widget class=\"GtkTable\" id=\"table1\">"
"                                        <property name=\"visible\">True</property>"
"                                        <property name=\"n_rows\">3</property>"
"                                        <property name=\"n_columns\">2</property>"
"                                        <property name=\"column_spacing\">12</property>"
"                                        <property name=\"row_spacing\">6</property>"
"                                        <child>"
"                                          <widget class=\"GtkEntry\" id=\"header_right\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"tooltip\">Format is similar to that of strftime (3), with the following additions:"
"%Ef - printed document name;"
"%EF - full path of printed document;"
"%Ep - current page number;"
"%EP - total number of pages.</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"left_attach\">1</property>"
"                                            <property name=\"right_attach\">2</property>"
"                                            <property name=\"top_attach\">2</property>"
"                                            <property name=\"bottom_attach\">3</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkEntry\" id=\"header_center\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"tooltip\">Format is similar to that of strftime (3), with the following additions:"
"%Ef - printed document name;"
"%EF - full path of printed document;"
"%Ep - current page number;"
"%EP - total number of pages.</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"left_attach\">1</property>"
"                                            <property name=\"right_attach\">2</property>"
"                                            <property name=\"top_attach\">1</property>"
"                                            <property name=\"bottom_attach\">2</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkEntry\" id=\"header_left\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"tooltip\">Format is similar to that of strftime (3), with the following additions:"
"%Ef - printed document name;"
"%EF - full path of printed document;"
"%Ep - current page number;"
"%EP - total number of pages.</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"left_attach\">1</property>"
"                                            <property name=\"right_attach\">2</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkLabel\" id=\"label5\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"xalign\">0</property>"
"                                            <property name=\"label\" translatable=\"yes\">Right:</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"top_attach\">2</property>"
"                                            <property name=\"bottom_attach\">3</property>"
"                                            <property name=\"x_options\">GTK_FILL</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkLabel\" id=\"label4\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"xalign\">0</property>"
"                                            <property name=\"label\" translatable=\"yes\">Center:</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"top_attach\">1</property>"
"                                            <property name=\"bottom_attach\">2</property>"
"                                            <property name=\"x_options\">GTK_FILL</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkLabel\" id=\"label3\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"xalign\">0</property>"
"                                            <property name=\"label\" translatable=\"yes\">Left:</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"x_options\">GTK_FILL</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                      </widget>"
"                                      <packing>"
"                                        <property name=\"expand\">False</property>"
"                                        <property name=\"position\">1</property>"
"                                      </packing>"
"                                    </child>"
"                                  </widget>"
"                                </child>"
"                              </widget>"
"                              <packing>"
"                                <property name=\"position\">1</property>"
"                              </packing>"
"                            </child>"
"                          </widget>"
"                        </child>"
"                      </widget>"
"                    </child>"
"                    <child>"
"                      <widget class=\"GtkLabel\" id=\"label1\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"label\" translatable=\"yes\">Header</property>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"tab_fill\">False</property>"
"                        <property name=\"type\">tab</property>"
"                      </packing>"
"                    </child>"
"                    <child>"
"                      <widget class=\"GtkAlignment\" id=\"alignment3\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"top_padding\">6</property>"
"                        <property name=\"bottom_padding\">6</property>"
"                        <property name=\"left_padding\">6</property>"
"                        <property name=\"right_padding\">6</property>"
"                        <child>"
"                          <widget class=\"GtkVBox\" id=\"vbox7\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"spacing\">6</property>"
"                            <child>"
"                              <widget class=\"GtkCheckButton\" id=\"print_footer\">"
"                                <property name=\"visible\">True</property>"
"                                <property name=\"label\" translatable=\"yes\">Print footer</property>"
"                                <property name=\"use_underline\">True</property>"
"                                <property name=\"response_id\">0</property>"
"                                <property name=\"draw_indicator\">True</property>"
"                              </widget>"
"                              <packing>"
"                                <property name=\"expand\">False</property>"
"                                <property name=\"fill\">False</property>"
"                              </packing>"
"                            </child>"
"                            <child>"
"                              <widget class=\"GtkAlignment\" id=\"footer_alignment\">"
"                                <property name=\"visible\">True</property>"
"                                <property name=\"moo_sensitive\">print_header</property>"
"                                <child>"
"                                  <widget class=\"GtkVBox\" id=\"vbox8\">"
"                                    <property name=\"visible\">True</property>"
"                                    <property name=\"spacing\">6</property>"
"                                    <child>"
"                                      <widget class=\"GtkCheckButton\" id=\"footer_separator\">"
"                                        <property name=\"visible\">True</property>"
"                                        <property name=\"label\" translatable=\"yes\">Print separator line</property>"
"                                        <property name=\"use_underline\">True</property>"
"                                        <property name=\"response_id\">0</property>"
"                                        <property name=\"draw_indicator\">True</property>"
"                                      </widget>"
"                                      <packing>"
"                                        <property name=\"expand\">False</property>"
"                                        <property name=\"fill\">False</property>"
"                                      </packing>"
"                                    </child>"
"                                    <child>"
"                                      <widget class=\"GtkTable\" id=\"table4\">"
"                                        <property name=\"visible\">True</property>"
"                                        <property name=\"n_rows\">3</property>"
"                                        <property name=\"n_columns\">2</property>"
"                                        <property name=\"column_spacing\">12</property>"
"                                        <property name=\"row_spacing\">6</property>"
"                                        <child>"
"                                          <widget class=\"GtkEntry\" id=\"footer_right\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"tooltip\">Format is similar to that of strftime (3), with the following additions:"
"%Ef - printed document name;"
"%EF - full path of printed document;"
"%Ep - current page number;"
"%EP - total number of pages.</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"left_attach\">1</property>"
"                                            <property name=\"right_attach\">2</property>"
"                                            <property name=\"top_attach\">2</property>"
"                                            <property name=\"bottom_attach\">3</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkEntry\" id=\"footer_center\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"tooltip\">Format is similar to that of strftime (3), with the following additions:"
"%Ef - printed document name;"
"%EF - full path of printed document;"
"%Ep - current page number;"
"%EP - total number of pages.</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"left_attach\">1</property>"
"                                            <property name=\"right_attach\">2</property>"
"                                            <property name=\"top_attach\">1</property>"
"                                            <property name=\"bottom_attach\">2</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkEntry\" id=\"footer_left\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"tooltip\">Format is similar to that of strftime (3), with the following additions:"
"%Ef - printed document name;"
"%EF - full path of printed document;"
"%Ep - current page number;"
"%EP - total number of pages.</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"left_attach\">1</property>"
"                                            <property name=\"right_attach\">2</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkLabel\" id=\"label14\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"xalign\">0</property>"
"                                            <property name=\"label\" translatable=\"yes\">Right:</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"top_attach\">2</property>"
"                                            <property name=\"bottom_attach\">3</property>"
"                                            <property name=\"x_options\">GTK_FILL</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkLabel\" id=\"label15\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"xalign\">0</property>"
"                                            <property name=\"label\" translatable=\"yes\">Center:</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"top_attach\">1</property>"
"                                            <property name=\"bottom_attach\">2</property>"
"                                            <property name=\"x_options\">GTK_FILL</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                        <child>"
"                                          <widget class=\"GtkLabel\" id=\"label16\">"
"                                            <property name=\"visible\">True</property>"
"                                            <property name=\"xalign\">0</property>"
"                                            <property name=\"label\" translatable=\"yes\">Left:</property>"
"                                          </widget>"
"                                          <packing>"
"                                            <property name=\"x_options\">GTK_FILL</property>"
"                                            <property name=\"y_options\"></property>"
"                                          </packing>"
"                                        </child>"
"                                      </widget>"
"                                      <packing>"
"                                        <property name=\"expand\">False</property>"
"                                        <property name=\"position\">1</property>"
"                                      </packing>"
"                                    </child>"
"                                  </widget>"
"                                </child>"
"                              </widget>"
"                              <packing>"
"                                <property name=\"position\">1</property>"
"                              </packing>"
"                            </child>"
"                          </widget>"
"                        </child>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"position\">1</property>"
"                      </packing>"
"                    </child>"
"                    <child>"
"                      <widget class=\"GtkLabel\" id=\"label2\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"label\" translatable=\"yes\">Footer</property>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"position\">1</property>"
"                        <property name=\"tab_fill\">False</property>"
"                        <property name=\"type\">tab</property>"
"                      </packing>"
"                    </child>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">5</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"position\">2</property>"
"          </packing>"
"        </child>"
"        <child internal-child=\"action_area\">"
"          <widget class=\"GtkHButtonBox\" id=\"dialog-action_area1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"layout_style\">GTK_BUTTONBOX_END</property>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"cancelbutton1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"label\">gtk-cancel</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"focus_on_click\">False</property>"
"                <property name=\"response_id\">-6</property>"
"              </widget>"
"            </child>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"okbutton1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"label\">gtk-ok</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"focus_on_click\">False</property>"
"                <property name=\"response_id\">-5</property>"
"              </widget>"
"              <packing>"
"                <property name=\"position\">1</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"expand\">False</property>"
"            <property name=\"pack_type\">GTK_PACK_END</property>"
"          </packing>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct PrintWidgetXml PrintWidgetXml;

struct PrintWidgetXml {
    MooGladeXML *xml;

    GtkAlignment *PrintWidget;
    GtkVBox *vbox;
    GtkCheckButton *use_styles;
    GtkCheckButton *use_custom_font;
    GtkFontButton *font;
    GtkCheckButton *wrap;
    GtkCheckButton *ellipsize;
    GtkCheckButton *line_numbers;
    GtkHBox *line_numbers_hbox;
    GtkSpinButton *line_numbers_step;
    GtkCheckButton *print_header;
    GtkAlignment *header_alignment;
    GtkCheckButton *header_separator;
    GtkEntry *header_right;
    GtkEntry *header_center;
    GtkEntry *header_left;
    GtkCheckButton *print_footer;
    GtkAlignment *footer_alignment;
    GtkCheckButton *footer_separator;
    GtkEntry *footer_right;
    GtkEntry *footer_center;
    GtkEntry *footer_left;
};

static void
_print_widget_xml_free (PrintWidgetXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static PrintWidgetXml *
print_widget_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
print_widget_xml_build (PrintWidgetXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _print_widget_xml_glade_xml, -1, "PrintWidget", NULL);
    xml->PrintWidget = moo_glade_xml_get_widget (xml->xml, "PrintWidget");
    xml->vbox = moo_glade_xml_get_widget (xml->xml, "vbox");
    xml->use_styles = moo_glade_xml_get_widget (xml->xml, "use_styles");
    xml->use_custom_font = moo_glade_xml_get_widget (xml->xml, "use_custom_font");
    xml->font = moo_glade_xml_get_widget (xml->xml, "font");
    xml->wrap = moo_glade_xml_get_widget (xml->xml, "wrap");
    xml->ellipsize = moo_glade_xml_get_widget (xml->xml, "ellipsize");
    xml->line_numbers = moo_glade_xml_get_widget (xml->xml, "line_numbers");
    xml->line_numbers_hbox = moo_glade_xml_get_widget (xml->xml, "line_numbers_hbox");
    xml->line_numbers_step = moo_glade_xml_get_widget (xml->xml, "line_numbers_step");
    xml->print_header = moo_glade_xml_get_widget (xml->xml, "print_header");
    xml->header_alignment = moo_glade_xml_get_widget (xml->xml, "header_alignment");
    xml->header_separator = moo_glade_xml_get_widget (xml->xml, "header_separator");
    xml->header_right = moo_glade_xml_get_widget (xml->xml, "header_right");
    xml->header_center = moo_glade_xml_get_widget (xml->xml, "header_center");
    xml->header_left = moo_glade_xml_get_widget (xml->xml, "header_left");
    xml->print_footer = moo_glade_xml_get_widget (xml->xml, "print_footer");
    xml->footer_alignment = moo_glade_xml_get_widget (xml->xml, "footer_alignment");
    xml->footer_separator = moo_glade_xml_get_widget (xml->xml, "footer_separator");
    xml->footer_right = moo_glade_xml_get_widget (xml->xml, "footer_right");
    xml->footer_center = moo_glade_xml_get_widget (xml->xml, "footer_center");
    xml->footer_left = moo_glade_xml_get_widget (xml->xml, "footer_left");
    g_object_set_data_full (G_OBJECT (xml->PrintWidget), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _print_widget_xml_free);
}

static PrintWidgetXml *
print_widget_xml_new_empty (void)
{
    PrintWidgetXml *xml = g_new0 (PrintWidgetXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static PrintWidgetXml *
print_widget_xml_new (void)
{
    PrintWidgetXml *xml = print_widget_xml_new_empty ();
    print_widget_xml_build (xml);
    return xml;
}
