#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _editor_statusbar_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkWindow\" id=\"window1\">"
"    <child>"
"      <widget class=\"GtkFrame\" id=\"EditorStatusbar\">"
"        <property name=\"visible\">True</property>"
"        <property name=\"label_xalign\">0</property>"
"        <child>"
"          <widget class=\"GtkAlignment\" id=\"alignment1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"left_padding\">6</property>"
"            <property name=\"right_padding\">6</property>"
"            <child>"
"              <widget class=\"GtkHBox\" id=\"info\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"spacing\">12</property>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"cursor\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"label\">Line: 10  Col: 100</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"chars\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"events\"></property>"
"                    <property name=\"label\">Chars: 10000</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"position\">1</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"insert\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"label\">INS</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">2</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"            </child>"
"          </widget>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct EditorStatusbarXml EditorStatusbarXml;

struct EditorStatusbarXml {
    MooGladeXML *xml;

    GtkFrame *EditorStatusbar;
    GtkHBox *info;
    GtkLabel *cursor;
    GtkLabel *chars;
    GtkLabel *insert;
};

static void
_editor_statusbar_xml_free (EditorStatusbarXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static EditorStatusbarXml *
editor_statusbar_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
editor_statusbar_xml_build (EditorStatusbarXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _editor_statusbar_xml_glade_xml, -1, "EditorStatusbar", NULL);
    xml->EditorStatusbar = moo_glade_xml_get_widget (xml->xml, "EditorStatusbar");
    xml->info = moo_glade_xml_get_widget (xml->xml, "info");
    xml->cursor = moo_glade_xml_get_widget (xml->xml, "cursor");
    xml->chars = moo_glade_xml_get_widget (xml->xml, "chars");
    xml->insert = moo_glade_xml_get_widget (xml->xml, "insert");
    g_object_set_data_full (G_OBJECT (xml->EditorStatusbar), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _editor_statusbar_xml_free);
}

static EditorStatusbarXml *
editor_statusbar_xml_new_empty (void)
{
    EditorStatusbarXml *xml = g_new0 (EditorStatusbarXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static EditorStatusbarXml *
editor_statusbar_xml_new (void)
{
    EditorStatusbarXml *xml = editor_statusbar_xml_new_empty ();
    editor_statusbar_xml_build (xml);
    return xml;
}
