#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _moo_find_box_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkDialog\" id=\"dialog1\">"
"    <property name=\"title\">Find</property>"
"    <property name=\"window_position\">GTK_WIN_POS_CENTER_ON_PARENT</property>"
"    <property name=\"destroy_with_parent\">True</property>"
"    <property name=\"type_hint\">GDK_WINDOW_TYPE_HINT_DIALOG</property>"
"    <property name=\"has_separator\">False</property>"
"    <child internal-child=\"vbox\">"
"      <widget class=\"GtkVBox\" id=\"dialog-vbox1\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkVBox\" id=\"MooFindBox\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"border_width\">3</property>"
"            <property name=\"spacing\">3</property>"
"            <child>"
"              <widget class=\"GtkFrame\" id=\"find_frame\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"label_xalign\">0</property>"
"                <child>"
"                  <widget class=\"GtkAlignment\" id=\"alignment1\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"top_padding\">6</property>"
"                    <property name=\"bottom_padding\">6</property>"
"                    <property name=\"left_padding\">6</property>"
"                    <property name=\"right_padding\">6</property>"
"                    <child>"
"                      <widget class=\"GtkVBox\" id=\"vbox2\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"spacing\">3</property>"
"                        <child>"
"                          <widget class=\"GtkLabel\" id=\"label3\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"xalign\">0</property>"
"                            <property name=\"label\" translatable=\"yes\">Text to find:</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkEntry\" id=\"search_entry:MooHistoryCombo\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"activates_default\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                            <property name=\"position\">1</property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkHBox\" id=\"hbox1\">"
"                            <property name=\"visible\">True</property>"
"                            <child>"
"                              <widget class=\"GtkCheckButton\" id=\"regex\">"
"                                <property name=\"visible\">True</property>"
"                                <property name=\"label\" translatable=\"yes\">Regular expression</property>"
"                                <property name=\"use_underline\">True</property>"
"                                <property name=\"focus_on_click\">False</property>"
"                                <property name=\"response_id\">0</property>"
"                                <property name=\"draw_indicator\">True</property>"
"                              </widget>"
"                            </child>"
"                            <child>"
"                              <widget class=\"GtkButton\" id=\"edit\">"
"                                <property name=\"label\">  Edit...  </property>"
"                                <property name=\"use_underline\">True</property>"
"                                <property name=\"focus_on_click\">False</property>"
"                                <property name=\"response_id\">0</property>"
"                              </widget>"
"                              <packing>"
"                                <property name=\"expand\">False</property>"
"                                <property name=\"fill\">False</property>"
"                                <property name=\"position\">1</property>"
"                              </packing>"
"                            </child>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                            <property name=\"position\">2</property>"
"                          </packing>"
"                        </child>"
"                      </widget>"
"                    </child>"
"                  </widget>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"label1\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"label\" translatable=\"yes\">Find</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"type\">label_item</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"              <packing>"
"                <property name=\"expand\">False</property>"
"                <property name=\"fill\">False</property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkFrame\" id=\"replace_frame\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"label_xalign\">0</property>"
"                <child>"
"                  <widget class=\"GtkAlignment\" id=\"alignment3\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"top_padding\">6</property>"
"                    <property name=\"bottom_padding\">6</property>"
"                    <property name=\"left_padding\">6</property>"
"                    <property name=\"right_padding\">6</property>"
"                    <child>"
"                      <widget class=\"GtkVBox\" id=\"vbox3\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"spacing\">3</property>"
"                        <child>"
"                          <widget class=\"GtkLabel\" id=\"label4\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"xalign\">0</property>"
"                            <property name=\"label\" translatable=\"yes\">Replacement text:</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkEntry\" id=\"replace_entry:MooHistoryCombo\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"activates_default\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                            <property name=\"position\">1</property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkHBox\" id=\"hbox2\">"
"                            <property name=\"visible\">True</property>"
"                            <child>"
"                              <widget class=\"GtkCheckButton\" id=\"repl_literal\">"
"                                <property name=\"visible\">True</property>"
"                                <property name=\"label\" translatable=\"yes\">Literal replacement</property>"
"                                <property name=\"use_underline\">True</property>"
"                                <property name=\"focus_on_click\">False</property>"
"                                <property name=\"response_id\">0</property>"
"                                <property name=\"draw_indicator\">True</property>"
"                              </widget>"
"                            </child>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                            <property name=\"position\">2</property>"
"                          </packing>"
"                        </child>"
"                      </widget>"
"                    </child>"
"                  </widget>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"label5\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"label\" translatable=\"yes\">Replace With</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"type\">label_item</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"              <packing>"
"                <property name=\"expand\">False</property>"
"                <property name=\"fill\">False</property>"
"                <property name=\"position\">1</property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkFrame\" id=\"options_frame\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"label_xalign\">0</property>"
"                <child>"
"                  <widget class=\"GtkAlignment\" id=\"alignment2\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"top_padding\">3</property>"
"                    <property name=\"bottom_padding\">3</property>"
"                    <property name=\"left_padding\">3</property>"
"                    <property name=\"right_padding\">3</property>"
"                    <child>"
"                      <widget class=\"GtkTable\" id=\"table1\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"n_rows\">3</property>"
"                        <property name=\"n_columns\">2</property>"
"                        <property name=\"column_spacing\">3</property>"
"                        <child>"
"                          <widget class=\"GtkCheckButton\" id=\"dont_prompt\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\" translatable=\"yes\">Don't prompt on replace</property>"
"                            <property name=\"use_underline\">True</property>"
"                            <property name=\"focus_on_click\">False</property>"
"                            <property name=\"response_id\">0</property>"
"                            <property name=\"draw_indicator\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"left_attach\">1</property>"
"                            <property name=\"right_attach\">2</property>"
"                            <property name=\"top_attach\">2</property>"
"                            <property name=\"bottom_attach\">3</property>"
"                            <property name=\"x_options\">GTK_FILL</property>"
"                            <property name=\"y_options\"></property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkCheckButton\" id=\"backwards\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\" translatable=\"yes\">Find backwards</property>"
"                            <property name=\"use_underline\">True</property>"
"                            <property name=\"focus_on_click\">False</property>"
"                            <property name=\"response_id\">0</property>"
"                            <property name=\"draw_indicator\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"left_attach\">1</property>"
"                            <property name=\"right_attach\">2</property>"
"                            <property name=\"y_options\"></property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkCheckButton\" id=\"case_sensitive\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\" translatable=\"yes\">Case sensitive</property>"
"                            <property name=\"use_underline\">True</property>"
"                            <property name=\"focus_on_click\">False</property>"
"                            <property name=\"response_id\">0</property>"
"                            <property name=\"draw_indicator\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"y_options\"></property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkCheckButton\" id=\"selected\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\" translatable=\"yes\">Selected text</property>"
"                            <property name=\"use_underline\">True</property>"
"                            <property name=\"focus_on_click\">False</property>"
"                            <property name=\"response_id\">0</property>"
"                            <property name=\"draw_indicator\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"left_attach\">1</property>"
"                            <property name=\"right_attach\">2</property>"
"                            <property name=\"top_attach\">1</property>"
"                            <property name=\"bottom_attach\">2</property>"
"                            <property name=\"x_options\">GTK_FILL</property>"
"                            <property name=\"y_options\"></property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkCheckButton\" id=\"from_cursor\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\" translatable=\"yes\">From cursor</property>"
"                            <property name=\"use_underline\">True</property>"
"                            <property name=\"focus_on_click\">False</property>"
"                            <property name=\"response_id\">0</property>"
"                            <property name=\"draw_indicator\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"top_attach\">2</property>"
"                            <property name=\"bottom_attach\">3</property>"
"                            <property name=\"x_options\">GTK_FILL</property>"
"                            <property name=\"y_options\"></property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkCheckButton\" id=\"whole_words\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\" translatable=\"yes\">Whole words only</property>"
"                            <property name=\"use_underline\">True</property>"
"                            <property name=\"focus_on_click\">False</property>"
"                            <property name=\"response_id\">0</property>"
"                            <property name=\"draw_indicator\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"top_attach\">1</property>"
"                            <property name=\"bottom_attach\">2</property>"
"                            <property name=\"x_options\">GTK_FILL</property>"
"                            <property name=\"y_options\"></property>"
"                          </packing>"
"                        </child>"
"                      </widget>"
"                    </child>"
"                  </widget>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"label2\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"label\" translatable=\"yes\">Options</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"type\">label_item</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"              <packing>"
"                <property name=\"expand\">False</property>"
"                <property name=\"fill\">False</property>"
"                <property name=\"position\">2</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"position\">1</property>"
"          </packing>"
"        </child>"
"        <child internal-child=\"action_area\">"
"          <widget class=\"GtkHButtonBox\" id=\"dialog-action_area1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"layout_style\">GTK_BUTTONBOX_END</property>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"cancel_btn\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"label\">gtk-cancel</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"focus_on_click\">False</property>"
"                <property name=\"response_id\">-6</property>"
"              </widget>"
"            </child>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"ok_btn\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"has_default\">True</property>"
"                <property name=\"label\">gtk-find</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"focus_on_click\">False</property>"
"                <property name=\"response_id\">-5</property>"
"              </widget>"
"              <packing>"
"                <property name=\"position\">1</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"expand\">False</property>"
"            <property name=\"pack_type\">GTK_PACK_END</property>"
"          </packing>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct MooFindBoxXml MooFindBoxXml;

struct MooFindBoxXml {
    MooGladeXML *xml;

    GtkVBox *MooFindBox;
    GtkFrame *find_frame;
    MooHistoryCombo *search_entry;
    GtkCheckButton *regex;
    GtkButton *edit;
    GtkFrame *replace_frame;
    MooHistoryCombo *replace_entry;
    GtkCheckButton *repl_literal;
    GtkFrame *options_frame;
    GtkCheckButton *dont_prompt;
    GtkCheckButton *backwards;
    GtkCheckButton *case_sensitive;
    GtkCheckButton *selected;
    GtkCheckButton *from_cursor;
    GtkCheckButton *whole_words;
};

static void
_moo_find_box_xml_free (MooFindBoxXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static MooFindBoxXml *
moo_find_box_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
moo_find_box_xml_build (MooFindBoxXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _moo_find_box_xml_glade_xml, -1, "MooFindBox", NULL);
    xml->MooFindBox = moo_glade_xml_get_widget (xml->xml, "MooFindBox");
    xml->find_frame = moo_glade_xml_get_widget (xml->xml, "find_frame");
    xml->search_entry = moo_glade_xml_get_widget (xml->xml, "search_entry:MooHistoryCombo");
    xml->regex = moo_glade_xml_get_widget (xml->xml, "regex");
    xml->edit = moo_glade_xml_get_widget (xml->xml, "edit");
    xml->replace_frame = moo_glade_xml_get_widget (xml->xml, "replace_frame");
    xml->replace_entry = moo_glade_xml_get_widget (xml->xml, "replace_entry:MooHistoryCombo");
    xml->repl_literal = moo_glade_xml_get_widget (xml->xml, "repl_literal");
    xml->options_frame = moo_glade_xml_get_widget (xml->xml, "options_frame");
    xml->dont_prompt = moo_glade_xml_get_widget (xml->xml, "dont_prompt");
    xml->backwards = moo_glade_xml_get_widget (xml->xml, "backwards");
    xml->case_sensitive = moo_glade_xml_get_widget (xml->xml, "case_sensitive");
    xml->selected = moo_glade_xml_get_widget (xml->xml, "selected");
    xml->from_cursor = moo_glade_xml_get_widget (xml->xml, "from_cursor");
    xml->whole_words = moo_glade_xml_get_widget (xml->xml, "whole_words");
    g_object_set_data_full (G_OBJECT (xml->MooFindBox), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _moo_find_box_xml_free);
}

static MooFindBoxXml *
moo_find_box_xml_new_empty (void)
{
    MooFindBoxXml *xml = g_new0 (MooFindBoxXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static MooFindBoxXml *
moo_find_box_xml_new (void)
{
    MooFindBoxXml *xml = moo_find_box_xml_new_empty ();
    moo_find_box_xml_build (xml);
    return xml;
}
