#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _save_as_dialog_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkDialog\" id=\"SaveAsDialog\">"
"    <property name=\"title\" translatable=\"yes\">Save As</property>"
"    <property name=\"window_position\">GTK_WIN_POS_MOUSE</property>"
"    <property name=\"type_hint\">GDK_WINDOW_TYPE_HINT_DIALOG</property>"
"    <property name=\"has_separator\">False</property>"
"    <child internal-child=\"vbox\">"
"      <widget class=\"GtkVBox\" id=\"dialog-vbox1\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkAlignment\" id=\"alignment1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"top_padding\">6</property>"
"            <property name=\"bottom_padding\">6</property>"
"            <property name=\"left_padding\">6</property>"
"            <property name=\"right_padding\">6</property>"
"            <child>"
"              <widget class=\"GtkVBox\" id=\"vbox1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"spacing\">6</property>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"label1\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"xalign\">0</property>"
"                    <property name=\"label\" translatable=\"yes\">Save as</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkEntry\" id=\"entry:MooEntry\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"can_focus\">True</property>"
"                    <property name=\"activates_default\">True</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">1</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"position\">1</property>"
"          </packing>"
"        </child>"
"        <child internal-child=\"action_area\">"
"          <widget class=\"GtkHButtonBox\" id=\"dialog-action_area1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"layout_style\">GTK_BUTTONBOX_END</property>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"cancelbutton1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"label\">gtk-cancel</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"response_id\">-6</property>"
"              </widget>"
"            </child>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"ok_button\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"has_default\">True</property>"
"                <property name=\"label\">gtk-ok</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"response_id\">-5</property>"
"              </widget>"
"              <packing>"
"                <property name=\"position\">1</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"expand\">False</property>"
"            <property name=\"pack_type\">GTK_PACK_END</property>"
"          </packing>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct SaveAsDialogXml SaveAsDialogXml;

struct SaveAsDialogXml {
    MooGladeXML *xml;

    GtkDialog *SaveAsDialog;
    MooEntry *entry;
    GtkButton *ok_button;
};

static void
_save_as_dialog_xml_free (SaveAsDialogXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static SaveAsDialogXml *
save_as_dialog_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
save_as_dialog_xml_build (SaveAsDialogXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _save_as_dialog_xml_glade_xml, -1, "SaveAsDialog", NULL);
    xml->SaveAsDialog = moo_glade_xml_get_widget (xml->xml, "SaveAsDialog");
    xml->entry = moo_glade_xml_get_widget (xml->xml, "entry:MooEntry");
    xml->ok_button = moo_glade_xml_get_widget (xml->xml, "ok_button");
    g_object_set_data_full (G_OBJECT (xml->SaveAsDialog), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _save_as_dialog_xml_free);
}

static SaveAsDialogXml *
save_as_dialog_xml_new_empty (void)
{
    SaveAsDialogXml *xml = g_new0 (SaveAsDialogXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static SaveAsDialogXml *
save_as_dialog_xml_new (void)
{
    SaveAsDialogXml *xml = save_as_dialog_xml_new_empty ();
    save_as_dialog_xml_build (xml);
    return xml;
}
