#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _bk_editor_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkDialog\" id=\"BkEditor\">"
"    <property name=\"title\" translatable=\"yes\">Edit Bookmarks</property>"
"    <property name=\"default_width\">400</property>"
"    <property name=\"default_height\">300</property>"
"    <property name=\"type_hint\">GDK_WINDOW_TYPE_HINT_DIALOG</property>"
"    <child internal-child=\"vbox\">"
"      <widget class=\"GtkVBox\" id=\"dialog-vbox1\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkTable\" id=\"table1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"n_rows\">3</property>"
"            <property name=\"n_columns\">1</property>"
"            <child>"
"              <widget class=\"GtkHBox\" id=\"selected_hbox\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"spacing\">6</property>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"label1\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"label\" translatable=\"yes\">Icon:</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkComboBox\" id=\"icon_combo\">"
"                    <property name=\"visible\">True</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">1</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"label3\">"
"                    <property name=\"xalign\">0</property>"
"                    <property name=\"label\" translatable=\"yes\">Path:</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">2</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"path_label\">"
"                    <property name=\"label\">/home/muntyan/</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">3</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkEventBox\" id=\"file_button_holder\">"
"                    <child>"
"                      <placeholder/>"
"                    </child>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">4</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"              <packing>"
"                <property name=\"top_attach\">2</property>"
"                <property name=\"bottom_attach\">3</property>"
"                <property name=\"x_options\">GTK_FILL</property>"
"                <property name=\"y_options\"></property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkAlignment\" id=\"alignment2\">"
"                <property name=\"visible\">True</property>"
"                <child>"
"                  <widget class=\"GtkHBox\" id=\"hbox1\">"
"                    <property name=\"visible\">True</property>"
"                    <child>"
"                      <widget class=\"GtkButton\" id=\"new_button\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"tooltip\" translatable=\"yes\">Add bookmark</property>"
"                        <property name=\"focus_on_click\">False</property>"
"                        <property name=\"response_id\">0</property>"
"                        <child>"
"                          <widget class=\"GtkAlignment\" id=\"alignment3\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"xscale\">0</property>"
"                            <property name=\"yscale\">0</property>"
"                            <child>"
"                              <widget class=\"GtkHBox\" id=\"hbox2\">"
"                                <property name=\"visible\">True</property>"
"                                <property name=\"spacing\">2</property>"
"                                <child>"
"                                  <widget class=\"GtkImage\" id=\"image7\">"
"                                    <property name=\"visible\">True</property>"
"                                    <property name=\"stock\">gtk-new</property>"
"                                  </widget>"
"                                  <packing>"
"                                    <property name=\"expand\">False</property>"
"                                    <property name=\"fill\">False</property>"
"                                  </packing>"
"                                </child>"
"                                <child>"
"                                  <widget class=\"GtkLabel\" id=\"label4\">"
"                                    <property name=\"visible\">True</property>"
"                                    <property name=\"label\" translatable=\"yes\">New</property>"
"                                    <property name=\"use_underline\">True</property>"
"                                  </widget>"
"                                  <packing>"
"                                    <property name=\"expand\">False</property>"
"                                    <property name=\"fill\">False</property>"
"                                    <property name=\"position\">1</property>"
"                                  </packing>"
"                                </child>"
"                              </widget>"
"                            </child>"
"                          </widget>"
"                        </child>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"expand\">False</property>"
"                        <property name=\"fill\">False</property>"
"                      </packing>"
"                    </child>"
"                    <child>"
"                      <widget class=\"GtkButton\" id=\"separator_button\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"tooltip\" translatable=\"yes\">Add separator</property>"
"                        <property name=\"label\" translatable=\"yes\">Add Separator</property>"
"                        <property name=\"use_underline\">True</property>"
"                        <property name=\"focus_on_click\">False</property>"
"                        <property name=\"response_id\">0</property>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"expand\">False</property>"
"                        <property name=\"fill\">False</property>"
"                        <property name=\"position\">1</property>"
"                      </packing>"
"                    </child>"
"                    <child>"
"                      <widget class=\"GtkVSeparator\" id=\"vseparator2\">"
"                        <property name=\"visible\">True</property>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"expand\">False</property>"
"                        <property name=\"fill\">False</property>"
"                        <property name=\"position\">2</property>"
"                      </packing>"
"                    </child>"
"                    <child>"
"                      <widget class=\"GtkButton\" id=\"delete_button\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"tooltip\" translatable=\"yes\">Delete selected items</property>"
"                        <property name=\"focus_on_click\">False</property>"
"                        <property name=\"response_id\">0</property>"
"                        <child>"
"                          <widget class=\"GtkAlignment\" id=\"alignment4\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"xscale\">0</property>"
"                            <property name=\"yscale\">0</property>"
"                            <child>"
"                              <widget class=\"GtkHBox\" id=\"hbox3\">"
"                                <property name=\"visible\">True</property>"
"                                <property name=\"spacing\">2</property>"
"                                <child>"
"                                  <widget class=\"GtkImage\" id=\"image8\">"
"                                    <property name=\"visible\">True</property>"
"                                    <property name=\"stock\">gtk-delete</property>"
"                                  </widget>"
"                                  <packing>"
"                                    <property name=\"expand\">False</property>"
"                                    <property name=\"fill\">False</property>"
"                                  </packing>"
"                                </child>"
"                                <child>"
"                                  <widget class=\"GtkLabel\" id=\"label5\">"
"                                    <property name=\"visible\">True</property>"
"                                    <property name=\"label\" translatable=\"yes\">Delete</property>"
"                                    <property name=\"use_underline\">True</property>"
"                                  </widget>"
"                                  <packing>"
"                                    <property name=\"expand\">False</property>"
"                                    <property name=\"fill\">False</property>"
"                                    <property name=\"position\">1</property>"
"                                  </packing>"
"                                </child>"
"                              </widget>"
"                            </child>"
"                          </widget>"
"                        </child>"
"                      </widget>"
"                      <packing>"
"                        <property name=\"expand\">False</property>"
"                        <property name=\"fill\">False</property>"
"                        <property name=\"position\">3</property>"
"                      </packing>"
"                    </child>"
"                  </widget>"
"                </child>"
"              </widget>"
"              <packing>"
"                <property name=\"y_options\"></property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkScrolledWindow\" id=\"scrolledwindow\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_focus\">False</property>"
"                <property name=\"hscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"                <property name=\"vscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"                <property name=\"shadow_type\">GTK_SHADOW_ETCHED_IN</property>"
"                <child>"
"                  <widget class=\"GtkTreeView\" id=\"treeview\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"has_focus\">True</property>"
"                    <property name=\"reorderable\">True</property>"
"                    <property name=\"rules_hint\">True</property>"
"                  </widget>"
"                </child>"
"              </widget>"
"              <packing>"
"                <property name=\"top_attach\">1</property>"
"                <property name=\"bottom_attach\">2</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"position\">2</property>"
"          </packing>"
"        </child>"
"        <child internal-child=\"action_area\">"
"          <widget class=\"GtkHButtonBox\" id=\"dialog-action_area1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"layout_style\">GTK_BUTTONBOX_END</property>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"cancelbutton1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"label\">gtk-cancel</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"response_id\">-6</property>"
"              </widget>"
"            </child>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"okbutton1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"has_default\">True</property>"
"                <property name=\"label\">gtk-ok</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"response_id\">-5</property>"
"              </widget>"
"              <packing>"
"                <property name=\"position\">1</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"expand\">False</property>"
"            <property name=\"pack_type\">GTK_PACK_END</property>"
"          </packing>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct BkEditorXml BkEditorXml;

struct BkEditorXml {
    MooGladeXML *xml;

    GtkDialog *BkEditor;
    GtkHBox *selected_hbox;
    GtkComboBox *icon_combo;
    GtkLabel *path_label;
    GtkEventBox *file_button_holder;
    GtkButton *new_button;
    GtkButton *separator_button;
    GtkButton *delete_button;
    GtkScrolledWindow *scrolledwindow;
    GtkTreeView *treeview;
};

static void
_bk_editor_xml_free (BkEditorXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static BkEditorXml *
bk_editor_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
bk_editor_xml_build (BkEditorXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _bk_editor_xml_glade_xml, -1, "BkEditor", NULL);
    xml->BkEditor = moo_glade_xml_get_widget (xml->xml, "BkEditor");
    xml->selected_hbox = moo_glade_xml_get_widget (xml->xml, "selected_hbox");
    xml->icon_combo = moo_glade_xml_get_widget (xml->xml, "icon_combo");
    xml->path_label = moo_glade_xml_get_widget (xml->xml, "path_label");
    xml->file_button_holder = moo_glade_xml_get_widget (xml->xml, "file_button_holder");
    xml->new_button = moo_glade_xml_get_widget (xml->xml, "new_button");
    xml->separator_button = moo_glade_xml_get_widget (xml->xml, "separator_button");
    xml->delete_button = moo_glade_xml_get_widget (xml->xml, "delete_button");
    xml->scrolledwindow = moo_glade_xml_get_widget (xml->xml, "scrolledwindow");
    xml->treeview = moo_glade_xml_get_widget (xml->xml, "treeview");
    g_object_set_data_full (G_OBJECT (xml->BkEditor), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _bk_editor_xml_free);
}

static BkEditorXml *
bk_editor_xml_new_empty (void)
{
    BkEditorXml *xml = g_new0 (BkEditorXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static BkEditorXml *
bk_editor_xml_new (void)
{
    BkEditorXml *xml = bk_editor_xml_new_empty ();
    bk_editor_xml_build (xml);
    return xml;
}
