#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _create_folder_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkDialog\" id=\"CreateFolder\">"
"    <property name=\"title\" translatable=\"yes\">Create Folder</property>"
"    <property name=\"destroy_with_parent\">True</property>"
"    <property name=\"type_hint\">GDK_WINDOW_TYPE_HINT_DIALOG</property>"
"    <property name=\"has_separator\">False</property>"
"    <child internal-child=\"vbox\">"
"      <widget class=\"GtkVBox\" id=\"dialog-vbox1\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkAlignment\" id=\"alignment1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"top_padding\">6</property>"
"            <property name=\"bottom_padding\">6</property>"
"            <property name=\"left_padding\">6</property>"
"            <property name=\"right_padding\">6</property>"
"            <child>"
"              <widget class=\"GtkVBox\" id=\"vbox1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"spacing\">6</property>"
"                <child>"
"                  <widget class=\"GtkLabel\" id=\"label\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"xalign\">0</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                  </packing>"
"                </child>"
"                <child>"
"                  <widget class=\"GtkEntry\" id=\"entry:MooEntry\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"activates_default\">True</property>"
"                  </widget>"
"                  <packing>"
"                    <property name=\"expand\">False</property>"
"                    <property name=\"fill\">False</property>"
"                    <property name=\"position\">1</property>"
"                  </packing>"
"                </child>"
"              </widget>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"position\">1</property>"
"          </packing>"
"        </child>"
"        <child internal-child=\"action_area\">"
"          <widget class=\"GtkHButtonBox\" id=\"dialog-action_area1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"layout_style\">GTK_BUTTONBOX_END</property>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"cancelbutton1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"label\">gtk-cancel</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"response_id\">-6</property>"
"              </widget>"
"            </child>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"okbutton1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"can_default\">True</property>"
"                <property name=\"has_default\">True</property>"
"                <property name=\"label\">gtk-ok</property>"
"                <property name=\"use_stock\">True</property>"
"                <property name=\"response_id\">-5</property>"
"              </widget>"
"              <packing>"
"                <property name=\"position\">1</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"expand\">False</property>"
"            <property name=\"pack_type\">GTK_PACK_END</property>"
"          </packing>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct CreateFolderXml CreateFolderXml;

struct CreateFolderXml {
    MooGladeXML *xml;

    GtkDialog *CreateFolder;
    GtkLabel *label;
    MooEntry *entry;
};

static void
_create_folder_xml_free (CreateFolderXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static CreateFolderXml *
create_folder_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
create_folder_xml_build (CreateFolderXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _create_folder_xml_glade_xml, -1, "CreateFolder", NULL);
    xml->CreateFolder = moo_glade_xml_get_widget (xml->xml, "CreateFolder");
    xml->label = moo_glade_xml_get_widget (xml->xml, "label");
    xml->entry = moo_glade_xml_get_widget (xml->xml, "entry:MooEntry");
    g_object_set_data_full (G_OBJECT (xml->CreateFolder), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _create_folder_xml_free);
}

static CreateFolderXml *
create_folder_xml_new_empty (void)
{
    CreateFolderXml *xml = g_new0 (CreateFolderXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static CreateFolderXml *
create_folder_xml_new (void)
{
    CreateFolderXml *xml = create_folder_xml_new_empty ();
    create_folder_xml_build (xml);
    return xml;
}
