#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _accel_dialog_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkDialog\" id=\"AccelDialog\">"
"    <property name=\"title\">Choose Accelerator</property>"
"    <property name=\"resizable\">False</property>"
"    <property name=\"window_position\">GTK_WIN_POS_CENTER_ON_PARENT</property>"
"    <property name=\"type_hint\">GDK_WINDOW_TYPE_HINT_DIALOG</property>"
"    <property name=\"has_separator\">False</property>"
"    <child internal-child=\"vbox\">"
"      <widget class=\"GtkVBox\" id=\"dialog-vbox1\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkEventBox\" id=\"eventbox\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"can_focus\">True</property>"
"            <property name=\"has_focus\">True</property>"
"            <property name=\"can_default\">True</property>"
"            <property name=\"has_default\">True</property>"
"            <child>"
"              <widget class=\"GtkFrame\" id=\"frame1\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"border_width\">6</property>"
"                <property name=\"label_xalign\">0</property>"
"                <child>"
"                  <widget class=\"GtkAlignment\" id=\"alignment31\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"top_padding\">6</property>"
"                    <property name=\"bottom_padding\">6</property>"
"                    <property name=\"left_padding\">6</property>"
"                    <property name=\"right_padding\">6</property>"
"                    <child>"
"                      <widget class=\"GtkLabel\" id=\"label\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"label\">"
"New accelerator..."
"</property>"
"                      </widget>"
"                    </child>"
"                  </widget>"
"                </child>"
"              </widget>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"position\">1</property>"
"          </packing>"
"        </child>"
"        <child internal-child=\"action_area\">"
"          <widget class=\"GtkHButtonBox\" id=\"dialog-action_area1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"layout_style\">GTK_BUTTONBOX_END</property>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"cancel\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"focus_on_click\">False</property>"
"                <property name=\"response_id\">-6</property>"
"                <child>"
"                  <widget class=\"GtkAlignment\" id=\"alignment29\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"xscale\">0</property>"
"                    <property name=\"yscale\">0</property>"
"                    <child>"
"                      <widget class=\"GtkHBox\" id=\"hbox11\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"spacing\">2</property>"
"                        <child>"
"                          <widget class=\"GtkImage\" id=\"image1\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"stock\">gtk-cancel</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkLabel\" id=\"label65\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\">Cancel</property>"
"                            <property name=\"use_underline\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                            <property name=\"position\">1</property>"
"                          </packing>"
"                        </child>"
"                      </widget>"
"                    </child>"
"                  </widget>"
"                </child>"
"              </widget>"
"            </child>"
"            <child>"
"              <widget class=\"GtkButton\" id=\"ok\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"focus_on_click\">False</property>"
"                <property name=\"response_id\">-5</property>"
"                <child>"
"                  <widget class=\"GtkAlignment\" id=\"alignment30\">"
"                    <property name=\"visible\">True</property>"
"                    <property name=\"xscale\">0</property>"
"                    <property name=\"yscale\">0</property>"
"                    <child>"
"                      <widget class=\"GtkHBox\" id=\"hbox12\">"
"                        <property name=\"visible\">True</property>"
"                        <property name=\"spacing\">2</property>"
"                        <child>"
"                          <widget class=\"GtkImage\" id=\"image2\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"stock\">gtk-ok</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                          </packing>"
"                        </child>"
"                        <child>"
"                          <widget class=\"GtkLabel\" id=\"label66\">"
"                            <property name=\"visible\">True</property>"
"                            <property name=\"label\">OK</property>"
"                            <property name=\"use_underline\">True</property>"
"                          </widget>"
"                          <packing>"
"                            <property name=\"expand\">False</property>"
"                            <property name=\"fill\">False</property>"
"                            <property name=\"position\">1</property>"
"                          </packing>"
"                        </child>"
"                      </widget>"
"                    </child>"
"                  </widget>"
"                </child>"
"              </widget>"
"              <packing>"
"                <property name=\"position\">1</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"expand\">False</property>"
"            <property name=\"pack_type\">GTK_PACK_END</property>"
"          </packing>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct AccelDialogXml AccelDialogXml;

struct AccelDialogXml {
    MooGladeXML *xml;

    GtkDialog *AccelDialog;
    GtkEventBox *eventbox;
    GtkLabel *label;
    GtkButton *cancel;
    GtkButton *ok;
};

static void
_accel_dialog_xml_free (AccelDialogXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static AccelDialogXml *
accel_dialog_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
accel_dialog_xml_build (AccelDialogXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _accel_dialog_xml_glade_xml, -1, "AccelDialog", NULL);
    xml->AccelDialog = moo_glade_xml_get_widget (xml->xml, "AccelDialog");
    xml->eventbox = moo_glade_xml_get_widget (xml->xml, "eventbox");
    xml->label = moo_glade_xml_get_widget (xml->xml, "label");
    xml->cancel = moo_glade_xml_get_widget (xml->xml, "cancel");
    xml->ok = moo_glade_xml_get_widget (xml->xml, "ok");
    g_object_set_data_full (G_OBJECT (xml->AccelDialog), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _accel_dialog_xml_free);
}

static AccelDialogXml *
accel_dialog_xml_new_empty (void)
{
    AccelDialogXml *xml = g_new0 (AccelDialogXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static AccelDialogXml *
accel_dialog_xml_new (void)
{
    AccelDialogXml *xml = accel_dialog_xml_new_empty ();
    accel_dialog_xml_build (xml);
    return xml;
}
