/***************************************************************************
    qgsrasterdataprovider.cpp - DataProvider Interface for raster layers
     --------------------------------------
    Date                 : Mar 11, 2005
    Copyright            : (C) 2005 by Brendan Morley
    email                : morb at ozemail dot com dot au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* $Id: qgsrasterdataprovider.cpp 10885 2009-06-05 13:13:45Z mhugent $ */

#include "qgsrasterdataprovider.h"
#include "qgslogger.h"

QgsRasterDataProvider::QgsRasterDataProvider(): mDpi(-1)
{
}


QgsRasterDataProvider::QgsRasterDataProvider( QString const & uri )
    : QgsDataProvider( uri ), mDpi(-1)
{
}


QString QgsRasterDataProvider::capabilitiesString() const
{
  QStringList abilitiesList;

  int abilities = capabilities();

  if ( abilities & QgsRasterDataProvider::Identify )
  {
    abilitiesList += "Identify";
    QgsDebugMsg( "Identify" );
  }

  return abilitiesList.join( ", " );
}


// ENDS
