#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
import os, codecs


def updateUi(self, MyHighlighter, Dialog_export):
    #Change font of textEdit
    self.ui_export.textEdit.setFont(self.myfont)
    #Set up highlighting
    self.highlighter3 = MyHighlighter(self.ui_export.textEdit)
    #Give a name to radiobutton "other" like "pdf" or "dvi" or "ps"
    self.ui_export.radioButton_other.setText(self.settings["type_of_file"])
    #Add elements (alphabetically) to the comboBox and fills the textEdit and 
    #Create a copy of the self.generate dic so as to not loose modifications
    #whenever user clicks "back" and updates the comboBox
    self.generate2 = {}
    keys = self.generate.keys()
    keys.remove("Add ...")
    keys.sort(key=str.lower)
    for key in keys:
        self.generate2[key] = self.export_sources(key)
        self.ui_export.comboBox.addItem(key)
    self.gen_combo(keys[0])
    #Slots and signals
    QtCore.QObject.connect(self.ui_export.pushButton_next,QtCore.SIGNAL("clicked()"),self.gen_next)
    QtCore.QObject.connect(self.ui_export.pushButton_back,QtCore.SIGNAL("clicked()"),self.gen_back)
    QtCore.QObject.connect(self.ui_export.comboBox,\
                            QtCore.SIGNAL("currentIndexChanged(QString)"),self.gen_combo)
    QtCore.QObject.connect(self.ui_export.textEdit,\
                            QtCore.SIGNAL("textChanged()"),self.update_generate2)
    QtCore.QObject.connect(self.ui_export.pushButton_export,QtCore.SIGNAL("clicked()"), self.fin_export)


def gen_next(self):
    self.ui_export.frame0.hide()
    self.ui_export.frame1.show()
    self.ui_export.pushButton_next.setEnabled(False)
    self.ui_export.pushButton_back.setEnabled(True)
    self.ui_export.pushButton_export.setEnabled(True)


def gen_back(self):
    self.ui_export.frame1.hide()
    self.ui_export.frame0.show()
    self.ui_export.pushButton_next.setEnabled(True)
    self.ui_export.pushButton_back.setEnabled(False)
    self.ui_export.pushButton_export.setEnabled(False)


def gen_combo(self, text):
    self.ui_export.textEdit.setText(self.generate2[str(text)])


def update_generate2(self):
    self.generate2[str(self.ui_export.comboBox.currentText())] = unicode(self.ui_export.textEdit.toPlainText())


def save(self, tex_code, MainWindow):
    fileName = QtGui.QFileDialog.getSaveFileName(MainWindow,"Save",
                    os.path.join(self.settings["save_location"],"exam.tex"),
                    "TeX files (*.tex);;All files (*.*)")
    if fileName:
        fichier = codecs.open(fileName,'w',"utf-8")
        fichier.write(tex_code)
        fichier.close()


def export_sources(self, key):
    if key == "Same header":
        sources = self.generate[key] \
                    + u"\n\\begin{document}\n\n " \
                    + unicode(self.whole_thing(), "utf-8") \
                    + u"\n\\end{document}"
    else:
        sources = self.generate[key] \
                    + u"\n\n" \
                    + unicode(self.whole_thing(), "utf-8") \
                    + u"\n\n\\end{document}"
    return sources


def fin_export(self):
    if self.ui_export.radioButton_tex.isChecked():
        self.save(unicode(self.ui_export.textEdit.toPlainText()))
    else:
        self.show_preview_outside(unicode(self.ui_export.textEdit.toPlainText()))
