/*
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

#include "kmconf.h"
#include "qdebug.h"
#include "qapplication.h"

KmConf::KmConf( KmTail *pKmTail, Qt::WindowFlags f ): 
	QDialog(pKmTail, f),
	Ui::KmConf()
{
	setupUi( this );
	mpKmTail = pKmTail;
	
	mpCritCB->setColor( pKmTail->mRedB.color() );
	mpErrCB->setColor( pKmTail->mOrangeB.color() );
	mpWarnCB->setColor( pKmTail->mYellowB.color() );
	
	mpCritLE->setText( pKmTail->mCritTags.join( "," ) );
	mpErrLE->setText( pKmTail->mErrTags.join( "," ) );
	mpWarnLE->setText( pKmTail->mWarnTags.join( "," ) );
	
	if ( pKmTail->mUsrFont )
		mpFontSel->setFont( pKmTail->mFont );
}

void KmConf::btnClicked( QAbstractButton *btn )
{
	if ( btn->text() == "&OK" )
	{
		mpKmTail->mRedB.setColor( mpCritCB->color() );
		mpKmTail->mOrangeB.setColor( mpErrCB->color() );
		mpKmTail->mYellowB.setColor( mpWarnCB->color() );
		
		mpKmTail->mCritTags = mpCritLE->text().split( "," );
		mpKmTail->mErrTags = mpErrLE->text().split( "," );
		mpKmTail->mWarnTags = mpWarnLE->text().split( "," );
		
		if ( !(mpKmTail->mFont == mpFontSel->font()) )
		{
			mpKmTail->mFont = mpFontSel->font();
			mpKmTail->setFont();
		}
		
		accept();
	}	
	else if ( btn->text() == "&Reset" )
	{
		mpCritCB->setColor( "#FF0000" );									// red
		mpErrCB->setColor( "#FFAA00" );										// orange
		mpWarnCB->setColor( "#FFFF00" );									// yellow
		
		mpCritLE->setText( mpKmTail->defCritTags.join( "," ) );
		mpErrLE->setText( mpKmTail->defErrTags.join( "," ) );
		mpWarnLE->setText( mpKmTail->defWarnTags.join( "," ) );
		
		mpFontSel->setFont( QApplication::font() ); 
	}	
	else if ( btn->text() == "&Cancel" )
	{
		reject();
	}
}

