/*
 * kmtail.h
 *
 * Copyright (C) 2008 %{AUTHOR} <%{EMAIL}>
 */
#ifndef KMTAIL_H
#define KMTAIL_H

#define TAIL "turbotail"
#define MAXLINES 1000

#include <qtreewidget.h>
#include <qmenu.h>
#include <qbrush.h>
#include <QKeyEvent>

#include <klocale.h>
#include <kprocess.h>
#include <kxmlguiwindow.h>
#include <kconfig.h>
#include <kconfiggroup.h>
#include <ktabbar.h>

#include "kmfile.h"
#include <qlabel.h>
#include <kaction.h>
#include <klineedit.h>

class KmTailView;
class KToggleAction;
class KUrl;

/**
 * This class serves as the main window for KmTail.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author %{AUTHOR} <%{EMAIL}>
 * @version %{VERSION}
 */
class KmTail : public KXmlGuiWindow
{
		Q_OBJECT
		
public:
    /**
     * Default Constructor
     */
    KmTail();

    /**
     * Default Destructor
     */
    virtual ~KmTail();
		
		friend class KmConf;
		
		
public slots:

protected:
		void dropEvent( QDropEvent* event );
		void dragEnterEvent( QDragEnterEvent* event );
	
	
private slots:
    void fileNew();
    void fileClose();
		void readStdOut();
		void readStdErr();
		void closeTab( int );
		void changedTab( int );
		void fileReload( int k = -1 );
		void menuHide();
		void rmbItem( const QPoint& );
		void selectAllItems(int k);
		void copySelection(int k);
		void setFont();
		void editDone( QString arg );
		void clearEdit();
		void reloadTimeout();
		void moveElems( int, int );
		void confOptions();
	
private:
    void setupActions();
    void addFile(const QString& lf);
		void saveOptions();
		void readOptions();
		QString whereIs( const QString& );
		void checkTail();
		bool highLightItem( QTreeWidgetItem*, QStringList&, QBrush& );
		void startProc( KmFile& );
		
private:
    KmTailView *mpView;
    KToggleAction *mpToolbarAction;
    KToggleAction *mpStatusbarAction;
		QList<KmFile> mFiles;
		QStringList mFileNms;
    KSharedConfigPtr mConfig;
		KConfigGroup *mpGenGroup;
		QLabel* mpSBtext1;
		KAction *mpFileReload;
		KAction *mpMenuHide;
		KAction *mpFont;
		KAction *mpEdit;
		KAction *mpEditIcon;
		KLineEdit *mpLnEdit;
		QMenu *mpPopup;
		QFont mFont;
		bool mUsrFont;
		QString mTail;
		QBrush mRedB;
		QBrush mOrangeB;
		QBrush mYellowB;
		const QString fTB;
		QStringList defCritTags, defErrTags, defWarnTags;
		QStringList mCritTags, mErrTags, mWarnTags;
};


#endif // _KMTAIL_H_
