#include "kmtail.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <KDE/KLocale>

static const char description[] =
    I18N_NOOP("KDE4 multiple Tail Application");

static const char version[] = "0.4";

int main(int argc, char **argv)
{
    KAboutData about("kmtail", 0, ki18n("KmTail"), version, ki18n(description),
                     KAboutData::License_GPL, ki18n("(C) 2010 Robin Atwood"), KLocalizedString(), 0, "robin@binro.org");
    about.addAuthor( ki18n("Robin Atwood"), KLocalizedString(), "robin@binro.org" );
    KCmdLineArgs::init(argc, argv, &about);

    KCmdLineOptions options;
    options.add("+[URL]", ki18n( "Document to open" ));
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;

    KmTail *widget = new KmTail;

    // see if we are starting with session management
    if (app.isSessionRestored())
    {
        RESTORE(KmTail);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            //kmtail *widget = new kmtail;
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                //kmtail *widget = new kmtail;
                widget->show();
            }
        }
        args->clear();
    }

    return app.exec();
}
