/*
* This file is part of QTGZManager, an open-source GUI for Slackware pkgtools.
* Copyright (C) 2006  Alexandre Albuquerque Arnt
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail : Alexandre Albuquerque Arnt <aaarnt@gmail.com>
* Program URL   : http://jtgzmanager.sf.net
*
*/

#ifndef MAINWINDOWIMPL_H
#define MAINWINDOWIMPL_H
//
#include "ui_mainwindow.h"
//

#include <iostream>
#include "qdnddirmodel.h"
#include "qdndstandarditemmodel.h"
#include "finddialogimpl.h"
#include "tvpackagesitemdelegate.h"
#include "qsimplestatusbar.h"
#include <QDir>
#include <QStringListModel>
#include <QSortFilterProxyModel>
#include <QKeyEvent>
#include <QProcess>
#include <QToolButton>
#include <QSystemTrayIcon>
#include <QFileSystemWatcher>
#include <QSettings>

const int ctn_PACKAGE_ICON  ( 0 );
const int ctn_PACKAGE_NAME ( 1 );

class FrozenPkgListSingleton;
class SelectedPackage;
class ArgumentList;
class QTimerEvent;
class QLabel;
class UNIXCommand;

template <typename T> class QFutureWatcher;

class MainWindowImpl : public QMainWindow, public Ui::MainWindow
{
  Q_OBJECT

  private:

    const QString ctn_APPLICATION_NAME;
    const QString ctn_LABEL_TREEVIEW_PACKAGES;

    UNIXCommand *m_unixCommand;
    ArgumentList *m_argList;

    int m_PackagesInDirFontSize;
    int m_InstalledPackagesFontSize;
    int m_DirectoryFontSize;
    int m_TodoFontSize;
    int m_PkgListFontSize;
    int m_ToolTipFontSize;
		bool m_reallyWannaClose;
    QString m_DefaultDirectory;
    FrozenPkgListSingleton *m_frozenPkgList;
    QFutureWatcher<QStringList> *m_fw;

    QFileSystemWatcher m_fsw; //Watches for changes in the Packages Dir (2nd view) NEEDS inotify support!
    QFileSystemWatcher *m_psw; //Watches for changes in "/var/log/packages"
		
		QByteArray m_horizontalSplit;
		QByteArray m_verticalSplit;		
    QByteArray m_savedGeometry;
    FindDialogImpl *m_findDialog;
    QLabel *m_lblStatus;
   	QTabBar *m_tabBar;

    QAction *m_actionFreezePkg;
    QAction *m_actionUnfreezePkg;
    QAction *m_actionTransformRPMinTGZ;
    QAction *m_actionExpandItem;
    QAction *m_actionCollapseItem;
    QAction *m_actionDiffToEachOther;
    QAction *m_actionOpenDirectory;
    QAction *m_actionOpenFile;
    QAction *m_actionEditFile;
    QAction *m_actionChangeDefaultDirectory;
    QAction *m_actionAbout;
    QAction *m_actionOpenTerminal;
    QAction *m_actionFindPackage;
    QAction *m_actionInPkgFileList;
    QAction *m_actionFindFileInPackage;
    QAction *m_actionFindFileInPkgFileList;
    QAction *m_actionIconifyOnStart;
    QAction *m_actionShowToolBar;

    QSimpleStatusBar *m_statusbar;		
    QSystemTrayIcon *m_systemTrayIcon;
    QMenu *m_systemTrayIconMenu;

    QString m_textForMoreInformation;
		int m_PackageListOrderedCol, m_InstalledPackageListOrderedCol;
		Qt::SortOrder m_PackageListSortOrder, m_InstalledPackageListSortOrder;
		int m_clickedTab;
    QProcess *m_echo, *m_rpm2tgz, *m_tgz2lzm;
    QToolButton *m_btnCloseTab;

    QDnDDirModel *m_modelDir; //For the Directory treeView
    QDnDStandardItemModel *m_modelPackage; //For the Packages TreeView
    QDnDStandardItemModel *m_modelTodo; //For the Todo treeView
    QStandardItemModel *m_modelInstalledPackages; //For the InstalledPackages TreeView
    QSortFilterProxyModel *m_proxyModelPackage; //For the Packages Treeview's filter functionality
    QSortFilterProxyModel *m_proxyModelInstalledPackages; //For the InstalledPackages Treeview's filter functionality
    QStandardItem *m_install, *m_remove, *m_downgrade, *m_upgrade, *m_reinstall;

    QList<SelectedPackage> getSelectedInstalledPackage();

    void _expandItem(QTreeView*, QStandardItemModel*, QModelIndex*);
		void _collapseItem(QTreeView*, QStandardItemModel*, QModelIndex);		

		bool hasTheExecutable( QString );

    void initializeActions();
    void initializeMenuBar();
    void initializeToolBar();
    void initializeDirTreeView();
    void initializePackageTreeView();
    void initializeInstalledPackagesTreeView();
    void initializeTodoTreeView();   

    void createTabPkgFileList(const QString, const QStringList);
		void createTabPkgDiff(const QString pkg, const QString installedPkg, const QString diff );
		void removeAbsoluteDir( QStandardItemModel*, QModelIndex );
		void refreshPackageTreeView();
		void refreshInstalledPackageTreeView();

		QString filterPackageFoundStyleSheet();
		QString filterPackageNotFoundStyleSheet();

    void loadSettings();
    void saveSettings();

    bool isFindDisabled();

  protected:

		void keyPressEvent( QKeyEvent* );
		void keyReleaseEvent( QKeyEvent* );		
		void closeEvent( QCloseEvent* );
		bool eventFilter( QObject *, QEvent * );
      
  public:

    const QString ctn_TODO_INSTALL;
    const QString ctn_TODO_REMOVE;
    const QString ctn_TODO_DOWNGRADE;
    const QString ctn_TODO_UPGRADE;
    const QString ctn_TODO_REINSTALL;
    const QIcon ctn_ICON_INTERNAL_ERROR, ctn_ICON_INFERIOR, ctn_ICON_SUPERIOR, ctn_ICON_OTHER_VERSION, ctn_ICON_INSTALLED,
                ctn_ICON_NOT_INSTALLED, ctn_ICON_FOLDER, ctn_ICON_BINARY, ctn_ICON_FROZEN, ctn_ICON_UNFROZEN, ctn_ICON_RPM;

    static QString treeViewStyleSheet();

    static MainWindowImpl* returnMainWindow(){
      static MainWindowImpl *w=0;
      if (w != 0) return w;
      foreach (QWidget *widget, QApplication::topLevelWidgets()) {
        if (widget->objectName() == "MainWindow") w = (MainWindowImpl*) widget;
      }
      return w;
    }

	  MainWindowImpl( QWidget * parent = 0, Qt::WFlags f = 0 );
    ~MainWindowImpl();
  
    QDnDDirModel* getModelDir() { return m_modelDir; }
    QDnDStandardItemModel* getModelPackage() { return m_modelPackage; }
    QTreeView* getTODOTreeView() { return tvTODO; }

		void positionInInstalledPkgList( const QString& );
    void positionInPkgList( const QString &dir, const QString &pkg );
    void positionInPkgFileList( const QString &fileName, const QString &directory );

    QString selectedDirectory(){ return (m_modelDir->filePath(tvDir->currentIndex())); }
    QList<SelectedPackage> getSelectedPackage();	

  private slots:
  
		void verifyStateTODO( const QModelIndex , int, int );
    void exitApplication();

    void execContextMenuDirectories(QPoint point);
    void execContextMenuPackages(QPoint point);
    void execContextMenuInstalledPackages(QPoint point);  
    void execContextMenutvTODO(QPoint point);  
		void execContextMenuPkgFileList(QPoint);
		void execSystemTrayActivated ( QSystemTrayIcon::ActivationReason );

	 	void aboutQTGZManager();
    void deleteFile();
	 	void deleteActionFile();
	 	void deleteAllActionFiles();
    
    void createDirectory();
    void removeDirectory();
    void changeDefaultDirectory();
      
    void ACTIONSprocessStarted();
    void ACTIONSprocessFinished(int exitCode, QProcess::ExitStatus exitStatus);
    void ACTIONSprocessRaisedError();
    void ACTIONSprocessReadOutput();

    void TGZ2LZMprocessStarted();
		void TGZ2LZMprocessFinished(int exitCode, QProcess::ExitStatus exitStatus);    
		void TGZ2LZMprocessRaisedError();    
    void TGZ2LZMprocessReadOutput();
		
		void RPM2TGZprocessStarted();
		void RPM2TGZprocessFinished(int exitCode, QProcess::ExitStatus exitStatus);    
		void RPM2TGZprocessRaisedError();    
    void RPM2TGZprocessReadOutput();

    void reapplyPackageFilter();
		void reapplyInstalledPackagesFilter();
    void clearFilterPackage();
    void clearFilterInstalledPackage();

    void conditionalGotoNormalView();
    void conditionalGotoNormalViewSimple();

    void transformRPMinTGZ();
		void transformTGZinLZM();

    void _deallocateTabContent(int tabIndex);
    void closeCurrentTab();
		void closeClickedTab();
		void closeAllTabs();
		void enableCloseTabButton( int );
    
    void diffToInstalled();
    void diffToEachOther();
    QString showFullPathOfObject(const QModelIndex & index);

    void insertInstallPackageAction();
    void insertDowngradePackageAction();
    void insertRemovePackageAction();
    void insertUpgradePackageAction();
    void insertReinstallPackageAction();

    void showPackageInfo();   
		void showInstalledPackageInfo();
    bool showPackageContent();
    void executePackageActions();
		void expandAllContentItems();
		void expandThisContentItems();
		void collapseAllContentItems();
		void collapseThisContentItems();

		void hideRightView();
		void minimizeLowerView();
		void maximizeLowerView();
		void normalView();

    void metaFindFile();
    void findFile();
    void findFileInPkgFileList();
    void findFileInPkgFileListExt();
    void findFileInPackage();
    void findPackage();

    void openFile();
    void editFile();
    void openDirectory();
    void openTerminal();
		void openFileOrDirectory(const QModelIndex&);

		void headerViewPackageList_click( int );
		void headerViewInstalledPackageList_click( int );

		void fileSystemWatcher_directoryChanged ( const QString &);
    void fileSystemWatcher_packageDirectoryChanged ( const QString &);

		void freezePackage();
		void unfreezePackage();

		bool close();
		void showPackagesInDirectory();
		void refreshTreeViews();
		void changeDir();
    bool execPackageContent();
		void takeSnapshotOfInstalledPackages();

    void showToolBar();
    void correctActionToolBarStatus();

  public slots:

    void show();
    void selectInstalledPackage();
    void toggleToolBarStatus();
};

class SelectedPackage{
	private:
    	QString path;
	  	QString fileName;	
			QIcon icon;
	
	public:
    SelectedPackage(QString path, QString fileName, QIcon icon){
		  this->path = path;
		  this->fileName = fileName;		
			this->icon = icon;
  	}

    SelectedPackage(QString path, QString fileName){
		  this->path = path;
		  this->fileName = fileName;		
  	}

    SelectedPackage(){}
	
	  QString getCompleteFileName(){
		  return path + QDir::separator() + fileName;		
  	}

  	QString getFileName() {
		  return fileName;
  	}

	  void setFileName(QString fileName) {
		  this->fileName = fileName;
  	}

	  QString getPath() {
	  	return path;
	  }

		QIcon getIcon(){
			return icon;
		}

	  void setPath(QString path) {
	  	this->path = path;
  	}

		void setIcon(QIcon icon) {
			this->icon = icon;
		}	
};

#endif
