/*
* This file is part of QTGZManager, an open-source GUI for Slackware pkgtools.
* Copyright (C) 2006  Alexandre Albuquerque Arnt
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail : Alexandre Albuquerque Arnt <aaarnt@gmail.com>
* Program URL   : http://jtgzmanager.sf.net
*
*/

#include "settingsmanager.h"
#include <QString>
#include <QStringList>
#include <QVariant>
#include <QSettings>
#include <QDir>

SettingsManager* SettingsManager::m_pinstance = 0;


SettingsManager::SettingsManager(){
  m_SYSsettings = new QSettings(QSettings::UserScope, ctn_ORGANIZATION, ctn_APPLICATION);
}

SettingsManager::~SettingsManager(){  
  delete m_SYSsettings;
}

QStringList SettingsManager::getFrozenPkgList(){
  return instance()->getSYSsettings()->value( ctn_KEY_FROZEN_PACKAGES_LIST, QVariant(QStringList())).toStringList() ;
}

QString SettingsManager::getDefaultDirectory(){
  QString defaultDir = instance()->getSYSsettings()->value( ctn_KEY_DEFAULT_DIRECTORY, QDir::homePath()).toString();
  if (defaultDir == "") defaultDir = QDir::homePath();
  return defaultDir;
}

int SettingsManager::getFourPanelOrganizing(){
  return instance()->getSYSsettings()->value( ctn_KEY_FOUR_PANEL_ORGANIZING, ectn_NORMAL ).toInt();
}

int SettingsManager::getPackageListOrderedCol(){
  return instance()->getSYSsettings()->value( ctn_KEY_PACKAGE_LIST_ORDERED_COL, 1 ).toInt();
}

int SettingsManager::getInstalledPackageListOrderedCol(){
  return instance()->getSYSsettings()->value( ctn_KEY_INSTALLED_PACKAGE_LIST_ORDERED_COL, 1 ).toInt();
}

int SettingsManager::getPackageListSortOrder(){
  return instance()->getSYSsettings()->value( ctn_KEY_PACKAGE_LIST_SORT_ORDER, Qt::AscendingOrder ).toInt();
}

int SettingsManager::getInstalledPackageListSortOrder(){
  return instance()->getSYSsettings()->value( ctn_KEY_INSTALLED_PACKAGE_LIST_SORT_ORDER, Qt::AscendingOrder ).toInt();
}

bool SettingsManager::getShowToolBar(){
  return (instance()->getSYSsettings()->value( ctn_KEY_SHOW_TOOLBAR, true).toInt() == 1);
}

bool SettingsManager::getStartIconified(){
  return (instance()->getSYSsettings()->value( ctn_KEY_START_ICONIFIED, false).toInt() == 1);
}

void SettingsManager::setPackageListOrderedCol(int newValue){
  instance()->getSYSsettings()->setValue( ctn_KEY_PACKAGE_LIST_ORDERED_COL, newValue);
  instance()->getSYSsettings()->sync();
}

void SettingsManager::setInstalledPackageListOrderedCol(int newValue){
  instance()->getSYSsettings()->setValue( ctn_KEY_INSTALLED_PACKAGE_LIST_ORDERED_COL, newValue);
  instance()->getSYSsettings()->sync();
}

void SettingsManager::setPackageListSortOrder(int newValue){
  instance()->getSYSsettings()->setValue( ctn_KEY_PACKAGE_LIST_SORT_ORDER, newValue);
  instance()->getSYSsettings()->sync();
}

void SettingsManager::setInstalledPackageListSortOrder(int newValue){
  instance()->getSYSsettings()->setValue( ctn_KEY_INSTALLED_PACKAGE_LIST_SORT_ORDER, newValue);
  instance()->getSYSsettings()->sync();
}

void SettingsManager::setFourPanelOrganizing(int newValue){
  instance()->getSYSsettings()->setValue( ctn_KEY_FOUR_PANEL_ORGANIZING, newValue);
  instance()->getSYSsettings()->sync();
}

void SettingsManager::setFrozenPkgList(QStringList newValue){
  instance()->getSYSsettings()->setValue( ctn_KEY_FROZEN_PACKAGES_LIST,
                                          QVariant( static_cast<QStringList>(newValue)) );
  instance()->getSYSsettings()->sync();
}

void SettingsManager::setDefaultDirectory(QString newValue){
  instance()->getSYSsettings()->setValue( ctn_KEY_DEFAULT_DIRECTORY, newValue);
  instance()->getSYSsettings()->sync();
}

void SettingsManager::setShowToolBar(bool newValue){
  int value=0;
  if (newValue) value=1;
  instance()->getSYSsettings()->setValue( ctn_KEY_SHOW_TOOLBAR, value);
  instance()->getSYSsettings()->sync();
}

void SettingsManager::setStartIconified(bool newValue){
  int value=0;
  if (newValue) value=1;
  instance()->getSYSsettings()->setValue( ctn_KEY_START_ICONIFIED, value);
  instance()->getSYSsettings()->sync();
}

SettingsManager* SettingsManager::instance(){
  if (m_pinstance == 0) m_pinstance = new SettingsManager();
  return m_pinstance;
}
