/*
* This file is part of QTGZManager, an open-source GUI for Slackware pkgtools.
* Copyright (C) 2006  Alexandre Albuquerque Arnt
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail : Alexandre Albuquerque Arnt <aaarnt@gmail.com>
* Program URL   : http://jtgzmanager.sf.net
*
*/

#ifndef SETTINGSMANAGER_H
#define SETTINGSMANAGER_H

#include <QString>
#include <QVariant>
#include <QSettings>

const QString ctn_ORGANIZATION("QTGZManager");
const QString ctn_APPLICATION("QTGZManager");

const QString ctn_KEY_FROZEN_PACKAGES_LIST("Frozen_Packages");
const QString ctn_KEY_DEFAULT_DIRECTORY("Default_Directory");
const QString ctn_KEY_FOUR_PANEL_ORGANIZING("Four_Panel_Organizing");
const QString ctn_KEY_PACKAGE_LIST_ORDERED_COL("PackageList_Ordered_Col");
const QString ctn_KEY_INSTALLED_PACKAGE_LIST_ORDERED_COL("InstalledPackageList_Ordered_Col");
const QString ctn_KEY_PACKAGE_LIST_SORT_ORDER("PackageList_Sort_Order");
const QString ctn_KEY_INSTALLED_PACKAGE_LIST_SORT_ORDER("InstalledPackageList_Sort_Order");
const QString ctn_KEY_SHOW_TOOLBAR("Show_ToolBar");
const QString ctn_KEY_START_ICONIFIED("Start_Iconified");

enum FourPanelOrganizing { ectn_HIDE_RIGHT=1, ectn_NORMAL=2, ectn_HIDE_BOTTON=4, ectn_MAXIMIZED=6 };

class QStringList;

class SettingsManager {

  private:

    static SettingsManager *m_pinstance;
    QSettings *m_SYSsettings;

    SettingsManager(const SettingsManager&);
    SettingsManager& operator= (const SettingsManager&);
    SettingsManager();
    ~SettingsManager();

    QSettings* getSYSsettings() { return m_SYSsettings; }

  public:

    static SettingsManager* instance();

    static QStringList getFrozenPkgList();
    static QString getDefaultDirectory();
    static int getFourPanelOrganizing();
    static int getPackageListOrderedCol();
    static int getInstalledPackageListOrderedCol();
    static int getPackageListSortOrder();
    static int getInstalledPackageListSortOrder();
    static bool getShowToolBar();
    static bool getStartIconified();

    static void setFrozenPkgList(QStringList newValue);
    static void setDefaultDirectory(QString newValue);
    static void setFourPanelOrganizing(int newValue);
    static void setPackageListOrderedCol(int newValue);
    static void setInstalledPackageListOrderedCol(int newValue);
    static void setPackageListSortOrder(int newValue);
    static void setInstalledPackageListSortOrder(int newValue);
    static void setShowToolBar(bool newValue);
    static void setStartIconified(bool newValue);
};

#endif // SETTINGSMANAGER_H
