/*
* This file is part of QTGZManager, an open-source GUI for Slackware pkgtools.
* Copyright (C) 2006  Alexandre Albuquerque Arnt
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail : Alexandre Albuquerque Arnt <aaarnt@gmail.com>
* Program URL   : http://jtgzmanager.sf.net
*
*/
#ifndef UNIXCOMMAND_H
#define UNIXCOMMAND_H

#include <QObject>
#include <QProcess>
#include <QApplication>

const QString ctn_MAKELZMBIN("make-lzm");
const QString ctn_RPM2TGZBIN("rpm2tgz");
const QString ctn_TGZ2LZMBIN("tgz2lzm");
const QString ctn_PACKAGES_WITH_SAME_CONTENT("The packages have the same content!");

enum LZMCommand { ectn_MAKELZM, ectn_TGZ2LZM };

class QString;
class QStringList;

class UNIXCommand : public QObject{
  Q_OBJECT;

  private:
    QString m_readAllStandardOutput;
    QString m_readAllStandardError;
    QString m_errorString;
    QProcess *m_process;

  public:
    UNIXCommand(QObject *parent);

    static bool isAnInstanceRunning();
    static bool hasTheExecutable( const QString& exeName );

    static bool isTextFile( const QString& fileName ); //fileName is Path + Name
    static void openFile( const QString& fileName ); //fileName is Path + Name
    static void editFile( const QString& fileName ); //fileName is Path + Name

    static void openDirectory( const QString& dirName );
    static void openTerminal( const QString& dirName );

    static QString executeDiffToEachOther( QString pkg1, QString pkg2 );
    static QString executeDiffToInstalled( QString pkg, QString installedPackage );

    void executePackageActions(const QStringList& commandList);
    void transformTGZinLZM(const QStringList& commandList, LZMCommand commandUsed);
    void transformRPMinTGZ(const QStringList& commandList);
    QString readAllStandardOutput();
    QString readAllStandardError();
    QString errorString();

  public slots:
    void processReadyReadStandardOutput();
    void processReadyReadStandardError();

  signals:
    void started();
    void readyReadStandardOutput();
    void finished ( int, QProcess::ExitStatus );
    void readyReadStandardError();
};


class CPUIntensiveComputing: public QObject{
  public:
    CPUIntensiveComputing(){
      QApplication::setOverrideCursor(Qt::WaitCursor);
    }

    ~CPUIntensiveComputing(){
      QApplication::restoreOverrideCursor();
    }

    void restoreDefaultCursor(){
      QApplication::restoreOverrideCursor();
    }
};

#endif // UNIXCOMMAND_H
