#!/usr/bin/python2.4
from distutils.core import setup

setup(name='gutenpy',
      version='0.3.0',
      description='Text Reader and Catalog Browser for Project Gutenberg',
      long_description="GutenPy's text reader features: bookmarking (automatic or manual), easy mouse paging, a handy sidebar for browsing bookmarks and files, and word definitions with a middle mouse click.  It's catalog browser features: regular expression filters (author, title, subject and language), remember filters between sessions, and a save-able selected booklist.  GutenPy is written with Python GTK2.",
      author='Lee Bigelow',
      author_email='ligelowbee@yahoo.com',
      url='http://gutenpy.sourceforge.net',
      license='GPL version 2',
      packages=['GutenPy'],
      scripts=['gutenpy.py'],
      data_files = [
                    ('share/applications',
                        ['gutenpy.desktop']),
                    ('share/pixmaps/gutenpy', 
                        ['icons/gutenpy.xpm',
                         'icons/book.ico',
                         'icons/book-lg.png',
                         'icons/book-sm.png',
                         'icons/bookmark.png',
                         'icons/dict_org.png',
                         'icons/gutenberg_org.png',
                         'icons/sidebar.png']),
                     ('share/doc/gutenpy',
                        ['docs/help.txt',
                         'docs/COPYING.txt',
                         'docs/MIRRORS_ALL.txt',
                         'docs/Regular_Expression_HOWTO.htm',
                         'docs/Regular_Expression_Syntax.html']) ],
     )
