#include "PrefsDialog.h"

#include <QSettings>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QIcon>
//#include <QDebug>

PrefsDialog::PrefsDialog(QWidget * parent, Qt::WFlags f)
        : QDialog(parent, f)
{
    setupUi(this);
	
	QPushButton * bbOkButton = buttonBox->button( QDialogButtonBox::Save );
    QPushButton * bbCancelButton = buttonBox->button( QDialogButtonBox::Cancel );
    bbOkButton->setText( tr("Save") );
	bbOkButton->setIcon( QIcon(":images/dialog-ok-apply.png") );
    bbCancelButton->setText( tr("Cancel") );
	bbCancelButton->setIcon( QIcon(":images/dialog-cancel.png") );

    QSettings settings;
    settings.beginGroup("MAIN");
     spEntryWidth->setValue(settings.value("entry_display_max_size", 60).toInt());
     spHistoryCount->setValue(settings.value("history_max_size", 10).toInt());
     cbClipboardSave->setChecked(settings.value("clipboard_history_save", true).toBool());
     cbIgnoreSelection->setChecked(settings.value("ignore_selection", true).toBool());
     cbIgnoreImages->setChecked(settings.value("ignore_images", true).toBool());
     cbActivateStickyClipboard->setChecked(settings.value("activate_sticky", true).toBool());
    settings.endGroup();
}

//  void PrefsDialog::focusOutEvent( QFocusEvent* )
//  {
//      qDebug() << "focus out !!!";
//  }