#include "systrayicon.h"
#include "SettingsInfo.h"
#include "PrefsDialog.h"
#include "customcommandseditor.h"

#include <QtGui>
#include <QSignalMapper>
#include <QFile>
#include <QToolTip>

SystrayIcon::SystrayIcon(QObject * parent) : QSystemTrayIcon (parent)
{
  //installEventFilter(this);
    #ifdef Q_WS_WIN
    QSettings::setDefaultFormat ( QSettings::IniFormat );
    #endif
    // Get Settings from config file
    QSettings settings;
    settings.beginGroup("MAIN");
     entry_display_max_size = settings.value("entry_display_max_size", 60).toInt();
     history_max_size = settings.value("history_max_size", 10).toInt();
     clipboard_history_save = settings.value("clipboard_history_save", true).toBool();
     ignore_selection = settings.value("ignore_selection", true).toBool();
	 ignore_images = settings.value("ignore_images", true).toBool();
	 activate_sticky = settings.value("activate_sticky", true).toBool();
    settings.endGroup();

	QDir cfgDir (SettingsInfo::configDir());

    if (!cfgDir.exists()) //if (!QFile::exists(SettingsInfo::configDir()))
    {        
        saveSettings();
        if (!cfgDir.exists()) //if (!QFile::exists(SettingsInfo::configDir()))
        {
            qDebug("Fatal Error : could not write conf file");
            exit( -1 );
        }
    }    

    history_file_name = QString("%1/%2").arg(SettingsInfo::configDir()).arg("history.log");
	sticky_file_name = QString("%1/%2").arg(SettingsInfo::configDir()).arg("sticky.log");
	systray_tooltip = tr("Qlipper - a clipboard history applet");
	tag_image = "__--image:";
	tag_separator = "--SEPARATOR--";
    //settingsPath = SettingsInfo::configDir();
    //settingsFile = SettingsInfo::fileName();

    // Restore clipboard history frome file
    QFile file(history_file_name);
    if (file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        QTextStream in(&file);
        QString buffer = in.readAll();
        QStringList strlst = buffer.split(tag_separator);

        for (int i = 0; i < strlst.size(); ++i)
        {
             //qDebug() << qPrintable(strlst.at(i).simplified()) ;
			 queue.enqueue(strlst.at(i)); 
			 /*
			 QMimeData *mimeData = new QMimeData;
			 if (strlst.at(i).startsWith("__--image:"))
				mimeData->setImageData(QImage(SettingsInfo::configDir() + "/" + strlst.at(i).mid(10)));
			 else
				mimeData->setText(strlst.at(i));
             queue.enqueue(mimeData);
			 */
        }
        file.close();
		//remove saved png images
		/*
		QStringList nameFilters;
		nameFilters << "*.png";
		QStringList pngList = cfgDir.entryList(nameFilters, QDir::Files);
		for (int k = 0 ; k < pngList.size() ; ++k)
		  QFile::remove(SettingsInfo::configDir() + "/" + pngList.at(k));//qDebug() << "pngList" << qPrintable(pngList.at(k));
		*/
    }
    else
	  qDebug() << "history_file_name does not exist";

    quitAction = new QAction( QIcon(":images/exit.png"), tr("&Quit"), this);
    connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));

    configureAction = new QAction( QIcon(":images/configure.png"), tr("&Configure"), this);
    connect(configureAction, SIGNAL(triggered()), this, SLOT(showPrefsDialog()));

    aboutAction = new QAction( QIcon(":images/info.png"), tr("&About Qlipper"), this);
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(showAbout()));

    clearAction = new QAction( QIcon(":images/edit-clear-history.png"), tr("C&lear clipboard history"), this);
    connect(clearAction, SIGNAL(triggered()), this, SLOT(clearClipboardHistory()));

    editStickyEntriesAction = new QAction( QIcon(":images/edit-select-all.png"), tr("&Edit sticky entries"), this);
    connect(editStickyEntriesAction, SIGNAL(triggered()), this, SLOT(showStickyDialog()));

    setIcon(QIcon(":images/klipper_dock.png"));
    setToolTip(systray_tooltip);

    QClipboard *clipboard = QApplication::clipboard();
    //clipboard->clear(QClipboard::Selection);
    //clipboard->clear(QClipboard::Clipboard);

    //stickyMenu = new QMenu(/*this*/);
	if (activate_sticky == true)
	  updateStickyMenu();
    //trayIconMenu = new QMenu(/*this*/);
    initSystrayMenu();
    //clipboardIconMenu = new QMenu(/*this*/);
    updateClipboardMenu();
    //setContextMenu(trayIconMenu);

    //connect( clipboard, SIGNAL(dataChanged()), this, SLOT( initSystrayMenu() ) );
    connect( clipboard, SIGNAL(dataChanged()), this, SLOT( updateClipboardMenu() ) );
    if (ignore_selection == false)
        connect( clipboard, SIGNAL(selectionChanged()), this, SLOT( clipSelectionChanged() ) );
    connect( this, SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, SLOT( systrayClicked(QSystemTrayIcon::ActivationReason) ) );
	//connect(clipboardIconMenu, SIGNAL(hovered(QAction *)), this, SLOT(clipboardIconMenuActionHovered(QAction*)));
}
/*
void SystrayIcon::clipboardIconMenuActionHovered(QAction* act)
{
  QString tip = act->toolTip();
  QToolTip::showText(QCursor::pos(), tip);
}
*/

//  void SystrayIcon::focusOutEvent( QFocusEvent* )
//  {
//      qDebug() << "focus out !!!";
//  }

// void SystrayIcon::keyPressEvent(QKeyEvent *event)
//     {
// 	  qDebug() << "QKeyEvent!!!";
// 	   this->keyPressEvent(event);
// 	   event->accept();
// 	   qDebug() << "QKeyEvent!!!2";
// 	  /*
//         if (event->key() == Key_Escape) {
//             doEscape();
//         } else {
//             QWidget::keyPressEvent(event);
//         }*/
//     }

void SystrayIcon::clipSelectionChanged()
{
    //qDebug("clipSelectionChanged");
    QClipboard *clipboard = QApplication::clipboard();
    if (!clipboard->text(QClipboard::Selection).isEmpty())
        clipboard->setText(clipboard->text(QClipboard::Selection));
}

void SystrayIcon::updateStickyMenu()
{
    stickyMenu = new QMenu(tr("Sticky clipboard"));
    stickyMenu->setIcon(QIcon(":images/im-status-message-edit.png"));
    stickyMenu->addAction(editStickyEntriesAction);
    stickyMenu->addSeparator();

    int count = 0;
    QSignalMapper *signalMapper = new QSignalMapper(this);
    connect(signalMapper, SIGNAL(mapped(int)), this, SLOT(stickyTextClicked(int)));
    if (!stickyList.isEmpty())
       stickyList.clear();

    QFile file(sticky_file_name);
    if (file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        QTextStream in(&file);
        while (!in.atEnd())
        {
          QString line = in.readLine();
          QAction * actionT = new QAction( getDisplayText( line ), this );
          stickyList << line; //actionT->setData(QVariant(line));
          signalMapper->setMapping(actionT, count);
          connect( actionT, SIGNAL( triggered() ), signalMapper, SLOT( map() ) );
          stickyMenu->addAction(actionT);
          count++;
        }
        file.close();
    }
}

  void SystrayIcon::updateClipboardMenu()
{
    // Add new clipboard entry in menu list
    QClipboard *clipboard = QApplication::clipboard();    
	const QMimeData *mimeData = clipboard->mimeData();
	bool clipboardHistoryIsEmpty = false;
	//QMimeData *newMimeData = new QMimeData;
	//QString clipPixmapFileName;

	if (!ignore_images && mimeData->hasImage()) //if (clipboard->image())
	{
	  qDebug() << "clipboard has image !";
	  if (latest_clipboard_image_name.isEmpty()) // new pasted image
	  {
	  //if (!QFile::exists(SettingsInfo::configDir() + "/" + latest_clipboard_image_name))
	  //{
		QString clipPixmapFileName = "image" + QDateTime::currentDateTime().toString("ddMMyyyyhhmmss") + ".png";
		QPixmap clipPixmap (qvariant_cast<QPixmap>(mimeData->imageData()));
		
		if (clipPixmap.save(SettingsInfo::configDir() + "/" + clipPixmapFileName))
		{
		  qDebug() << "save image success :" << clipPixmapFileName;
		  latest_clipboard_image_name = clipPixmapFileName;
		}
		else
		  qDebug() << "save image error :" << clipPixmapFileName;
	  //}
	  }

	 // QIcon con = QIcon(":/" + clipPixmapFileName);
	  //con.addPixmap(clipPixmap);
	  
	  
	  //newMimeData->setImageData(mimeData->imageData());
	  //queue.enqueue(newMimeData);
	  queue.enqueue(tag_image + latest_clipboard_image_name);
	  latest_clipboard_image_name.clear();
	  
	  
	  
	  //setToolTip("<img src=':/" + clipPixmapFileName + "'>");
	}
    else if (mimeData->hasText())//if (!clipboard->text().isEmpty())
    {
	    //newMimeData->setText(mimeData->text());
        //queue.enqueue(newMimeData);
		//queue.enqueue(clipboard->text());
		queue.enqueue(mimeData->text());

        // check for duplicates
        for (int i = 0; i < queue.size()-1; ++i)
        {
            if (mimeData->text() == queue.at(i))//if (clipboard->text() == queue.at(i))
            {
                queue.removeAt(i);//qDebug("removed !");
                //break;
            }
        }
    }
    else if (queue.isEmpty())
	{  
	  clipboardHistoryIsEmpty = true;//qDebug("queue.isEmpty() !");
	}
    //else if ( !trayIconMenu->isEmpty() )
      //  return;

    // check maximum entries limit
    if (queue.size()>history_max_size)
	{
        queue.dequeue();
		//remove saved png images
		QStringList nameFilters;
		nameFilters << "*.png";
		QDir cfgDir (SettingsInfo::configDir());
		QStringList pngList = cfgDir.entryList(nameFilters, QDir::Files);
		foreach (QString pngfilename, pngList)
		{
		  //qDebug() << "png file found" << qPrintable(tag_image+pngfilename);
		  if (queue.indexOf(tag_image+pngfilename)==-1)
		  {
			qDebug() << "png file to remove :" << qPrintable(pngfilename);
			QFile::remove(SettingsInfo::configDir() + "/" + pngfilename);
		  }
		}
		//for (int k = 0 ; k < pngList.size() ; ++k)
		  //QFile::remove(SettingsInfo::configDir() + "/" + pngList.at(k));//qDebug() << "pngList" << qPrintable(pngList.at(k));
	}

    QString clipText;
	//QIcon actionTIcon = QIcon ();
	QString actionTIconName;
    clipboardIconMenu = new QMenu(/*this*/);
	if (activate_sticky == true)
	  clipboardIconMenu->addMenu(stickyMenu);
	clipboardIconMenu->addSeparator();
	
	if (clipboardHistoryIsEmpty)
	{
	  QAction * actionT = new QAction( tr("<clipboard is empty>"), this );
	  actionT->setDisabled(true);
	  clipboardIconMenu->addAction(actionT);
	  clearAction->setDisabled(true);
	}
	else
	{
      clearAction->setDisabled(false);
	  QSignalMapper *signalMapper = new QSignalMapper(this);
	  connect(signalMapper, SIGNAL(mapped(int)), this, SLOT(clipTextClicked(int)));
	  for (int j = 0; j < queue.size(); ++j)
	  {
		  actionTIconName="";
		  //qDebug() << "Sortie" << qPrintable(queue.at( queue.size()-j-1)->text());
		  //clipText = getDisplayText( queue.at( queue.size()-j-1) );
		  if (queue.at( queue.size()-j-1).isEmpty())
			clipText = "empty entry";
		  else if (queue.at( queue.size()-j-1).startsWith(tag_image))//if (queue.at( queue.size()-j-1)->hasText())
		  {
			  clipText = getDisplayText( queue.at( queue.size()-j-1).mid(tag_image.size() ) );//clipText = tr("- image -");
			  actionTIconName=":images/ksnapshot.png";
		  }
		  else //(queue.at( queue.size()-j-1)->hasImage())
			clipText = getDisplayText( queue.at( queue.size()-j-1) );
		  
		  QAction * actionT = new QAction( QIcon(actionTIconName), clipText, this );
		  //actionT->setToolTip("eee");
		  QFont font = actionT->font();
		  if (j==0)
		  {
			font.setBold(true);
			//actionT->setFont(font);
		  }
		  if (!actionTIconName.isEmpty())
		  {
			font.setItalic(true);
			//actionT->setFont(font);
		  }
		  actionT->setFont(font);
		  signalMapper->setMapping(actionT, queue.size()-j-1); // signalMapper->setMapping(actionT, j);
		  connect( actionT, SIGNAL( triggered() ), signalMapper, SLOT( map() ) );
		  clipboardIconMenu->addAction(actionT);
	  }
	}

    clipboardIconMenu->addSeparator();
    clipboardIconMenu->addAction(clearAction);
	// update tooltip info
	QString str = "_";
	//str.fill("A", entry_display_max_size);
	//qDebug() << "updateClipboardMenu() setToolTip";
	if (queue.isEmpty())
	  setToolTip(systray_tooltip);
	else
	{
	  if (queue.at( queue.size()-1 ).startsWith(tag_image))
		setToolTip( tr("- IMAGE -") + "\n  " + queue.at( queue.size()-1 ).mid(tag_image.size()));
	  else
		setToolTip( tr("- TEXT -") + "\n   " + getDisplayText(queue.at( queue.size()-1 ) ) );
	}
    //qDebug() << "updateClipboardMenu() passed";

}

void SystrayIcon::initSystrayMenu()
{
/*
    // Add new clipboard entry in menu list
    QClipboard *clipboard = QApplication::clipboard();
    bool clipboardHistoryIsEmpty = false;

    if (!clipboard->text().isEmpty())
    {
        queue.enqueue(clipboard->text());

        // check for duplicates
        for (int i = 0; i < queue.size()-1; ++i)
        {
            if (clipboard->text() == queue.at(i))
            {
                queue.removeAt(i); //qDebug("removed !");
                //break;
            }
        }
    }
    else if (queue.isEmpty())
	{  
	  clipboardHistoryIsEmpty = true;//qDebug("queue.isEmpty() !");
	}
    //else if ( !trayIconMenu->isEmpty() )
      //  return;

    // check maximum entries limit
    if (queue.size()>history_max_size)
        queue.dequeue();

    QString clipText = "";
    trayIconMenu = new QMenu();
	
	if (clipboardHistoryIsEmpty)
	{
	  QAction * actionT = new QAction( tr("<clipboard is empty>"), this );
	  actionT->setDisabled(true);
	  trayIconMenu->addAction(actionT);
	}
	else
	{
	  QSignalMapper *signalMapper = new QSignalMapper(this);
	  connect(signalMapper, SIGNAL(mapped(int)), this, SLOT(clipTextClicked(int)));
	  for (int j = 0; j < queue.size(); ++j)
	  {
		  clipText = getDisplayText( queue.at( queue.size()-j-1) );
		  QAction * actionT = new QAction( clipText, this );
		  if (j==0)
		  {
			QFont font = actionT->font();
			font.setBold(true);
			actionT->setFont(font);
		  }
		  signalMapper->setMapping(actionT, queue.size()-j-1); // signalMapper->setMapping(actionT, j);
		  connect( actionT, SIGNAL( triggered() ), signalMapper, SLOT( map() ) );
		  trayIconMenu->addAction(actionT);
	  }
	}
*/
    trayIconMenu = new QMenu(/*this*/);
    //trayIconMenu->addSeparator();
    //trayIconMenu->addAction(clearAction);
    trayIconMenu->addAction(configureAction);
    trayIconMenu->addAction(aboutAction);
    trayIconMenu->addSeparator();
    trayIconMenu->addAction(quitAction);
    setContextMenu(trayIconMenu);
}

void SystrayIcon::systrayClicked(QSystemTrayIcon::ActivationReason reason)
{
    switch ( reason )
        {
                case QSystemTrayIcon::DoubleClick:
                        break;
                case QSystemTrayIcon::Trigger:
                        clipboardIconMenu->exec(QCursor::pos()); //trayIconMenu->exec(QCursor::pos());                       
                        break;
                case QSystemTrayIcon::MiddleClick:
						if (activate_sticky == true)
						  stickyMenu->exec(QCursor::pos()); //showStickyDialog();
                        break;
                case QSystemTrayIcon::Context:
                        //showAbout();
                        break;
                case QSystemTrayIcon::Unknown:
                        //showAbout();
                        qDebug("Qlipper icon : Activated for Unknown reason");
                        break;
        }
}

QString SystrayIcon::getDisplayText(QString str)
{
    QString clipText = str.simplified();
    if ( clipText.size() > entry_display_max_size )
        clipText = clipText.left(entry_display_max_size) + " ...";

    return clipText;
}

void SystrayIcon::stickyTextClicked(int idx)
{
  //qDebug() << "stickyTextClicked " << qPrintable(QString::number(idx));
  QClipboard *clipboard = QApplication::clipboard();
  clipboard->setText(stickyList.at(idx));
}

void SystrayIcon::clipTextClicked(int idx)
{
    //qDebug() << "clipTextClicked " << qPrintable(QString::number(idx));
    QClipboard *clipboard = QApplication::clipboard();
    //clipboard->setText(queue.at(idx));
	
	/*
	if (queue.at(idx)->hasText())
	{
	  QString clipText = queue.at(idx)->text();
	  //clipboard->setText(queue.at(idx)->text());
	  queue.removeAt(idx);
	  clipboard->setText(clipText);
	}
	else if (!ignore_images && queue.at(idx)->hasImage())
	{
	  //QPixmap clipPixmap = new QPixmap(queue.at(idx)->imageData());
	  QPixmap clipPixmap (qvariant_cast<QPixmap>(queue.at(idx)->imageData()));
	  //QString clipPixmapFileName = "image" + QDateTime::currentDateTime().toString("ddMMyyyyhhmmss") + ".png";
	  //clipPixmap.save(SettingsInfo::configDir() + "/" + clipPixmapFileName);
	  queue.removeAt(idx);
	  clipboard->setPixmap(qvariant_cast<QPixmap>(clipPixmap));
	  //clipboard->setPixmap(qvariant_cast<QPixmap>(queue.at(idx)->imageData()));
	}
	*/
	if (queue.at(idx).startsWith(tag_image))
	{
	  if (!ignore_images)
	  {
		latest_clipboard_image_name = queue.at(idx).mid(tag_image.size());//qDebug() << "latest_clipboard_image_name =" << qPrintable(latest_clipboard_image_name);
		QPixmap clipPixmap (SettingsInfo::configDir() + "/" + latest_clipboard_image_name);
		queue.removeAt(idx);
		clipboard->setPixmap(qvariant_cast<QPixmap>(clipPixmap));
	  }
	}
	else
	{
	  QString clipText = queue.at(idx);
	  queue.removeAt(idx);
	  clipboard->setText(clipText);
	}
}

void SystrayIcon::clearClipboardHistory()
{
  if (queue.isEmpty())
    return;
  queue.clear();
  QFile::remove (history_file_name);
  QClipboard *clipboard = QApplication::clipboard();
  clipboard->clear(QClipboard::Selection);
  clipboard->clear(QClipboard::Clipboard);
  showMessage ( tr("Qlipper message"), tr("Qlipper history has been cleared."), QSystemTrayIcon::Information, 3000);
  //return;
  //initSystrayMenu();
}

void SystrayIcon::showAbout()
{
    QMessageBox msgBox;
	msgBox.setMinimumWidth(600);
    msgBox.setWindowIcon(QIcon(":images/klipper_dock.png"));
    msgBox.setIconPixmap (QPixmap(":images/klipper_dock.png"));//msgBox.setIcon(QMessageBox::Information);
    msgBox.setWindowTitle(tr("About Qlipper"));
    msgBox.setText(QString("<BIG><strong>Qlipper</strong> v%1</BIG>").arg(qApp->applicationVersion()));
    msgBox.setInformativeText(tr("Lightweight, cross-platform clipboard history applet.") + "<br><br><small>(c) 2010-2011 thierry deseez</small>");
    msgBox.setStandardButtons(QMessageBox::Ok);
    //msgBox.setStandardButtons(QMessageBox::Save | QMessageBox::Discard | QMessageBox::Cancel);
    //msgBox.setDefaultButton(QMessageBox::Save);
    msgBox.exec();
    /*
    int ret = msgBox.exec();
    if (ret==QMessageBox::Save)
        qDebug("Must Save message");
    */
}

void SystrayIcon::showStickyDialog()
{
  CustomCommandsEditor *customEdit = new CustomCommandsEditor(0,0,sticky_file_name,3);
  if (customEdit->exec() == QDialog::Accepted)
  {
      //qDebug("showStickyDialog accepted");
      updateStickyMenu();
      updateClipboardMenu();
  }
  /*
  QDialog* dlg = new QDialog;
  QPushButton * button = new QPushButton("&Download",dlg);
   connect(button, SIGNAL(clicked()), dlg, SLOT(close()));
  dlg->setMinimumWidth(600);
  dlg->exec();
  */
}

void SystrayIcon::showPrefsDialog()
{
    PrefsDialog *dlg = new PrefsDialog();

    if (dlg->exec() == QDialog::Accepted)
    {
        //qDebug() << "DIALOG ACCEPTEd";
        entry_display_max_size = dlg->spEntryWidth->value();
        history_max_size = dlg->spHistoryCount->value();
        clipboard_history_save = dlg->cbClipboardSave->isChecked();
        ignore_selection = dlg->cbIgnoreSelection->isChecked();
        ignore_images = dlg->cbIgnoreImages->isChecked();
        activate_sticky = dlg->cbActivateStickyClipboard->isChecked();

        QClipboard *clipboard = QApplication::clipboard();
        if (ignore_selection == false)
            connect( clipboard, SIGNAL(selectionChanged()), this, SLOT( clipSelectionChanged() ) );
        else
            clipboard->disconnect(SIGNAL(selectionChanged()));//qDebug() << "disconnected";
		
		if (activate_sticky == true)
		{
		  updateStickyMenu();
		  updateClipboardMenu();
		}
		else
		  updateClipboardMenu();

        saveSettings();
        qDebug() << "Settings saved";
    }
    delete dlg;
    //return;
/*
        QFile file(SettingsInfo::fileName());
        if (!file.open(QFile::ReadOnly | QFile::Text))
        {
        QMessageBox::warning(0, tr("Qlipper"),
                             tr("Cannot read file %1:\n%2.")
                             .arg(file.fileName())
                             .arg(file.errorString()));
        return;
        }

        QDialog *textEditDlg = new QDialog(0);
        //textEditDlg = new QDialog();

        QTextEdit *textEdit = new QTextEdit(textEditDlg);

        QLabel *label = new QLabel(file.fileName(), textEditDlg);        



       // QPushButton *pbClose = new QPushButton("&Close", textEditDlg);
        //QPushButton *pbSave = new QPushButton("&Save", textEditDlg);
        //QHBoxLayout *layoutH = new QHBoxLayout;
        //layoutH->addStretch();
        //layoutH->addWidget( pbSave );
        //layoutH->addWidget( pbClose );


        //QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Save | QDialogButtonBox::Cancel, Qt::Horizontal, textEditDlg );
        QDialogButtonBox *buttonBox = new QDialogButtonBox(textEditDlg);
        buttonBox->setStandardButtons(QDialogButtonBox::Save | QDialogButtonBox::Cancel);

        //buttonBox->addButton(tr("Cancelpop"), QDialogButtonBox::RejectRole );
        //buttonBox->addButton(tr("Saveoio"), QDialogButtonBox::ApplyRole );


        QVBoxLayout *layout = new QVBoxLayout;
        layout->addWidget( label );
        layout->addWidget( textEdit );
        layout->addWidget( buttonBox );
        //layout->addLayout( layoutH );

        QTextStream in(&file);
        textEdit->setPlainText(in.readAll());
        file.close();

        //connect( pbClose, SIGNAL( clicked() ), textEditDlg, SLOT( close() ) );
        //connect( pbSave, SIGNAL( clicked() ), textEditDlg, SLOT( accept() ) );
         //connect( pbSave, SIGNAL( clicked() ), textEditDlg, SLOT( done(int 12) ) );

        connect(buttonBox, SIGNAL(accepted()), textEditDlg, SLOT(accept()));
        connect(buttonBox, SIGNAL(rejected()), textEditDlg, SLOT(reject()));

        textEditDlg->setLayout(layout);
        textEditDlg->setModal(true);
        textEditDlg->setSizeGripEnabled(true);
        textEditDlg->setWindowTitle ( tr("Qlipper - Configuration File Editor") );
        int ret = textEditDlg->exec();
        qDebug() << "role" << qPrintable(QString::number(ret)) ;
        if ( ret == 0)//if ( ret == QDialogButtonBox::AcceptRole)
        {
            qDebug("Must Save");
        }
 */
}

void SystrayIcon::saveSettings()
{
    QSettings settings; //QSettings settings(settingsFile, QSettings::IniFormat);
    settings.beginGroup("MAIN");
     settings.setValue("entry_display_max_size", entry_display_max_size);
     settings.setValue("history_max_size", history_max_size);
     settings.setValue("clipboard_history_save", clipboard_history_save);
     settings.setValue("ignore_selection", ignore_selection);
     settings.setValue("ignore_images", ignore_images);
     settings.setValue("activate_sticky", activate_sticky);
    settings.endGroup();
}
/*
bool SystrayIcon::eventFilter(QObject *obj, QEvent *event)
{
  qDebug("eventFilter 1");
  if (event->type() == QEvent::KeyPress)
	qDebug("MouseButtonRelease 1");
  
  
    if (obj == this) {
    	//qDebug("yo 0");
        //if (event->type() == QEvent::MouseButtonPress)
        	if (event->type() == QEvent::DragEnter)
        {
            //QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
            //qDebug() << "Ate key press" << keyEvent->key();
            qDebug("yo 1");
            return true;
        } else {
            return false;
        }
    } else {
    	qDebug("yo 2");
        // pass the event on to the parent class
        return eventFilter(obj, event);
    }
}
*/

SystrayIcon::~SystrayIcon()
{
    qDebug() << "Bye";
	//int jojo;
	//QString clipPixmapStampName;;
	//QList<QAction*> actionsList = clipboardIconMenu->actions();
	
    if (clipboard_history_save == true && !queue.isEmpty())
    {
        QFile logfile (history_file_name);  //QFile logfile ("history.log");
        if (logfile.open(QFile::WriteOnly | QFile::Text))
        {
		   QTextStream ts( &logfile );
            for (int i = 0; i < queue.size(); ++i)
            {
			  //qDebug() << "history text:" << qPrintable(queue.at(i));
				ts << queue.at(i);
				if (i != queue.size()-1)
				  ts << tag_separator;
				/*
			  if (queue.at(i)->hasText())
			  {
				qDebug() << "history text:" << qPrintable(queue.at(i)->text());
				ts << queue.at(i)->text();
				if (i != queue.size()-1)
				  ts << "--SEPARATOR--";
			  }
			  else if (queue.at(i)->hasImage())
			  {
				qDebug() << "history : image found";
				//jojo = history_max_size - i - 1;
				//qDebug() << "actionsList" << qPrintable(QString::number(jojo)) <<  qPrintable(actionsList.at(jojo)->text());
				QPixmap clipPixmap (qvariant_cast<QPixmap>(queue.at(i)->imageData()));
				clipPixmapStampName = "image" + QDateTime::currentDateTime().toString("ddMMyyyyhhmmss") + "_" + QString::number(i) + ".png";
				clipPixmap.save(SettingsInfo::configDir() + "/" + clipPixmapStampName);
				//clipPixmap.save(SettingsInfo::configDir() + "/image" + QDateTime::currentDateTime().toString("ddMMyyyyhhmmss") + ".png");
				ts << "__--image:" + clipPixmapStampName;
				if (i != queue.size()-1)
				  ts << "--SEPARATOR--";
			  }
			  */
            }
            logfile.close();
        }
    }
}

