/*
 * lirccd v0.8 - Middle layer daemon between lircd and its clients
 * Copyright (C) 2003  Fredrik Tolf (fredrik@dolda2000.cjb.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _LIRCCD_H
#define _LIRCCD_H

#include <regex.h>

#include "command.h"

#define BIND_STOP 1
#define BIND_RECURSIVE 2

struct client
{
    struct client *next;
    int fd;
    int state;
    unsigned char *appname;
};

struct binding
{
    struct binding *next;
    struct binding *child;
    regex_t remote, button;
    struct instruction *code;
    int flags;
};

struct child
{
    struct child *next;
    int id;
    unsigned char *desc;
    int pid;
    int running, stopped;
    unsigned char *notify;
};

struct alarm
{
    struct alarm *next;
    int id;
    time_t time;
    unsigned char *func;
};

extern struct binding *bindings;
extern struct child *children;
extern struct alarm *alarms;
extern struct client *clients;
extern int endbinding;

struct binding *newbinding(unsigned char *remote, unsigned char *button, struct instruction *code);
void addbinding(struct binding **dest, struct binding *binding);
void freechild(struct child *child);
struct child *getchild(int id);
struct child *regchild(unsigned char *desc, int pid);
void freealarm(struct alarm *alarm);
struct alarm *regalarm(time_t time, unsigned char *func);

#endif
