/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef FXABOUTDIALOG_H
#define FXABOUTDIALOG_H

class FXAboutDialog : public FXDialogBox {
  FXDECLARE(FXAboutDialog)
private:
  FXFont * titlefont;
  FXFont * licensefont;
	FXIconPtr icon_scrobbler;
private:
  void setup(const FXString & name, const FXString & version, const FXString & author, const FXString & year,FXIcon *icon);
private:
  FXAboutDialog(){}
  FXAboutDialog(const FXAboutDialog&);
  FXAboutDialog& operator=(const FXAboutDialog&);
public:
/// Construct free-floating About dialog
  FXAboutDialog(FXApp* a,const FXString & name, const FXString & version, const FXString & author, const FXString & year,FXIcon * icon=NULL);

  /// Construct dialog which will always float over the owner window
  FXAboutDialog(FXWindow* owner,const FXString & name, const FXString & version, const FXString & author, const FXString & year,FXIcon * icon=NULL);

  /// Destructor
  virtual ~FXAboutDialog();
  };

#endif
