/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMICONTHEME_H
#define GMICONTHEME_H

class GMIconTheme {
private:
  static GMIconTheme * me;
protected:
#ifdef HAVE_EXTERNAL_ICONS
  void loadIcon(FXIconPtr & icon,FXIconSource & src,const FXString & basedir,const FXString & size,const char * key,const char * value);
#endif
  void loadIcon(FXIconPtr & icon,FXIconSource & source,const unsigned char * data,const char * type);
protected:
  FXIconPtr icon_file_small;
  FXIconPtr icon_file_big;
  FXIconPtr icon_audio_small;
  FXIconPtr icon_audio_big;
  FXIconPtr icon_folder_small;
  FXIconPtr icon_folder_big;
  FXIconPtr icon_folder;
  FXIconPtr icon_folderopen;
public:
  FXIcon* icon_about;
  FXIcon* icon_chain;
  FXIcon* icon_chain_broken;
public:
  FXIconPtr icon_copy;
  FXIconPtr icon_cut;
  FXIconPtr icon_paste;
  FXIconPtr icon_exit;
  FXIconPtr icon_close;
  FXIconPtr icon_play;
  FXIconPtr icon_pause;
  FXIconPtr icon_stop;
  FXIconPtr icon_next;
  FXIconPtr icon_prev;
  FXIconPtr icon_play_big;
  FXIconPtr icon_pause_big;
  FXIconPtr icon_stop_big;
  FXIconPtr icon_next_big;
  FXIconPtr icon_prev_big;
	FXIconPtr icon_settings;
	FXIconPtr icon_import;
	FXIconPtr icon_importfile;
	FXIconPtr icon_delete;
	FXIconPtr icon_edit;
  FXIconPtr icon_undo;
	FXIconPtr icon_empty;
	FXIconPtr icon_info;
	FXIconPtr icon_sleep;
	FXIconPtr icon_wakeup;
  FXIconPtr icon_homepage;
  FXIconPtr icon_sort;
  FXIconPtr icon_columns;
  FXIconPtr icon_album;
  FXIconPtr icon_artist;
  FXIconPtr icon_genre;
  FXIconPtr icon_source_library;
  FXIconPtr icon_source_playlist;
  FXIconPtr icon_source_internetradio;
  FXIconPtr icon_playlist;
  FXIconPtr icon_audio_volume_high;
  FXIconPtr icon_audio_volume_medium;
  FXIconPtr icon_audio_volume_low;
  FXIconPtr icon_audio_volume_muted;
  FXIconPtr icon_applogo;
  FXIconPtr icon_applogo_small;
  FXIconPtr icon_export;
  FXIconPtr icon_cover;
  FXIconPtr icon_find;
  FXIconPtr icon_sync;
  FXIconPtr icon_equalizer;
public:
  FXCursorPtr cursor_hand;
public:
  static GMIconTheme * instance();
public:
  GMIconTheme();

  void load();

  void loadAbout();

	void loadVolumeIcons(FXIconPtr & muted,FXIconPtr & low,FXIconPtr & medium,FXIconPtr &high);


  void loadToolbar(FXbool large);
  void updateToolbar(FXbool large);

  void loadFileAssociations(FXFileDict *);
  void loadDirAssociations(FXFileDict *);

  void freeFileAssociations();
  void freeDirAssociations();

  void loadChain();
  void freeChain();

  ~GMIconTheme();
  };



#endif

