/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMNOTIFY_H
#define GMNOTIFY_H

class GMNotifyDaemon : public FXObject {
FXDECLARE(GMNotifyDaemon)
protected:
  FXDBusConnection * dbus;
  FXuint replace_id;
protected:
  GMNotifyDaemon();
public:
  enum {
    ID_NOTIFY_RESULT = 1,
    ID_NOTIFY_CLOSE
    };
public:
  long onCmdNotify(FXObject*,FXSelector,void*);
  long onCmdClose(FXObject*,FXSelector,void*);
  
public:
  GMNotifyDaemon(FXDBusConnection * c);

  void notify(const FXchar * application,
              const FXchar * icon,
              const FXchar * summary,
              const FXchar * body,
              FXint          timeout,
              FXImage      * image);
              
  void closed(FXuint id);
  
  void close();

  virtual ~GMNotifyDaemon();            
  };

#endif



