/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMPLAYERMANAGER_H
#define GMPLAYERMANAGER_H

#include "common.h"

class GMPlayList;
class GMTrackList;
class GMTrackView;
class GMPlayer;
class GMWindow;
class GMRemote;
class GMTrackDatabase;
class GMPlayer;
class GMPlayList;
class GMSource;
class GMSourceView;
class GMFetch;
class GMEQDialog;
#ifdef HAVE_DBUS
class GMNotifyDaemon;
#endif
class GMAudioScrobbler;
class GMTrayIcon;

namespace FX {
class FXDBusConnection;
}


class GMPlayerManager : public FXObject {
FXDECLARE(GMPlayerManager)
private:
	static GMPlayerManager * myself;
protected:
	GMPreferences preferences;
  GMSourceList  sources;
  FXString      fifofilename;
  FXFile        fifo;
#if FOXVERSION < FXVERSION(1,7,0)
  FXuint        count_track_remaining;
#else
  FXlong        count_track_remaining;
#endif
protected:
#ifdef HAVE_DBUS
  FX::FXDBusConnection * sessionbus;
  FX::FXDBusConnection * systembus;
#endif
	FXApp 	 				     * application;
	GMWindow 				     * mainwindow;
	GMRemote 				     * remote;
	GMPlayer    		     * player;
  GMFetch              * fetch;
  GMTrayIcon           * trayicon;
#ifdef HAVE_DBUS
  GMNotifyDaemon       * daemon;
#endif
  GMAudioScrobbler     * lastfm;
protected:
  GMSource * source;
  GMTrack    trackinfo;
  FXbool     trackinfoset;
protected:
  FXbool hasSourceWithKey(const char * key) const;
  void cleanSourceSettings();
public:
  static GMPlayerManager * instance();
public:
	enum {
		ID_UPDATE_TRACK_DISPLAY = 1,
		ID_HANDLE_EVENTS,
		ID_COUNT_TRACK,
		ID_SLEEP_TIMER,
		ID_SCAN_AUDIOCD,
		ID_DDE_MESSAGE,
    ID_DOWNLOAD_COMPLETE,
    ID_PLAY_NOTIFY,
    ID_REMOTE,
    ID_WINDOW,
    ID_EQUALIZER,
    ID_SCROBBLER_ERROR,
    ID_PLAYER_ERROR,
    ID_CHILD
		};
public:
	long onUpdTrackDisplay(FXObject*,FXSelector,void*);
	long onUpdEvents(FXObject*,FXSelector,void*);
	long onCmdCountTrack(FXObject*,FXSelector,void*);
	long onCmdSleepTimer(FXObject*,FXSelector,void*);
	long onDDEMessage(FXObject*,FXSelector,void*);
  long onCmdDownloadComplete(FXObject*,FXSelector,void*);
  long onCmdCloseRemote(FXObject*,FXSelector,void*);
  long onCmdCloseWindow(FXObject*,FXSelector,void*);
  long onPlayNotify(FXObject*,FXSelector,void*);
  long onCmdChild(FXObject*,FXSelector,void*);
  long onCmdEqualizer(FXObject*,FXSelector,void*);
  long onScrobblerError(FXObject*,FXSelector,void*);
  long onPlayerError(FXObject*,FXSelector,void*);
protected:
  FXint  init_fifo(int & argc,char**argv);
	FXbool init_database(GMTrackDatabase *&,const FXString & filename);
  FXbool init_sources();
  void   init_window(FXbool wizard);
public:
	GMPlayerManager();

  FXint run(int & argc,char**argv);

  void showRemote();

  void hideRemote();


	/// Change Source
	void setSource(FXuint source);


  void update_tray_icon();


  FXint getNumSources() const { return sources.no(); }

  GMSource * getSource(FXint i) const { return sources[i]; }

  void removeSource(GMSource * src);

  void insertSource(GMSource * src) { sources.append(src); }

  void removePlayListSources();



  GMSource * getSource() const { return source; }

	GMWindow * getMainWindow() const { return mainwindow; }

	GMRemote * getRemote() const { return remote; }

  GMTrackView * getTrackView() const;

  GMSourceView * getSourceView() const;

  GMPlayer * getPlayer() const { return player; }

	GMPreferences & getPreferences() { return preferences; }

  GMAudioScrobbler * getAudioScrobbler() { return lastfm; }

  GMTrayIcon * getTrayIcon() { return trayicon; }

#ifdef HAVE_DBUS
  GMNotifyDaemon * getNotify() { return daemon; }

  FXbool hasSessionBus() const { return (sessionbus!=NULL) ; }
#endif

//	void init(int & argc,char**argv);

	void exit();

//	FXbool open();

	FXbool can_play() const;

	FXbool can_pause() const;

	FXbool can_unpause() const;

	FXbool can_next() const;

	FXbool can_prev() const;

	FXbool can_fastforward() const;

	FXbool can_fastbackward() const;

	FXbool can_stop() const;

	void play();

	FXbool play(const FXString & mrl);
	FXbool play(const FXStringList & mrl);

  void download(const FXString & mrl);

  void open(const FXString & mrl);


	void pause();

	void unpause();

	void stop(FXbool closedevice=false);

	void next();

	void prev();

	void fastforward();

	void fastbackward();

	void volume(FXint l);
	FXint volume() const;


	void seek(FXint pos);

	FXbool playlist_empty();

	void notify_playback_finished();

	void reset_track_display();

	void update_track_display(FXbool notify=true);

  void update_replay_gain();

	FXint current_position() const;

	FXbool playing() const;

	FXbool audio_device_opened() const;

	FXint get_prev() const;

	FXint get_next() const;

	/// Set Sleep Timer - 0 turns the timer off
#if FOXVERSION < FXVERSION(1,7,0)
  void setSleepTimer(FXuint ms);
#else
	void setSleepTimer(FXlong ns);
#endif

	FXbool hasSleepTimer();

	void handle_async_events();

	void show_message(const FXchar * title,const FXchar * msg);

  void setStatus(const FXString & msg);

  void register_global_hotkeys();

  FXbool handle_global_hotkeys(FXuint code);

	~GMPlayerManager();
	};

#endif
