/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMQUERY_H
#define GMQUERY_H

class FXCompileException : public FXErrorException {
private:
  static const FXchar exceptionName[];
public:
  FXCompileException():FXErrorException(FXCompileException::exceptionName){}
  FXCompileException(const FXchar *msg):FXErrorException(msg){}
  };


class FXExecuteException : public FXErrorException {
private:
  static const FXchar exceptionName[];
public:
  FXExecuteException():FXErrorException(FXExecuteException::exceptionName){}
  FXExecuteException(const FXchar *msg):FXErrorException(msg){}
  };

class FXQueryException : public FXErrorException {
private:
  static const FXchar exceptionName[];
public:
  FXQueryException():FXErrorException(FXQueryException::exceptionName){}
  FXQueryException(const FXchar *msg):FXErrorException(msg){}
  };

enum FXFieldType {
	TYPE_INTEGER=0,
	TYPE_FLOAT,
	TYPE_TEXT,
	TYPE_BLOB,
	TYPE_NULL,
	};

class GMDatabase;

class GMQuery{
private:
  GMDatabaseStatement * statement;
public:
  /// Create a empty query
  GMQuery();

	/// Create and compile a query. Throws FXCompileException if query couldn't be compiled
  GMQuery(GMDatabase * database,const FXString & query);

	/// Create a query. Delete Old Query. Throws FXCompileException if query couldn't be compiled
  void compile(GMDatabase & database,const FXString & query);

	/// Create a query. Delete Old Query. Throws FXCompileException if query couldn't be compiled
  void compile(GMDatabase * database,const FXString & query);

	/// Set Integer Parameter
  void setParameter(FXint p,FXint v);

	/// Set Integer Parameter
  void setParameter(FXint p,FXuint v);

  /// Set Double Parameter
  void setParameter(FXint p,FXfloat v);

  /// Set Double Parameter
  void setParameter(FXint p,FXdouble v);

  /// Set Long Parameter
  void setParameter(FXint p,FXlong v);

  /// Set String Parameter
  void setParameter(FXint p,const FXString & text);

	/// Get Num Parameters in Query
	FXint getNumParameters();

	/// Get Index for given parameter. Returns -1 if not found
	FXint getParameterIndex(const FXString & name);

  /// Get Name of Parameter
  FXString getParameterName(FXint p);

	/// Return number of fields the query returns
	FXint getNumFields() const;

	/// Returns num columns of data returned by query.
	FXint getNumData() const;

	/// Return the specified column name the query returned.
	FXString getFieldName(FXint i);

	/// Return the column type for the specified column
	FXFieldType getFieldType(FXint i);

  /// Get Text for Column
  void getResult(FXint column,FXString & v);

  /// Get Integer for Column
  void getResult(FXint column,FXint & v);

  /// Get Integer for Column
  void getResult(FXint column,FXuint & v);

  /// Get Double for Column
  void getResult(FXint column,FXdouble & v);

  /// Get Float for Column
  void getResult(FXint column,FXfloat & v);

  /// Get Bool for Column
  void getResult(FXint column,FXbool & v);

  /// Get Long for Column
  void getResult(FXint column,FXlong & v);


	const FXchar * getResult(FXint column);

  /// Execute Query. Returns TRUE if there are any results, FALSE when done and throws a FXExecuteException if there is an error.
  FXbool execute();

	FXbool perform();

	/// Reset the Query
  void reset();

  /// Clear the Query
  void clear();

  /// Destructor
  ~GMQuery();
  };


#endif

