/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMREMOTE_H
#define GMREMOTE_H

class GMWindow;


#ifdef HAVE_COMPACT_REMOTE

class GMRemote : public FXTopWindow {
FXDECLARE(GMRemote)
private:
  FXString     tip;
  FXIcon      *main;
  FXIcon      *logo;         // Big application icon
  FXIcon      *logohover;
  FXint        spotx;        // Grab-spot of mouse on rectangle
  FXint        spoty;
  FXint        progress;
  FXint        total;
  FXint        volume;
  FXbool       showVolume;
protected:
  virtual bool doesOverrideRedirect() const;
  GMRemote() {}
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onMouseWheel(FXObject*,FXSelector,void*);
  long onRightBtnPress(FXObject*,FXSelector,void*);
  long onRightBtnRelease(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
  long onRestoreProgress(FXObject*,FXSelector,void*);
  long onCmdShowManager(FXObject*,FXSelector,void*);
  long onSingleClick(FXObject*,FXSelector,void*);
public:
  enum {
    ID_RESTORE_PROGRESS = FXTopWindow::ID_LAST,
    ID_SHOW_MANAGER,
    ID_SINGLE_CLICK,
    };
public:
  /// Construct Remote Window
  GMRemote(FXApp* a,FXObject*,FXSelector);

  /// Update Cover
  void updateCover(FXImage * img);

  // Update Display
  void display(const GMTrack & track);

  void elapsed_time(FXint h,FXint m,FXint s,FXint p,FXbool playing);

	void update_volume_display(FXint){}

	void reset();

  void writeRegistry();

  void setProgress(FXint p);

  void setToolTip(const FXString & t) { tip = t; }

  virtual void show();

  virtual void hide();

  /// Create
  virtual void create();

  /// Return the default width of this window
  virtual FXint getDefaultWidth();

  /// Return the default height of this window
  virtual FXint getDefaultHeight();

  /// Destroy calculator
  virtual ~GMRemote();
  };

#else
class GMRemote : public FXMainWindow {
FXDECLARE(GMRemote)
private:
  FXLabel 		* title_label;
  FXLabel     * artistalbum_label;
  FX7Segment  * time_label;
  FXImageFrame* cover_label;
	FXPopupPtr    volumecontrol;
	FXMenuButton* volumebutton;
	FXSlider    * volumeslider;
	FXFontPtr     font_title;
  FXImagePtr    img_default;
	FXIconPtr     icon_volume_high;
	FXIconPtr     icon_volume_medium;
	FXIconPtr     icon_volume_low;
	FXIconPtr     icon_volume_muted;
protected:
  virtual bool doesOverrideRedirect() const;
  GMRemote() {}
public:
	long onCmdVolume(FXObject*,FXSelector,void*);
	long onCmdVolumeButton(FXObject*,FXSelector,void*);
	long onUpdVolumeButton(FXObject*,FXSelector,void*);
public:
  enum {
    ID_VOLUME_SLIDER = FXMainWindow::ID_LAST,
    ID_VOLUME_BUTTON,
    };
public:
  /// Construct Remote Window
  GMRemote(FXApp* a,FXObject*,FXSelector);

  void updateCover(FXImage * img);

  // Update Display
  void display(const GMTrack & track);

  void elapsed_time(FXint h,FXint m,FXint s,FXint p,FXbool playing);

	void update_volume_display(FXint l);

  void reset();

  void writeRegistry();

  /// Create
  virtual void create();

  /// Destroy calculator
  virtual ~GMRemote();
  };
#endif
#endif
