/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMSEARCHDIALOG_H
#define GMSEARCHDIALOG_H

class GMTrackDatabase;
class GMThread;
class GMAnimImage;

class GMThreadDialog : public FXDialogBox {
  FXDECLARE(GMThreadDialog)
protected:
  FXImage  * animation_image;
	GMThread * thread;
  GMThreadDialog();
private:
  GMThreadDialog(const GMThreadDialog&);
  GMThreadDialog& operator=(const GMThreadDialog&);
public:
	enum {
    ID_THREAD_DONE = FXDialogBox::ID_LAST,
    ID_THREAD_ERROR,
    ID_THREAD_PROGRESS
		};
public:
	long onCmdCancel(FXObject*,FXSelector,void*);
  long onThreadDone(FXObject*,FXSelector,void*);
  long onThreadError(FXObject*,FXSelector,void*);
public:
  GMThreadDialog(FXWindow * owner);

  virtual FXuint execute(FXuint placement=PLACEMENT_CURSOR);

  virtual ~GMThreadDialog();
  };



class GMImportDatabase : public GMThreadDialog {
  FXDECLARE(GMImportDatabase)
protected:
	FXTextField * text_file;
	FXTextField * text_dir;
	FXTextField * text_count;
protected:
  GMImportDatabase();
private:
  GMImportDatabase(const GMImportDatabase&);
  GMImportDatabase& operator=(const GMImportDatabase&);
public:
  long onThreadProgress(FXObject*,FXSelector,void*);
public:
  GMImportDatabase(FXWindow * owner,const FXStringList & files,const GMImportOptions & pref,FXint playlist,FXFont * font);
  virtual ~GMImportDatabase();
  };

  

class GMSyncDatabase : public GMThreadDialog {
  FXDECLARE(GMSyncDatabase)
protected:
  FXSwitcher    * contentswitcher;
  FXLabel       * label_title;
  FXLabel       * label_sync;
  FXProgressBar * progressbar;
	FXTextField   * text_file;
	FXTextField   * text_dir;
	FXTextField   * text_count;
protected:
  GMSyncDatabase();
private:
  GMSyncDatabase(const GMSyncDatabase&);
  GMSyncDatabase& operator=(const GMSyncDatabase&);
public:
  long onThreadProgress(FXObject*,FXSelector,void*);
public:
  GMSyncDatabase(FXWindow * owner,const FXStringList & files,const GMImportOptions & io,const GMSyncOptions & so,FXint playlist,FXbool tags,FXFont * font);
  virtual ~GMSyncDatabase();
  };

#endif
