/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMDB_H
#define GMDB_H

#include <new>
#include <fx.h>
#include <FXArray.h>
#include <FXTextCodec.h>
#include <sqlite3.h>


//#ifdef HAVE_EXTERNAL_ICONS
#define QMAKESTR(x) #x
#define MAKESTR(x) QMAKESTR(x)
//#endif


#define FOXVERSION ((FOX_LEVEL) + (FOX_MINOR*1000) + (FOX_MAJOR*100000))
#define FXVERSION(major,minor,release) ((release)+(minor*1000)+(major*100000))
#define SQVERSION(major,minor,release) ((release)+(minor*1000)+(major*1000000))

#if FOXVERSION < FXVERSION(1,7,0)
#define TIME_NSEC(ns) ((FXuint)(ns/1000000LL))
#define TIME_MSEC(ms) (ms)
#define TIME_SEC(s) 	(1000*s)
#define TIME_MIN(m) 	TIME_SEC(60*m)
#define TIME_HOUR(h) 	TIME_MIN(60*h)
#else
#define TIME_NSEC(ns) (ns)
#define TIME_SEC(s) 	(1000000000LL*s)
#define TIME_MSEC(ms) (1000000LL*ms)
#define TIME_MIN(m) 	TIME_SEC(60*m)
#define TIME_HOUR(h) 	TIME_MIN(60*h)
#endif

#if FOXVERSION >= FXVERSION(1,7,12)
#define GMStringVal(str) FXString::value(str)
#define GMStringFormat  FXString::value
#else
#define GMStringVal(str) FXStringVal(str)
#define GMStringFormat  FXStringFormat
#endif


#ifdef DEBUG
namespace FX {
extern FXlong fxgetticks();
}
#endif


#define UTF8_COPYRIGHT_SIGN "\xc2\xa9"
//#define UTF8_ELLIPSIS "\xe2\x80\xa6"
#define UTF8_ELLIPSIS "…"

#ifdef HAVE_DBUS
#define GOGGLESMM_DBUS_NAME "org.fifthplanet.gogglesmm"
#define GOGGLESMM_DBUS_PATH "/org/fifthplanet/gogglesmm"
#define GOGGLESMM_DBUS_INTERFACE "org.fifthplanet.gogglesmm"
#endif

//#if FOXVERSION < FXVERSION(1,7,0)
#include "GMAutoPtr.h"
#include "GMMessageChannel.h"
//#endif


/// Album number consists of a disc number + track number
#define GMALBUMNO(disc,track) ((((FX::FXuint)(track))&0xffff) | (((FX::FXuint)(disc))<<16))

/// Get the disc number from a album no.
#define GMDISCNO(s) ((FX::FXushort)(((s)>>16)&0xffff))

/// Get the track number from a album no.
#define GMTRACKNO(s) ((FX::FXushort)((s)&0xffff))


typedef sqlite3 GMDatabaseEngine;
typedef sqlite3_stmt GMDatabaseStatement;
typedef FXArray<FXString> FXStringList;
typedef FXArray<FXint> FXIntList;
typedef FXArray<FXlong> FXLongList;
typedef GMAutoPtr<FXCursor>   FXCursorPtr;
typedef GMAutoPtr<FXIcon>     FXIconPtr;
typedef GMAutoPtr<FXImage>    FXImagePtr;
typedef GMAutoPtr<FXMenuPane> FXMenuPtr;
typedef GMAutoPtr<FXFont>     FXFontPtr;
typedef GMAutoPtr<FXPopup>    FXPopupPtr;

enum {
  REPEAT_OFF    = 0,
  REPEAT_TRACK,
  REPEAT_ALL,
  };

enum {
  SOURCE_UNKNOWN  = -1,
  SOURCE_INVALID  = -1,
  SOURCE_DATABASE,
  SOURCE_DATABASE_PLAYLIST,
  SOURCE_INTERNET_RADIO,
  SOURCE_ALBUM,
  SOURCE_ARTIST,
  SOURCE_AUDIOCD,
  };

enum {
  HEADER_DEFAULT=0,
  HEADER_SHUFFLE=1,
  HEADER_BROWSE,
  HEADER_QUEUE,
  HEADER_TRACK,
  HEADER_TITLE,
  HEADER_ALBUM,
  HEADER_ARTIST,
  HEADER_TIME,
  HEADER_GENRE,
  HEADER_BITRATE,
	HEADER_RATING,
	HEADER_YEAR,
  HEADER_DISC,
  HEADER_ALBUM_ARTIST,
  HEADER_NONE
  };


struct GMTrack{
  FXString path;
	FXString mrl;
	FXString title;
	FXString artist;
	FXString album;
  FXString album_artist;
	FXString genre;
  FXint    year;
	FXint 	 no;
	FXint		 time;
  FXint    bitrate;
  FXdouble album_gain;
  FXdouble album_peak;
  FXdouble track_gain;
  FXdouble track_peak;
  void reset();
	};

struct GMStream{
  FXString url;
  FXString description;
	FXString genre;
  FXint    bitrate;
  };


class GMTrackItem;

/// Icon item collate function
typedef FXint (*GMTrackListSortFunc)(const GMTrackItem*,const GMTrackItem*);

//#include "GMTrackList.h"

struct GMColumn {
  FXString           name;
  FXint              type;
  FXint              size;
	FXint              index;
  GMTrackListSortFunc ascending;
  GMTrackListSortFunc descending;
  FXbool             show;
  FXbool             default_show;
  FXbool             default_browser_show;
  GMColumn() : size(60),index(0),show(false)  {}
  GMColumn(const FXchar * n,FXuint t,GMTrackListSortFunc a,GMTrackListSortFunc b,FXint sz=60,FXbool def_show=true,FXbool def_browser_show=true,FXint idx=0) : name(n),type(t),size(sz),index(idx),ascending(a),descending(b),show(true),default_show(def_show),default_browser_show(def_browser_show) {}
  };


typedef FXArray<GMColumn> GMColumnList;

//typedef FXArray<GMTrack> GMTrackArray;

extern const FXchar * fxtr(const FXchar *) __attribute__ ((format_arg(1)));

#define notr(x) x
#define fxtrformat(x) fxtr(x)



enum {
  WINDOWTYPE_DIALOG,
  WINDOWTYPE_COMBO,
  WINDOWTYPE_POPUP_MENU,
  WINDOWTYPE_DROPDOWN_MENU,
  WINDOWTYPE_TOOLTIP,
  };

extern void ewmh_change_window_type(const FXWindow *,FXuint);

#define INVALID_TRACK -1

#include "GMQuery.h"
#include "GMDatabase.h"

#include "GMPreferences.h"


#include <tag.h>

#ifdef HAVE_TAGLIB_16
#ifndef DISABLE_ASF_SUPPORT
#if !defined(TAGLIB_WITH_ASF) || (TAGLIB_WITH_ASF==0)
#define DISABLE_ASF_SUPPORT=0
#endif
#endif

#ifndef DISABLE_MP4_SUPPORT
#if !defined(TAGLIB_WITH_MP4) || (TAGLIB_WITH_MP4==0)
#define DISABLE_MP4_SUPPORT=0
#endif
#endif
#endif


#endif

