/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#include <xine.h>
#include "common.h"
#include "GMAbout.h"
#include "icons.h"
#ifdef HAVE_DBUS
#include "fxdbus.h"
#endif
#include <FXPNGIcon.h>

// Object implementation
FXIMPLEMENT(FXAboutDialog,FXDialogBox,NULL,0)

FXAboutDialog::FXAboutDialog(FXApp * app,const FXString & name, const FXString & version, const FXString & author, const FXString & year,FXIcon * icon) : FXDialogBox(app,"",DECOR_ALL,0,0,0,0,0,0,0,0,0,0) {
  setup(name,version,author,year,icon);
  setTitle(tr("About")+FXString(" ")+name);
  }

FXAboutDialog::FXAboutDialog(FXWindow* owner,const FXString & name, const FXString & version, const FXString & author, const FXString & year,FXIcon * icon) : FXDialogBox(owner,"",DECOR_TITLE|DECOR_BORDER,0,0,0,0,0,0,0,0,0,0) {
  setup(name,version,author,year,icon);
  setTitle(tr("About")+FXString(" ")+name);
  }

FXAboutDialog::~FXAboutDialog(){
  delete titlefont;
  delete licensefont;
  }


void FXAboutDialog::setup(const FXString & name, const FXString & version, const FXString & author, const FXString & year,FXIcon * icon){

#if FOXVERSION < FXVERSION(1,7,17)
  FXFontDesc fontdescription;
  getApp()->getNormalFont()->getFontDesc(fontdescription);
#else
  FXFontDesc fontdescription = getApp()->getNormalFont()->getFontDesc();
#endif
  fontdescription.size  += 10;
  fontdescription.weight = FXFont::Bold;
  titlefont = new FXFont(getApp(),fontdescription);
  titlefont->create();

#if FOXVERSION < FXVERSION(1,7,17)
  getApp()->getNormalFont()->getFontDesc(fontdescription);
#else
  fontdescription = getApp()->getNormalFont()->getFontDesc();
#endif
  fontdescription.size -= 10;
  licensefont  = new FXFont(getApp(),fontdescription);
  licensefont->create();


  FXLabel * label = new FXLabel(this,name,icon,ICON_ABOVE_TEXT|LAYOUT_CENTER_X|JUSTIFY_CENTER_X|LAYOUT_FILL_X,0,0,0,0,0,0,0,0);
  label->setFont(titlefont);
  label->setBackColor(FXRGB(255,255,255));
  label->setTextColor(FXRGB(0,0,0));


  const FXchar * gpl = "This program is free software: you can\n"
                 "redistribute it and/or modify it under the\n"
                 "terms of the GNU General Public License\n"
                 "as published by the Free Software Foundation,\n"
                 "either version 3 of the License, or (at your\n"
                 "option) any later version.";

  FXString title = FXString("Copyright ") + UTF8_COPYRIGHT_SIGN + " " + year + " "  + author;

  label = new FXLabel(this,"v" + version,NULL,LAYOUT_CENTER_X|LAYOUT_FILL_X,0,0,0,0,5,5,0,5);
  label->setBackColor(FXRGB(255,255,255));
  label->setTextColor(FXRGB(0,0,0));

  label = new FXLabel(this,title,NULL,LAYOUT_CENTER_X|LAYOUT_FILL_X,0,0,0,0,5,5,0,0);
  label->setBackColor(FXRGB(255,255,255));
  label->setTextColor(FXRGB(0,0,0));

  label = new FXLabel(this,gpl,NULL,LAYOUT_CENTER_X|LAYOUT_FILL_X,0,0,0,0,5,5,5,0);
  label->setBackColor(FXRGB(255,255,255));
  label->setTextColor(FXRGB(0,0,0));
  label->setFont(licensefont);

#if !defined(HAVE_TAGLIB_EXTRAS) && ! defined(HAVE_TAGLIB_16) && ( !defined(DISABLE_ASF_SUPPORT) || !defined(DISABLE_MP4_SUPPORT) )
  label = new FXLabel(this,"TagLib ASF / MP4 Support\nCopyright "  UTF8_COPYRIGHT_SIGN  " 2005-2009 Lukáš Lalinský",NULL,LAYOUT_CENTER_X|LAYOUT_FILL_X,0,0,0,0,5,5,5,0);
  label->setBackColor(FXRGB(255,255,255));
  label->setTextColor(FXRGB(0,0,0));
  label->setFont(licensefont);
#endif

  icon_scrobbler = new FXPNGIcon(getApp(),x17_audioscrobbler_png);
  icon_scrobbler->blend(FXRGB(255,255,255));
 	label = new FXLabel(this,FXString::null,icon_scrobbler,LAYOUT_CENTER_X|LAYOUT_FILL_X,0,0,0,0,5,5,5,5);
  label->setTextColor(FXRGB(0,0,0));
  label->setBackColor(FXRGB(255,255,255));


  FXint xineversion[3];
  xine_get_version(&xineversion[0],&xineversion[1],&xineversion[2]);

  FXString libraries;

#ifdef HAVE_DBUS
  libraries.format("Build with FOX %d.%d.%d, Xine %d.%d.%d,\nSQLite %s, DBus %s and Taglib.",fxversion[0],fxversion[1],fxversion[2],xineversion[0],xineversion[1],xineversion[2],sqlite3_libversion(),FXDBusConnection::dbusversion().text());
#else
  libraries.format("Build with FOX %d.%d.%d, Xine %d.%d.%d,\nSQLite %s and Taglib.",fxversion[0],fxversion[1],fxversion[2],xineversion[0],xineversion[1],xineversion[2],sqlite3_libversion());
#endif
  label = new FXLabel(this,libraries,NULL,LAYOUT_CENTER_X|LAYOUT_FILL_X,0,0,0,0,5,5,5,5);
  label->setBackColor(FXRGB(255,255,255));
  label->setTextColor(FXRGB(0,0,0));
  label->setFont(licensefont);


  new FXSeparator(this,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  FXHorizontalFrame *closebox=new FXHorizontalFrame(this,LAYOUT_BOTTOM|LAYOUT_FILL_X,0,0,0,0);
  new FXButton(closebox,tr("&Close"),NULL,this,FXDialogBox::ID_CANCEL,BUTTON_INITIAL|BUTTON_DEFAULT|LAYOUT_CENTER_X|FRAME_RAISED|FRAME_THICK,0,0,0,0,20,20);
  }
