/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2007-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#include <xincs.h>

/*

  Need to redesign this.

*/


// Needed for pthread_kill
#if defined(__FreeBSD__) || defined(__OpenBSD__)
#include <pthread.h>
#endif
#include <signal.h>

#include "common.h"
#include "GMThread.h"
#include "GMFetch.h"
#include "GMList.h"
#include "GMSource.h"
#include "GMPlayerManager.h"
#include "GMURL.h"

#include <FXDLL.h>


#if FOXVERSION < FXVERSION(1,7,0)
static void * dll_fetch = NULL;
#else
static FXDLL dll_fetch;
#endif


typedef struct url*     (*func_fetch_parse_url)(const char *);
typedef struct fetchIO* (*func_fetch_get) (struct url *, const char *);
typedef void            (*func_fetch_free_url)(struct url *);
typedef void            (*func_fetch_close)(fetchIO*);
typedef ssize_t	        (*func_fetch_read)(fetchIO*,void *, size_t);

static func_fetch_get       dll_fetch_get                 = NULL;
static func_fetch_parse_url dll_fetch_parse_url           = NULL;
static func_fetch_free_url  dll_fetch_free_url            = NULL;
static int *                dll_fetch_restart_calls       = NULL;
static int *                dll_fetch_last_error_code     = NULL;
static char *               dll_fetch_last_error_string   = NULL;
static func_fetch_close     dll_fetch_close               = NULL;
static func_fetch_read      dll_fetch_read                = NULL;


#if 0
/* Last error code */
extern int		 fetchLastErrCode;
#define MAXERRSTRING 256
extern char		 fetchLastErrString[MAXERRSTRING];
#endif

GMFetch::GMFetch(FXObject* tgt) : GMThread(tgt) {
#if FOXVERSION < FXVERSION(1,7,0)
  if (dll_fetch==NULL) {
    dll_fetch = fxdllOpen("libfetch.so");
    if (dll_fetch) {
      dll_fetch_get               = (func_fetch_get)       fxdllSymbol(dll_fetch,"fetchGet");
      dll_fetch_parse_url         = (func_fetch_parse_url) fxdllSymbol(dll_fetch,"fetchParseURL");
      dll_fetch_free_url          = (func_fetch_free_url)  fxdllSymbol(dll_fetch,"fetchFreeURL");
      dll_fetch_close             = (func_fetch_close)     fxdllSymbol(dll_fetch,"fetchIO_close");
      dll_fetch_read              = (func_fetch_read)      fxdllSymbol(dll_fetch,"fetchIO_read");
      dll_fetch_restart_calls     = (int*)                 fxdllSymbol(dll_fetch,"fetchRestartCalls");
      dll_fetch_last_error_code   = (int*)                 fxdllSymbol(dll_fetch,"fetchLastErrCode");
      dll_fetch_last_error_string = (char*)                fxdllSymbol(dll_fetch,"fetchLastErrString");

      if (dll_fetch_get == NULL ||
          dll_fetch_parse_url == NULL ||
          dll_fetch_free_url == NULL ||
          dll_fetch_close == NULL ||
          dll_fetch_read == NULL ||
          dll_fetch_restart_calls == NULL ||
          dll_fetch_last_error_code == NULL ||
          dll_fetch_last_error_string == NULL
          ) {

        fxdllClose(dll_fetch);
        dll_fetch=NULL;
        errormsg="Incompatible version of libfetch";
        }
      }
    else {
      errormsg="Error loading libfetch.so.";
      }
    }
#else
  if (!dll_fetch.loaded()) {
    if (dll_fetch.load("libfetch.so")) {
      dll_fetch_get               = (func_fetch_get)       dll_fetch.address("fetchGet");
      dll_fetch_parse_url         = (func_fetch_parse_url) dll_fetch.address("fetchParseURL");
      dll_fetch_free_url          = (func_fetch_free_url)  dll_fetch.address("fetchFreeURL");
      dll_fetch_close             = (func_fetch_close)     dll_fetch.address("fetchIO_close");
      dll_fetch_read              = (func_fetch_read)      dll_fetch.address("fetchIO_read");
      dll_fetch_restart_calls     = (int*)                 dll_fetch.address("fetchRestartCalls");
      dll_fetch_last_error_code   = (int*)                 dll_fetch.address("fetchLastErrCode");
      dll_fetch_last_error_string = (char*)                dll_fetch.address("fetchLastErrString");

      if (dll_fetch_get == NULL ||
          dll_fetch_parse_url == NULL ||
          dll_fetch_free_url == NULL ||
          dll_fetch_close == NULL ||
          dll_fetch_read == NULL ||
          dll_fetch_restart_calls == NULL ||
          dll_fetch_last_error_code == NULL ||
          dll_fetch_last_error_string == NULL
          ) {

        dll_fetch.unload();
        errormsg="Incompatible version of libfetch";
        }
      }
    else {
      errormsg="Error loading libfetch.so.";
      }
    }
#endif
  }


static FXbool getLine(struct fetchIO * io,FXString & line){
  FXchar c;
  while(dll_fetch_read(io,&c,1)==1) {
    if (c=='\r') continue;
    if (c=='\n') return true;
    line+=(FXchar)c;
    }
  return false;
  }


static void parseM3U(struct fetchIO * io,FXStringList & mrl){
  FXString line;
  while(getLine(io,line)){
    if (line.empty() || line[0]=='#' ) continue;
    mrl.append(line);
    line.clear();
    }
  }

static void parsePLS(struct fetchIO * io,FXStringList & mrl){
  FXString line;
  while(getLine(io,line)){
    if (compare(line,"File",4)==0) {
      mrl.append(line.after('='));
      }
    line.clear();
    }
  }


FXint GMFetch::run() {
  struct url * uri = dll_fetch_parse_url(filename.text());
  if (uri==NULL) {
    errormsg="Invalid url specified";
    feedback.message(target,FXSEL(SEL_COMMAND,GMPlayerManager::ID_DOWNLOAD_COMPLETE),NULL,0);
    return 0;
    }
  (*dll_fetch_restart_calls)=0;
  fetchIO * f = dll_fetch_get(uri,"r");

  if ((*dll_fetch_last_error_code)!=0 || f==NULL) {
    if ((*dll_fetch_last_error_code)==0)
      errormsg="Not Found";
    else
      errormsg=dll_fetch_last_error_string;
    }
  else {
    if (comparecase(FXPath::extension(GMURL::path(filename)),"m3u")==0){
      parseM3U(f,mrl);
      }
    else if (comparecase(FXPath::extension(GMURL::path(filename)),"pls")==0){
      parsePLS(f,mrl);
      }
    }
  if (f) dll_fetch_close(f);
  dll_fetch_free_url(uri);
  feedback.message(target,FXSEL(SEL_COMMAND,GMPlayerManager::ID_DOWNLOAD_COMPLETE),NULL,0);
  return 0;
  }


void GMFetch::get(const FXString & file) {
  filename=file;
#if FOXVERSION < FXVERSION(1,7,0)
  if (dll_fetch==NULL)
#else
  if (!dll_fetch.loaded())
#endif
    feedback.message(target,FXSEL(SEL_COMMAND,GMPlayerManager::ID_DOWNLOAD_COMPLETE),NULL,0);
  else
    start();
  }

void GMFetch::dispose() {
  GMThread::dispose();
  if (id() && FXThread::running() ) {
    pthread_kill((pthread_t)id(),SIGINT);
    }
  }

GMFetch::~GMFetch(){
#if FOXVERSION < FXVERSION(1,7,0)
  if (dll_fetch) {
    fxdllClose(dll_fetch);
    dll_fetch=NULL;
    }
#else
  if (dll_fetch.loaded()){
    dll_fetch.unload();
    }
#endif
  }
