/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#include "common.h"
#include "GMIconTheme.h"
#include "icons.h"

#define DEFAULT_ICON_DIRECTORY MAKESTR(DEFAULT_ICON_PATH)


static void invert(FXImage * icon) {
  FXColor color;
  for (FXint y=0;y<icon->getHeight();y++){
    for (FXint x=0;x<icon->getWidth();x++){
      color=icon->getPixel(x,y);
      icon->setPixel(x,y,FXRGBA(256-FXREDVAL(color),256-FXGREENVAL(color),256-FXBLUEVAL(color),FXALPHAVAL(color)));
      }
    }
  }

#if 0
static void colorize(FXIcon * icon,FXColor nc) {
  FXColor color;
  FXfloat luminance;
  for (FXint y=0;y<icon->getHeight();y++){
    for (FXint x=0;x<icon->getWidth();x++){
      color=icon->getPixel(x,y);
      if (FXALPHAVAL(color)>0) {
        luminance = 1.0f - (((FXREDVAL(color)*0.3f)+(FXGREENVAL(color)*0.59f)+(FXBLUEVAL(color)*0.11f)) / 256.0f);
        icon->setPixel(x,y,FXRGBA((FXuchar)(luminance*FXREDVAL(nc)),(FXuchar)(luminance*FXGREENVAL(nc)),(FXuchar)(luminance*FXBLUEVAL(nc)),FXALPHAVAL(color)));
        }
      }
    }
  }
#endif

void colorize_bitmap(FXImage * icon,FXColor nc) {
  FXColor color;
  for (FXint y=0;y<icon->getHeight();y++){
    for (FXint x=0;x<icon->getWidth();x++){
      color=icon->getPixel(x,y);
      if (FXALPHAVAL(color)>0) {
        icon->setPixel(x,y,FXRGBA(FXREDVAL(nc),FXGREENVAL(nc),FXBLUEVAL(nc),FXALPHAVAL(color)));
        }
      }
    }
  }



class FXImageHelper : public FXImage {
public:
  FXImageHelper();
  void clearOwnerShip() { options&=~IMAGE_OWNED; }
  };


static void clearOwnership(FXIcon * icon) {
  FXImageHelper * img = (FXImageHelper*)icon;
  img->clearOwnerShip();
  }

GMIconTheme * GMIconTheme::me=NULL;

GMIconTheme::GMIconTheme() {
  FXASSERT(me==NULL);
  me=this;

  icon_about=NULL;
  icon_chain=NULL;
  icon_chain_broken=NULL;

  cursor_hand=new FXGIFCursor(FXApp::instance(),cursor_hand_gif,5,0);
  cursor_hand->create();
  }

GMIconTheme::~GMIconTheme() {
  }

GMIconTheme * GMIconTheme::instance(){
  return me;
  }

#ifdef HAVE_EXTERNAL_ICONS
void GMIconTheme::loadIcon(FXIconPtr & icon,FXIconSource & src,const FXString & basedir,const FXString & size,const char * key,const char * value) {
  FXIcon * newicon = src.loadIconFile(basedir+PATHSEPSTRING+size+PATHSEPSTRING+FXApp::instance()->reg().readStringEntry("user-icons",key,value));
#ifdef DEBUG
  fxmessage("load: %s\n",FXString(basedir+PATHSEPSTRING+size+PATHSEPSTRING+FXApp::instance()->reg().readStringEntry("user-icons",key,value)).text());
#endif
  if (!newicon) {
#ifdef DEBUG
		fxmessage("Failed to load: %s\n",FXString(basedir+PATHSEPSTRING+size+PATHSEPSTRING+FXApp::instance()->reg().readStringEntry("user-icons",key,value)).text());
#endif
    newicon = src.loadIconData(x16_status_iconloaderror_gif,"gif");
    FXASSERT(newicon);
    FXApp::instance()->reg().writeStringEntry("user-icons",key,value);
    }
  if (icon) {
    icon->destroy();
    icon->setData(newicon->getData(),newicon->getOptions(),newicon->getWidth(),newicon->getHeight());
    clearOwnership(newicon);
    delete newicon;
    }
  else {
    icon=newicon;
    }
  }


#endif

void GMIconTheme::loadIcon(FXIconPtr & icon,FXIconSource & source,const unsigned char * data,const char * type) {
  FXIcon * newicon = source.loadIconData(data,type);
  FXASSERT(newicon);
  if (icon) {
    icon->destroy();
    icon->setData(newicon->getData(),newicon->getOptions(),newicon->getWidth(),newicon->getHeight());
    clearOwnership(newicon);
    delete newicon;
    }
  else {
    icon=newicon;
    }
  }



void GMIconTheme::loadVolumeIcons(FXIconPtr & muted,FXIconPtr & low,FXIconPtr & medium,FXIconPtr &high){
  FXIconSource source(FXApp::instance());
#ifdef HAVE_EXTERNAL_ICONS
  const FXString base = FXApp::instance()->reg().readStringEntry("user-interface","icon-base-dir",DEFAULT_ICON_DIRECTORY);
  const FXString big     = FXApp::instance()->reg().readStringEntry("user-interface","icon-base-size-big","22x22");
  const FXString small   = FXApp::instance()->reg().readStringEntry("user-interface","icon-base-size-small","16x16");
	loadIcon(high,source,base,small,"status-audio-volume-high","status/audio-volume-high.png");
  loadIcon(medium,source,base,small,"status-audio-volume-medium","status/audio-volume-medium.png");
  loadIcon(low,source,base,small,"status-audio-volume-low","status/audio-volume-low.png");
  loadIcon(muted,source,base,small,"status-audio-volume-muted","status/audio-volume-muted.png");
#else /* HAVE_BUILDIN_ICONS */
 	high   = source.loadIconData(x16_status_audiovolumehigh_png,"png");
  medium = source.loadIconData(x16_status_audiovolumemedium_png,"png");
  low    = source.loadIconData(x16_status_audiovolumelow_png,"png");
  muted  = source.loadIconData(x16_status_audiovolumemuted_png,"png");
#endif
  high->blend(FXApp::instance()->getBaseColor());
  medium->blend(FXApp::instance()->getBaseColor());
  low->blend(FXApp::instance()->getBaseColor());
  muted->blend(FXApp::instance()->getBaseColor());
  high->create();
  medium->create();
  low->create();
  muted->create();
	}


void GMIconTheme::load() {
  FXIconSource source(FXApp::instance());
#ifdef HAVE_EXTERNAL_ICONS
  const FXString base    = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-dir",DEFAULT_ICON_DIRECTORY);
  const FXString big     = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-size-big","22x22");
  const FXString small   = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-size-small","16x16");

  FXApp::instance()->reg().writeStringEntry("user-icons","icon-base-dir",base.text());
  FXApp::instance()->reg().writeStringEntry("user-icons","icon-base-size-big",big.text());
  FXApp::instance()->reg().writeStringEntry("user-icons","icon-base-size-small",small.text());

  loadIcon(icon_copy,source,base,small,"actions-edit-copy","actions/edit-copy.png");
  loadIcon(icon_cut,source,base,small,"actions-edit-cut","actions/edit-cut.png");
  loadIcon(icon_paste,source,base,small,"actions-edit-paste","actions/edit-paste.png");
  loadIcon(icon_delete,source,base,small,"actions-edit-delete","actions/edit-delete.png");
  loadIcon(icon_undo,source,base,small,"actions-edit-undo","actions/edit-undo.png");
  loadIcon(icon_play,source,base,small,"actions-media-playback-start","actions/media-playback-start.png");
  loadIcon(icon_pause,source,base,small,"actions-media-playback-pause","actions/media-playback-pause.png");
  loadIcon(icon_next,source,base,small,"actions-media-skip-forward","actions/media-skip-forward.png");
  loadIcon(icon_prev,source,base,small,"actions-media-skip-backward","actions/media-skip-backward.png");
  loadIcon(icon_stop,source,base,small,"actions-media-playback-stop","actions/media-playback-stop.png");
  loadIcon(icon_import,source,base,small,"places-folder","places/folder.png");
  loadIcon(icon_importfile,source,base,small,"actions-document-open","actions/document-open.png");
  loadIcon(icon_exit,source,base,small,"actions-exit","actions/exit.png");
  loadIcon(icon_close,source,base,small,"actions-window-close","actions/window-close.png");
  loadIcon(icon_find,source,base,small,"actions-edit-find","actions/edit-find.png");
  loadIcon(icon_sync,source,base,small,"actions-view-refresh","actions/view-refresh.png");
  loadIcon(icon_album,source,base,small,"devices-media-optical","devices/media-optical.png");
  loadIcon(icon_artist,source,base,small,"apps-system-users","apps/system-users.png");
  loadIcon(icon_genre,source,base,small,"actions-bookmark-new","actions/bookmark-new.png");
  loadIcon(icon_export,source,base,small,"actions-document-save","actions/document-save.png");

  loadIcon(icon_homepage,source,base,small,"categories-applications-internet","categories/applications-internet.png");
  loadIcon(icon_info,source,base,small,"apps-help-browser","apps/help-browser.png");
  loadIcon(icon_source_library,source,base,big,  "places-user-home","places/user-home.png");
  loadIcon(icon_source_internetradio,source,base,big,"categories-applications-internet","categories/applications-internet.png");
  loadIcon(icon_settings,source,base,small,"categories-preferences-apps","categories/preferences-desktop.png");
  loadIcon(icon_edit,source,base,small,"apps-accessorries-text-editor","apps/accessories-text-editor.png");
#else
  loadIcon(icon_copy,source,x16_actions_editcopy_png,"png");
  loadIcon(icon_cut,source,x16_actions_editcut_png,"png");
  loadIcon(icon_paste,source,x16_actions_editpaste_png,"png");
  loadIcon(icon_delete,source,x16_actions_editdelete_png,"png");
  loadIcon(icon_undo,source,x16_actions_editundo_png,"png");
  loadIcon(icon_find,source,x16_actions_editfind_png,"png");
  loadIcon(icon_sync,source,x16_actions_viewrefresh_png,"png");
  loadIcon(icon_play,source,x16_actions_mediaplaybackstart_gif,"gif");
  loadIcon(icon_pause,source,x16_actions_mediaplaybackpause_gif,"gif");
  loadIcon(icon_next,source,x16_actions_mediaskipforward_gif,"gif");
  loadIcon(icon_prev,source,x16_actions_mediaskipbackward_gif,"gif");
  loadIcon(icon_stop,source,x16_actions_mediaplaybackstop_gif,"gif");
  loadIcon(icon_import,source,x16_places_folder_png,"png");
  loadIcon(icon_importfile,source,x16_actions_documentopen_png,"png");
  loadIcon(icon_exit,source,x16_actions_exit_png,"png");
  loadIcon(icon_close,source,x16_actions_windowclose_png,"png");
  loadIcon(icon_album,source,x16_devices_mediaoptical_png,"png");
  loadIcon(icon_artist,source,x16_apps_systemusers_png,"png");
  loadIcon(icon_genre,source,x16_actions_bookmarknew_png,"png");
  loadIcon(icon_export,source,x16_actions_documentsave_png,"png");
  loadIcon(icon_homepage,source,x16_apps_internetwebbrowser_png,"png");
  loadIcon(icon_info,source,x16_apps_helpbrowser_png,"png");
  loadIcon(icon_source_library,source,x22_places_userhome_png,"png");
  loadIcon(icon_source_internetradio,source,x22_apps_internetwebbrowser_png,"png");
  loadIcon(icon_settings,source,x16_apps_accessoriestexteditor_png,"png");
  loadIcon(icon_edit,source,x16_apps_accessoriestexteditor_png,"png");


  colorize_bitmap(icon_play,FXApp::instance()->getForeColor());
  colorize_bitmap(icon_pause,FXApp::instance()->getForeColor());
  colorize_bitmap(icon_next,FXApp::instance()->getForeColor());
  colorize_bitmap(icon_prev,FXApp::instance()->getForeColor());
  colorize_bitmap(icon_stop,FXApp::instance()->getForeColor());


#endif

  loadIcon(icon_sort,source,x16_actions_viewsortdescending_png,"png");
  loadIcon(icon_playlist,source,x16_mimetypes_sourceplaylist_png,"png");
  loadIcon(icon_source_playlist,source,x22_mimetypes_sourceplaylist_png,"png");
  loadIcon(icon_applogo,source,x32_apps_musicmanager_png,"png");
  loadIcon(icon_applogo_small,source,x16_apps_musicmanager_png,"png");
  loadIcon(icon_cover,source,cover_png,"png");
  loadIcon(icon_equalizer,source,x16_categories_preferencesdesktop_png,"png");

  FXASSERT(icon_copy);
  FXASSERT(icon_cut);
  FXASSERT(icon_paste);
  FXASSERT(icon_delete);
  FXASSERT(icon_undo);
  FXASSERT(icon_sort);
  FXASSERT(icon_play);
  FXASSERT(icon_pause);
  FXASSERT(icon_next);
  FXASSERT(icon_prev);
  FXASSERT(icon_stop);
  FXASSERT(icon_import);
  FXASSERT(icon_importfile);
  FXASSERT(icon_exit);
  FXASSERT(icon_close);
  FXASSERT(icon_album);
  FXASSERT(icon_artist);
  FXASSERT(icon_genre);
  FXASSERT(icon_export);
  FXASSERT(icon_source_library);
  FXASSERT(icon_playlist);
  FXASSERT(icon_source_playlist);
  FXASSERT(icon_source_internetradio);
  FXASSERT(icon_homepage);
  FXASSERT(icon_info);
  FXASSERT(icon_settings);
  FXASSERT(icon_edit);
  FXASSERT(icon_find);
  FXASSERT(icon_cover);
  FXASSERT(icon_equalizer);

  icon_copy->blend(FXApp::instance()->getBaseColor());
  icon_cut->blend(FXApp::instance()->getBaseColor());
  icon_paste->blend(FXApp::instance()->getBaseColor());

#if FOXVERSION >= FXVERSION(1,7,13)
  icon_copy->setThresholdValue(700);
  icon_cut->setThresholdValue(500);
  icon_paste->setThresholdValue(500);
  icon_find->setThresholdValue(500);
#endif

  icon_delete->blend(FXApp::instance()->getBaseColor());
  icon_undo->blend(FXApp::instance()->getBaseColor());
  icon_sort->blend(FXApp::instance()->getBaseColor());
  icon_play->blend(FXApp::instance()->getBaseColor());
  icon_pause->blend(FXApp::instance()->getBaseColor());
  icon_next->blend(FXApp::instance()->getBaseColor());
  icon_prev->blend(FXApp::instance()->getBaseColor());
  icon_stop->blend(FXApp::instance()->getBaseColor());
  icon_import->blend(FXApp::instance()->getBaseColor());
  icon_importfile->blend(FXApp::instance()->getBaseColor());
  icon_exit->blend(FXApp::instance()->getBaseColor());
  icon_close->blend(FXApp::instance()->getBaseColor());
  icon_album->blend(FXApp::instance()->getBackColor());
  icon_artist->blend(FXApp::instance()->getBackColor());
  icon_genre->blend(FXApp::instance()->getBackColor());
  icon_export->blend(FXApp::instance()->getBackColor());
  icon_homepage->blend(FXApp::instance()->getBaseColor());
  icon_info->blend(FXApp::instance()->getBaseColor());
  icon_settings->blend(FXApp::instance()->getBaseColor());
  icon_edit->blend(FXApp::instance()->getBaseColor());
  icon_find->blend(FXApp::instance()->getBaseColor());
  icon_sync->blend(FXApp::instance()->getBaseColor());

  icon_source_library->blend(FXApp::instance()->getBackColor());
  icon_source_internetradio->blend(FXApp::instance()->getBackColor());
  icon_playlist->blend(FXApp::instance()->getBaseColor());
  icon_source_playlist->blend(FXApp::instance()->getBackColor());
  icon_applogo->blend(FXRGB(255,255,255));
  icon_applogo_small->blend(FXRGB(255,255,255));
  icon_cover->blend(FXRGB(255,255,255));
  icon_equalizer->blend(FXApp::instance()->getBaseColor());


//  colorize(icon_star,FXApp::instance()->getForeColor());
//  icon_star->blend(FXApp::instance()->getBackColor());
/*
  icon_album->create();
  icon_artist->create();
  icon_genre->create();
  icon_source_library->create();
  icon_source_playlist->create();
  icon_source_internetradio->create();
  icon_cover->create();
*/
  icon_copy->create();
  icon_cut->create();
  icon_paste->create();
  icon_delete->create();
  icon_undo->create();
  icon_find->create();
  icon_sync->create();
  icon_play->create();
  icon_pause->create();
  icon_next->create();
  icon_prev->create();
  icon_stop->create();
  icon_import->create();
  icon_importfile->create();
  icon_exit->create();
  icon_close->create();
  icon_album->create();
  icon_artist->create();
  icon_genre->create();
  icon_export->create();
  icon_homepage->create();
  icon_info->create();
  icon_source_library->create();
  icon_source_internetradio->create();
  icon_settings->create();
  icon_edit->create();
  icon_sort->create();
  icon_playlist->create();
  icon_source_playlist->create();
  icon_applogo->create();
  icon_applogo_small->create();
  icon_cover->create();
  icon_equalizer->create();
  }

void GMIconTheme::updateToolbar(FXbool large) {
  FXIconSource source(FXApp::instance());

#ifdef HAVE_EXTERNAL_ICONS
  const FXString base = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-dir",DEFAULT_ICON_DIRECTORY);
  const FXString big     = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-size-big","22x22");
  const FXString small   = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-size-small","16x16");
  if (large) {
    loadIcon(icon_audio_volume_high,source,base,big,"status-audio-volume-high","status/audio-volume-high.png");
    loadIcon(icon_audio_volume_medium,source,base,big,"status-audio-volume-medium","status/audio-volume-medium.png");
    loadIcon(icon_audio_volume_low,source,base,big,"status-audio-volume-low","status/audio-volume-low.png");
    loadIcon(icon_audio_volume_muted,source,base,big,"status-audio-volume-muted","status/audio-volume-muted.png");
    loadIcon(icon_play_big,source,base,big,"actions-media-playback-start","actions/media-playback-start.png");
    loadIcon(icon_pause_big,source,base,big,"actions-media-playback-pause","actions/media-playback-pause.png");
    loadIcon(icon_next_big,source,base,big,"actions-media-skip-forward","actions/media-skip-forward.png");
    loadIcon(icon_prev_big,source,base,big,"actions-media-skip-backward","actions/media-skip-backward.png");
    loadIcon(icon_stop_big,source,base,big,"actions-media-playback-stop","actions/media-playback-stop.png");
    }
  else {
    loadIcon(icon_audio_volume_high,source,base,small,"status-audio-volume-high","status/audio-volume-high.png");
    loadIcon(icon_audio_volume_medium,source,base,small,"status-audio-volume-medium","status/audio-volume-medium.png");
    loadIcon(icon_audio_volume_low,source,base,small,"status-audio-volume-low","status/audio-volume-low.png");
    loadIcon(icon_audio_volume_muted,source,base,small,"status-audio-volume-muted","status/audio-volume-muted.png");
    }
#else /* HAVE_BUILDIN_ICONS */
  if (large) {
    loadIcon(icon_audio_volume_high,source,x22_status_audiovolumehigh_png,"png");
    loadIcon(icon_audio_volume_medium,source,x22_status_audiovolumemedium_png,"png");
    loadIcon(icon_audio_volume_low,source,x22_status_audiovolumelow_png,"png");
    loadIcon(icon_audio_volume_muted,source,x22_status_audiovolumemuted_png,"png");
    loadIcon(icon_play_big,source,x22_actions_mediaplaybackstart_png,"png");
    loadIcon(icon_pause_big,source,x22_actions_mediaplaybackpause_png,"png");
    loadIcon(icon_next_big,source,x22_actions_mediaskipforward_png,"png");
    loadIcon(icon_prev_big,source,x22_actions_mediaskipbackward_png,"png");
    loadIcon(icon_stop_big,source,x22_actions_mediaplaybackstop_png,"png");
    }
  else {
    loadIcon(icon_audio_volume_high,source,x16_status_audiovolumehigh_png,"png");
    loadIcon(icon_audio_volume_medium,source,x16_status_audiovolumemedium_png,"png");
    loadIcon(icon_audio_volume_low,source,x16_status_audiovolumelow_png,"png");
    loadIcon(icon_audio_volume_muted,source,x16_status_audiovolumemuted_png,"png");
    }
#endif

  if (large) {
    FXASSERT(icon_play_big);
    FXASSERT(icon_pause_big);
    FXASSERT(icon_next_big);
    FXASSERT(icon_prev_big);
    FXASSERT(icon_stop_big);

    icon_play_big->blend(FXApp::instance()->getBaseColor());
    icon_pause_big->blend(FXApp::instance()->getBaseColor());
    icon_next_big->blend(FXApp::instance()->getBaseColor());
    icon_prev_big->blend(FXApp::instance()->getBaseColor());
    icon_stop_big->blend(FXApp::instance()->getBaseColor());

    icon_play_big->create();
    icon_pause_big->create();
    icon_next_big->create();
    icon_prev_big->create();
    icon_stop_big->create();
    }
  icon_audio_volume_high->blend(FXApp::instance()->getBaseColor());
  icon_audio_volume_medium->blend(FXApp::instance()->getBaseColor());
  icon_audio_volume_low->blend(FXApp::instance()->getBaseColor());
  icon_audio_volume_muted->blend(FXApp::instance()->getBaseColor());
  icon_audio_volume_high->create();
  icon_audio_volume_medium->create();
  icon_audio_volume_low->create();
  icon_audio_volume_muted->create();
  }


void GMIconTheme::loadToolbar(FXbool large) {
  FXIconSource source(FXApp::instance());

  if (icon_audio_volume_high) {
    delete ((FXIcon*)icon_audio_volume_high);
    delete ((FXIcon*)icon_audio_volume_medium);
    delete ((FXIcon*)icon_audio_volume_low);
    delete ((FXIcon*)icon_audio_volume_muted);
    }

  if (!large && icon_play_big) {
    delete ((FXIcon*)icon_play_big);
    delete ((FXIcon*)icon_pause_big);
    delete ((FXIcon*)icon_next_big);
    delete ((FXIcon*)icon_prev_big);
    delete ((FXIcon*)icon_stop_big);
    icon_play_big=NULL;
    icon_pause_big=NULL;
    icon_next_big=NULL;
    icon_prev_big=NULL;
    icon_stop_big=NULL;
    }

#ifdef HAVE_EXTERNAL_ICONS
  const FXString base = FXApp::instance()->reg().readStringEntry("user-interface","icon-base-dir",DEFAULT_ICON_DIRECTORY);
  const FXString big     = FXApp::instance()->reg().readStringEntry("user-interface","icon-base-size-big","22x22");
  const FXString small   = FXApp::instance()->reg().readStringEntry("user-interface","icon-base-size-small","16x16");

  if (large) {
    loadIcon(icon_audio_volume_high,source,base,big,"status-audio-volume-high","status/audio-volume-high.png");
    loadIcon(icon_audio_volume_medium,source,base,big,"status-audio-volume-medium","status/audio-volume-medium.png");
    loadIcon(icon_audio_volume_low,source,base,big,"status-audio-volume-low","status/audio-volume-low.png");
    loadIcon(icon_audio_volume_muted,source,base,big,"status-audio-volume-muted","status/audio-volume-muted.png");
    loadIcon(icon_play_big,source,base,big,"actions-media-playback-start","actions/media-playback-start.png");
    loadIcon(icon_pause_big,source,base,big,"actions-media-playback-pause","actions/media-playback-pause.png");
    loadIcon(icon_next_big,source,base,big,"actions-media-skip-forward","actions/media-skip-forward.png");
    loadIcon(icon_prev_big,source,base,big,"actions-media-skip-backward","actions/media-skip-backward.png");
    loadIcon(icon_stop_big,source,base,big,"actions-media-playback-stop","actions/media-playback-stop.png");
    }
  else {
    loadIcon(icon_audio_volume_high,source,base,small,"status-audio-volume-high","status/audio-volume-high.png");
    loadIcon(icon_audio_volume_medium,source,base,small,"status-audio-volume-medium","status/audio-volume-medium.png");
    loadIcon(icon_audio_volume_low,source,base,small,"status-audio-volume-low","status/audio-volume-low.png");
    loadIcon(icon_audio_volume_muted,source,base,small,"status-audio-volume-muted","status/audio-volume-muted.png");
    }
#else /* HAVE_BUILDIN_ICONS */

  if (large) {
    icon_audio_volume_high   = source.loadIconData(x22_status_audiovolumehigh_png,"png");
    icon_audio_volume_medium = source.loadIconData(x22_status_audiovolumemedium_png,"png");
    icon_audio_volume_low    = source.loadIconData(x22_status_audiovolumelow_png,"png");
    icon_audio_volume_muted  = source.loadIconData(x22_status_audiovolumemuted_png,"png");
    icon_play_big            = source.loadIconData(x22_actions_mediaplaybackstart_png,"png");
    icon_pause_big           = source.loadIconData(x22_actions_mediaplaybackpause_png,"png");
    icon_next_big            = source.loadIconData(x22_actions_mediaskipforward_png,"png");
    icon_prev_big            = source.loadIconData(x22_actions_mediaskipbackward_png,"png");
    icon_stop_big            = source.loadIconData(x22_actions_mediaplaybackstop_png,"png");
    }
  else {
    icon_audio_volume_high   = source.loadIconData(x16_status_audiovolumehigh_png,"png");
    icon_audio_volume_medium = source.loadIconData(x16_status_audiovolumemedium_png,"png");
    icon_audio_volume_low    = source.loadIconData(x16_status_audiovolumelow_png,"png");
    icon_audio_volume_muted  = source.loadIconData(x16_status_audiovolumemuted_png,"png");
    }

#endif

  FXASSERT(icon_audio_volume_high);
  FXASSERT(icon_audio_volume_medium);
  FXASSERT(icon_audio_volume_low);
  FXASSERT(icon_audio_volume_muted);

  if (large) {
    FXASSERT(icon_play_big);
    FXASSERT(icon_pause_big);
    FXASSERT(icon_next_big);
    FXASSERT(icon_prev_big);
    FXASSERT(icon_stop_big);

    icon_play_big->blend(FXApp::instance()->getBaseColor());
    icon_pause_big->blend(FXApp::instance()->getBaseColor());
    icon_next_big->blend(FXApp::instance()->getBaseColor());
    icon_prev_big->blend(FXApp::instance()->getBaseColor());
    icon_stop_big->blend(FXApp::instance()->getBaseColor());

    icon_play_big->create();
    icon_pause_big->create();
    icon_next_big->create();
    icon_prev_big->create();
    icon_stop_big->create();
    }

  icon_audio_volume_high->blend(FXApp::instance()->getBaseColor());
  icon_audio_volume_medium->blend(FXApp::instance()->getBaseColor());
  icon_audio_volume_low->blend(FXApp::instance()->getBaseColor());
  icon_audio_volume_muted->blend(FXApp::instance()->getBaseColor());
  icon_audio_volume_high->create();
  icon_audio_volume_medium->create();
  icon_audio_volume_low->create();
  icon_audio_volume_muted->create();
  }

void GMIconTheme::loadAbout() {
  FXIconSource source(FXApp::instance());
  if (icon_about==NULL) {
    icon_about = source.loadIconData(about_png,"png");
    icon_about->blend(FXRGB(255,255,255));
    }
  }





void GMIconTheme::loadChain() {
  FXIconSource source(FXApp::instance());
  if (icon_chain==NULL) {
    icon_chain        = source.loadIconData(x24_actions_chain_png,"png");
    icon_chain_broken = source.loadIconData(x24_actions_chainbroken_png,"png");

    FXColor color = FXApp::instance()->getBaseColor();
    FXfloat luminance = (((FXREDVAL(color)*0.3f)+(FXGREENVAL(color)*0.59f)+(FXBLUEVAL(color)*0.11f))/256.0f);
    if (luminance<=0.5f){
      invert(icon_chain);
      invert(icon_chain_broken);
      }
    icon_chain->blend(FXApp::instance()->getBackColor());
    icon_chain_broken->blend(FXApp::instance()->getBackColor());
    }
  }

void GMIconTheme::freeChain() {
  delete icon_chain;
  delete icon_chain_broken;
  icon_chain=NULL;
  icon_chain_broken=NULL;
  }

void GMIconTheme::loadFileAssociations(FXFileDict * filedict) {
  FXFileAssoc * assoc;
  FXIconSource  source(FXApp::instance());

#ifdef HAVE_EXTERNAL_ICONS
  const FXString base    = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-dir",DEFAULT_ICON_DIRECTORY);
  const FXString big     = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-size-big","22x22");
  const FXString small   = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-size-small","16x16");

  FXApp::instance()->reg().writeStringEntry("user-icons","icon-base-dir",base.text());
  FXApp::instance()->reg().writeStringEntry("user-icons","icon-base-size-big",big.text());
  FXApp::instance()->reg().writeStringEntry("user-icons","icon-base-size-small",small.text());

  loadIcon(icon_file_small,source,base,small,"mimetypes-text-x-generic","mimetypes/text-x-generic.png");
  loadIcon(icon_file_big,source,base,big,"mimetypes-text-x-generic","mimetypes/text-x-generic.png");
  loadIcon(icon_audio_small,source,base,small,"mimetypes-audio-x-generic","mimetypes/audio-x-generic.png");
  loadIcon(icon_audio_big,source,base,big,"mimetypes-audio-x-generic","mimetypes/audio-x-generic.png");
  loadIcon(icon_folder_small,source,base,small,"places-folder","places/folder.png");
  loadIcon(icon_folder_big,source,base,big,"places-folder","places/folder.png");
#else
  icon_file_small   = source.loadIconData(x16_mimetypes_textxgeneric_png,"png");
  icon_file_big     = source.loadIconData(x22_mimetypes_textxgeneric_png,"png");
  icon_audio_small  = source.loadIconData(x16_mimetypes_audioxgeneric_png,"png");
  icon_audio_big    = source.loadIconData(x22_mimetypes_audioxgeneric_png,"png");
  icon_folder_small = source.loadIconData(x16_places_folder_png,"png");
  icon_folder_big   = source.loadIconData(x22_places_folder_png,"png");
#endif
  FXASSERT(icon_file_small);
  FXASSERT(icon_file_big);
  FXASSERT(icon_audio_small);
  FXASSERT(icon_audio_big);
  FXASSERT(icon_folder_small);
  FXASSERT(icon_folder_big);

  icon_file_small->blend(FXApp::instance()->getBackColor());
  icon_file_big->blend(FXApp::instance()->getBackColor());
  icon_audio_small->blend(FXApp::instance()->getBackColor());
  icon_audio_big->blend(FXApp::instance()->getBackColor());
  icon_folder_small->blend(FXApp::instance()->getBackColor());
  icon_folder_big->blend(FXApp::instance()->getBackColor());

  icon_file_small->create();
  icon_file_big->create();
  icon_audio_small->create();
  icon_audio_big->create();
  icon_folder_small->create();
  icon_folder_big->create();

  assoc = filedict->replace("mp3",";MPEG-1 Audio Layer 3");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("MP3",";MPEG-1 Audio Layer 3");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("ogg",";Ogg Vorbis");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("OGG",";Ogg Vorbis");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("flac",";Free Lossless Audio Codec");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("FLAC",";Free Lossless Audio Codec");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("flac",";Free Lossless Audio Codec");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("mpc",";Musepack");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

#ifndef DISABLE_ASF_SUPPORT
  assoc = filedict->replace("wma",";Windows Media");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("asf",";Windows Media");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;
#endif

#ifndef DISABLE_MP4_SUPPORT
  assoc = filedict->replace("m4a",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("m4b",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("mp4",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("m4p",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("aac",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("M4A",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("M4B",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("MP4",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("M4P",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;

  assoc = filedict->replace("AAC",";MPEG-4 Part 14");
  assoc->bigicon  = icon_audio_big;
  assoc->miniicon = icon_audio_small;
#endif

  assoc = filedict->replace(FXFileDict::defaultFileBinding,";");
  assoc->bigicon  = icon_file_big;
  assoc->miniicon = icon_file_small;

  assoc = filedict->replace(FXFileDict::defaultDirBinding,";");
  assoc->bigicon      = icon_folder_big;
  assoc->miniicon     = icon_folder_small;
  }


void GMIconTheme::freeFileAssociations() {
  icon_file_small.reset();
  icon_file_big.reset();
  icon_audio_small.reset();
  icon_audio_big.reset();
  icon_folder_small.reset();
  icon_folder_big.reset();
  }


void GMIconTheme::loadDirAssociations(FXFileDict * filedict) {
  FXFileAssoc * assoc;
  FXIconSource source(FXApp::instance());
#ifdef HAVE_EXTERNAL_ICONS
  const FXString base    = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-dir",DEFAULT_ICON_DIRECTORY);
  const FXString big     = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-size-big","22x22");
  const FXString small   = FXApp::instance()->reg().readStringEntry("user-icons","icon-base-size-small","16x16");

  FXApp::instance()->reg().writeStringEntry("user-icons","icon-base-dir",base.text());
  FXApp::instance()->reg().writeStringEntry("user-icons","icon-base-size-small",small.text());

  loadIcon(icon_folder,source,base,small,"places-folder","places/folder.png");
  loadIcon(icon_folderopen,source,base,small,"status-folder-open","status/folder-open.png");
#else
  icon_folder     = source.loadIconData(x16_places_folder_png,"png");
  icon_folderopen = source.loadIconData(x16_status_folderopen_png,"png");
#endif
  FXASSERT(icon_folder);
  FXASSERT(icon_folderopen);

  icon_folder->blend(FXApp::instance()->getBackColor());
  icon_folderopen->blend(FXApp::instance()->getBackColor());

  assoc = filedict->replace(FXFileDict::defaultDirBinding,";");
  assoc->miniiconopen = icon_folderopen;
  assoc->miniicon     = icon_folder;
  }

void GMIconTheme::freeDirAssociations() {
  icon_folder.reset();
  icon_folderopen.reset();
  }



