/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2009 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#include "common.h"
#include "GMList.h"
#include "GMSource.h"
#include "GMPlayerManager.h"
#include "version.h"

static bool displayHelp(int argc,char * argv[]);

int main(int argc,char *argv[]){   

  /// Check and make sure we're linked correctly to FOX
  /// If we're not linked correctly, we cannot obviously popup a dialog...
  if (fxversion[0]==1 && (fxversion[1]==6) ) { /// Test for Stable Version of FOX 1.6
    if (FOX_MAJOR!=fxversion[0] || FOX_MINOR!=fxversion[1]){
      fxwarning("FOX Header (v%d.%d.%d) / Library (v%d.%d.%d) mismatch!  -\n",FOX_MAJOR,FOX_MINOR,FOX_LEVEL,fxversion[0],fxversion[1],fxversion[2]);
      return 1;
      }
    }
  else if (fxversion[0]==1 && ( fxversion[1]==7)) { /// Test for Development version of FOX 1.7
    if (FOX_MAJOR!=fxversion[0] || FOX_MINOR!=fxversion[1] || FOX_LEVEL!=fxversion[2]) {
      fxwarning("FOX Header (v%d.%d.%d) / Library (v%d.%d.%d) mismatch!  -\n",FOX_MAJOR,FOX_MINOR,FOX_LEVEL,fxversion[0],fxversion[1],fxversion[2]);
      return 1;
      }
    }
  else {
    fxwarning("Goggles Music Manager linked to a unknown/unsupported version of the FOX Library (v%d.%d.%d)",fxversion[0],fxversion[1],fxversion[2]);
    return 1;
    }

  /// Display Help
  if (displayHelp(argc,argv))
    return 0;

  /// Main Application
  GMPlayerManager gogglesmm;
  return gogglesmm.run(argc,argv);
  }



/*
  Display Help/Version
  returns true if application may exit
  TODO expand to all possible options
*/
static bool displayHelp(int argc,char * argv[]) {
  FXbool showhelp=false;
  FXbool showversion=false;

  for (int i=1;i<argc;i++){
    if ( (comparecase(argv[i],"--help")==0) || (comparecase(argv[i],"-h")==0) ) {
      showhelp=true;
      break;
      }
    else if ( (comparecase(argv[i],"--version")==0) || (comparecase(argv[i],"-v")==0) ) {
      showversion=true;
      break;
      }
    }
  if (!showhelp && !showversion) return false;

  if (showversion) {
    fxmessage("Goggles Music Manager %d.%d.%d\n",APPLICATION_MAJOR,APPLICATION_MINOR,APPLICATION_LEVEL);
    }
  else if (showhelp) {
    if (argc>0)
      fxmessage("Usage: %s [options]\n\n",FXPath::name(argv[0]).text());
    else
      fxmessage("Usage: gmm [options]\n\n");

    fxmessage("General options:\n"
              " -h, --help         Display this help page\n"
              " -v, --version      Display version information\n"
              "\n"
              "Control running music manager:\n"
              "     --play         Start playback\n"
              "     --play-pause   Toggle pause / playback.\n"
              "     --pause        Pause playback\n"
              "     --previous     Play previous track\n"
              "     --next         Play next track\n"
              "     --stop         Stop playback\n"
              "     --raise        Try to raise the main window\n"
              "     --toggle-shown Show or Hide the main window\n"
              "\n"
              "Debugging options:\n"
              "     --xine-debug   Output xine debug info\n"
              );
    }
  return true;
  }




