# Copyright (C) 2009 Jason Scheunemann <jason.scheunemann@yahoo.com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# 
# This is a quick 'n dirty modified version for VLC 1.1.4 using the new vlc.py
# this allows you to run the embedded version
# note that "show controls" and "fullscreen" doesn't work with the embedded vlc
# if you need these features, Edit > Preferences > [x] Use External Player > Command: vlc
#
#
#
# VLC 1.1.4 FIX INSTRUCTIONS:
#
# this works on my pc: 
# 	sopcast-player 0.4.0, sp-auth 3.6, vlc 1.1.4 (ppa:ferramroberto/vlc)
# 	ubuntu 10.04.01 32bit, kernel 2.6.35-21-generic (ppa:kernel-ppa/ppa)
#
# installation: replace VLCWidget.py and vlc.py in /usr/share/sopcast-player/lib
#               with the new ones. (as root)
#
#								if sopcast-player still doesn't run, try
#								'sudo aptitude reinstall sopcast-player' and replace files again.
# 
# thanks to jason!!!
#
# have fun!
# -mike


import gtk
import sys
import vlc

from gettext import gettext as _

instance=vlc.Instance()

class VLCWidget(gtk.DrawingArea):
	def __init__(self, *p):
		gtk.DrawingArea.__init__(self)
		# old : instance.mediacontrol_new_from_instance()
		self.player=instance.media_player_new()		
		def handle_embed(*args):
			if sys.platform == 'win32':
				self.player.set_hwnd(self.window.handle)
			else:
				self.player.set_xwindow(self.window.xid)
			return True
		self.connect("map-event", handle_embed)
		self.set_size_request(320, 200)
        
	def set_media_url(self, url):
		self.player.set_mrl(url)		
		
	def play_media(self):
		self.realize()		
		self.player.set_xwindow(self.window.xid)		
		self.player.play()
		
	def resume_media(self):
		self.player.resume()
		
	def stop_media(self):
		self.player.stop()
		
	def pause_media(self):
		self.player.pause()
		
	def exit_media(self):
		#self.player.exit()
		self.player.release()
		
	def display_text(self, text):
		# not working, printing to console
		print text;
		
		
	def is_fullscreen(self):
		if self.player.get_fullscreen() == 1:
			return True
		else:
			return False
		
	def fullscreen(self):
		print "not possible: With most window managers, only a top-level windows can be in full-screen mode. Hence, this function will not operate properly if libvlc_media_player_set_xid() was used to embed the video in a non-top-level window. In that case, the embedding window must be reparented to the root window <b>before</b> fullscreen mode is enabled."
		# set xwnd to top-level - here -	
		self.player.set_fullscreen(True)

	def set_volume(self, level):	  
		self.player.audio_set_volume(level)
		
	def screenshot(self):
		return self.player.snapshot(0)

