#include <KXmlGuiWindow>
#include <KPushButton>
#include <KListWidget>
#include <KAction>
#include <KStatusBar>
#include <QCheckBox>
#include <QThread>
#include <QTreeWidget>
#include <QLabel>
#include <QSplitter>
#include <errno.h>
#include <dirent.h>
#include <poll.h>
#include <sys/inotify.h>
#include <sys/stat.h>
#include <fcntl.h>


#define BUFFERSIZE          2048    // inbuffer for inotify
#define POLL_TIMEOUT        1000    // poll interval
#define MAX_ITEMS           8192    // max items in events list


// enumerates event checkboxes
enum{eWrite,eCreate,eDel,eRen,eAttr,eOpen,eRead,eRecursive,eCount};

// inotify mask for each checkboxes above
// IN_ONESHOT is estranged as recursive flag
#define IN_RECURSIVE    IN_ONESHOT
const int event_mask[] = {IN_MODIFY,IN_CREATE,IN_DELETE|IN_DELETE_SELF,
                          IN_MOVED_FROM|IN_MOVED_TO|IN_MOVE_SELF,IN_ATTRIB,IN_OPEN|IN_CLOSE,IN_ACCESS,
                          IN_RECURSIVE };

// enumerates statusbar fields
enum{eMode,eItems,eInotify,eStatusLast};

enum{redLED,yellowLED,greenLED,countLED};


using namespace std;


// ---------------------------------------------------------------------------------------

// Used by cWatchDir
typedef struct {
    int cookie;         // from inotify
    char file[1];
} watchEntry;


class myTreeWidget;
class MainWindow;


// A thread for a file or directoty to watch
class cWatchDir : public QThread
{
    Q_OBJECT
private:
    int fd;
    unsigned wmask, user_mask;
    bool bStop, bRecursive, bEnabled;
    char *watchedFile;
    unsigned char buffer[BUFFERSIZE];
    QList<watchEntry*> dirlist;
    int addWatch(const char *name);
    int addDir(const char *name);
    int addfile(const char *file);
    void deleteWatches();
    void errorBox(int error_nb);
signals:
    void eventWatch(const char* file, int);
    void error(const char* path, int code); // lets the main thread show a errorbox
protected:
    void run();
public:
    cWatchDir(QString path, int mask, bool enabled);
    ~cWatchDir();
    void save(KConfigGroup &settings, int k);
    void stop()                     { bStop = true; }
    void setMask(int mask);
    int  getMask()                  { return user_mask; }
    char *getWatchedFile()          { return watchedFile; }
    void setEnabled(bool,bool);
    int  getWatchesCount()          { return dirlist.size(); }
};

// ---------------------------------------------------------------------------------------


// Shows the event list on top of the mainwindow
class myTreeWidget : public QTreeWidget
{
    Q_OBJECT
    QIcon icons[countLED];
    QString *filter;
public:
    myTreeWidget(QWidget *parent);
    void filterList(QString&);
    void showAll();
    int  getItemsCount();           // Returns number of visible items
public slots:
    void addEvent(const char*,int);
    void saveFiles();
};


class MainWindow : public KXmlGuiWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent=0);
    void saveSettings();
private:
    QList<cWatchDir*> watches;
    QTimer *timer;
    myTreeWidget *filelist;
    KListWidget *lsDir;
    KAction *aSort, *aAlternate, *aFilter, *aUndo, *aDel, *aStartStop;
    KIcon *iStart, *iStop;
    QString fileFilter;
    bool bStop, bFilter;
    int max_user_watches;
    char *undo_WatchedFile;
    int  undo_mask;
    QCheckBox *ckEvents[eCount];
    QSplitter *splitter;
    QLabel* statusWidget[eStatusLast];
    KStatusBar *status;
    void AddFile(bool bDir);
    int  buildMask();
    void addNewWatch(const QString& dir, int flags, bool enabled);
    void updateEventPanel(int);
    void updateStatusBar(int field);
protected:
    void closeEvent(QCloseEvent *event);
private slots:
    void EventBoxClicked();
    void AddDir();
    void AddFile();
    void DirSelChanged();
    void DelDirFile();
    void Undo();
    void Start();
    void sorted();
    void clearList();
    void altColors();
    void EnterFileFilter();
    void DirlistClicked(QListWidgetItem *item);
    void updateStatusBar();
    void errorBox(const char* path, int code);
};
