//
// C++ Implementation: customcommandseditor
//
// Description:
//
//
// Author: root <root@carrouf-G1>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "customcommandseditor.h"
#include <QtGui>

CustomCommandsEditor::CustomCommandsEditor(QWidget * parent, Qt::WFlags f, QString fileName, int fileType) : QDialog(parent, f)
{
	setModal(true);
	setWindowTitle(tr("Edit customized list"));
	setWindowIcon(QIcon(":images/klipper_dock.png"));
	setMinimumWidth(440);
	setMinimumHeight(380);
	
	QPushButton *pbRowUp = new QPushButton();
	QPushButton *pbRowDown = new QPushButton();
	QPushButton *pbDeleteRow = new QPushButton();
	QPushButton *pbInsertRow = new QPushButton();
	QPushButton *cancelButton = new QPushButton(tr("Cancel"));
	okButton = new QPushButton(tr("Save"));
	okButton->setDefault(true);
	okButton->setDisabled(true);
	okButton->setIcon(QIcon(":images/dialog-ok-apply.png"));
	cancelButton->setIcon(QIcon(":images/dialog-cancel.png"));
	pbRowUp->setIcon(QIcon(":images/up.png"));
	pbRowDown->setIcon(QIcon(":images/down.png"));
	pbDeleteRow->setIcon(QIcon(":images/edit_remove.png"));
	pbInsertRow->setIcon(QIcon(":images/edit_add.png"));
	pbRowUp->setToolTip(trUtf8("row up"));
	pbRowDown->setToolTip(trUtf8("row down"));
	pbDeleteRow->setToolTip(trUtf8("delete row"));
	pbInsertRow->setToolTip(trUtf8("insert row"));
	
	buttonBoxEdit = new QDialogButtonBox();//buttonBoxEdit = new QDialogButtonBox( QDialogButtonBox::Ok | QDialogButtonBox::Cancel );
	buttonBoxEdit->addButton(okButton,QDialogButtonBox::AcceptRole);
	buttonBoxEdit->addButton(cancelButton,QDialogButtonBox::RejectRole);
	
	QStringList strList;
	
	switch (fileType)
	{
		case 0:
			strList << tr("Command") << tr("Description");
			break;
		case 1:
			strList << tr("File location")<< tr("Description");
			break;
		case 2:
			strList << tr("Input Request mode") << tr("Description") << tr("Command");
			break;
		case 3:
			strList << tr("Sticky clipboard entry");
			break;
	}
	
	tableWidget = new QTableWidget(this);
	tableWidget->setRowCount(30);
	tableWidget->setColumnCount(strList.size());
	tableWidget->setHorizontalHeaderLabels(strList);
	
	QHBoxLayout *layoutH = new QHBoxLayout;
	layoutH->addWidget( pbRowUp );
	layoutH->addWidget( pbRowDown );
	layoutH->addWidget( pbDeleteRow );
	layoutH->addWidget( pbInsertRow );
	layoutH->addStretch();
	
	QVBoxLayout *layoutV = new QVBoxLayout(this);
	layoutV->addLayout(layoutH);
	layoutV->addWidget( tableWidget );//layoutV->addStretch();
	layoutV->addWidget( buttonBoxEdit );
	
	targetFileName = fileName;
	QFile file (targetFileName);

	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		int row = 0;
		int column = 0;
		QStringList lineContent;
		QTableWidgetItem *twItem1;
		QTextStream in(&file);
		while (!in.atEnd())
		{
			QString line = in.readLine();
			twItem1 = new QTableWidgetItem(QString(line).trimmed());
			tableWidget->setItem(row, column, twItem1);
			++row;
			/*
			if (!line.startsWith("#"))
			{
				lineContent = QString(line).split(";");
				
				for (column = 0 ; column < lineContent.size() ; column++)
				{
					twItem1 = new QTableWidgetItem(lineContent.at(column).trimmed());
					tableWidget->setItem(row, column, twItem1);
				}

				++row;
			}
			*/
		}
		file.close();
		
		tableWidget->resizeColumnsToContents();
		tableWidget->resizeRowsToContents();
		//setMinimumWidth(tableWidget->width());
	}
	
	connect(tableWidget, SIGNAL(itemChanged(QTableWidgetItem *)), this, SLOT(tableChanged()));
	connect(pbRowUp, SIGNAL(clicked()), this, SLOT(rowUp()));
	connect(pbRowDown, SIGNAL(clicked()), this, SLOT(rowDown()));
	connect(pbDeleteRow, SIGNAL(clicked()), this, SLOT(rowDelete()));
	connect(pbInsertRow, SIGNAL(clicked()), this, SLOT(rowInsert()));
	connect(buttonBoxEdit, SIGNAL(accepted()), this, SLOT(saveForm()));
	connect(buttonBoxEdit, SIGNAL(rejected()), this, SLOT(rejectForm()));
	//connect(buttonBoxEdit, SIGNAL(rejected()), this, SLOT(reject()));
	//connect(buttonBoxEdit, SIGNAL(accepted()), this, SLOT(accept()));
	
	tableHasBeenEdited = false;
}

void CustomCommandsEditor::tableChanged()
{
	if (!tableHasBeenEdited)
	{
		okButton->setDisabled(false);
		tableHasBeenEdited = true;
	}
}

void CustomCommandsEditor::rejectForm()
{
	if (tableHasBeenEdited)
	{
		switch (
				QMessageBox::question(
									this,
										tr("Confirm exit"),
										tr("Settings have been modified. Really quit ?"),
										tr("&Discard"), tr("&Cancel"),
										0, 1
									)
			)
		{
			case 1:
				return;
		}
	}
	reject();
}

void CustomCommandsEditor::saveForm()
{
	QFile file (targetFileName);
	
	if (!file.open(QFile::WriteOnly | QFile::Text))
	{
		QMessageBox::warning(
							this,
							tr("Application"),
							tr("Cannot write file '%1'.").arg(targetFileName)
							);
		return;
	}
	
	QStringList mapLine;
	QTextStream in(&file);
	
	for (int i=0 ; i < tableWidget->rowCount() ; i++)
	{
		mapLine.clear();
		
		for (int j=0 ; j < tableWidget->columnCount() ; j++)
		{
			if (tableWidget->item(i,j))
			{
				if (tableWidget->item(i,j)->text().trimmed().length() > 0)
					mapLine << tableWidget->item(i,j)->text().trimmed();
			}
		}
		//if (tableWidget->item(i,0) && tableWidget->item(i,1))
		//{
			//if (tableWidget->item(i,0)->text().trimmed().length() > 0 && tableWidget->item(i,1)->text().trimmed().length() > 0)
			if (mapLine.size() == tableWidget->columnCount())
			{
				for (int j=0 ; j < tableWidget->columnCount() ; j++)
				{
					in << mapLine.at(j);
					//if (j < tableWidget->columnCount())
						//in << ";";
				}
				in << endl;
// 				in << tableWidget->item(i,0)->text().trimmed() + ";";//mapLine << tableWidget->item(i,0)->text();
// 				in << tableWidget->item(i,1)->text().trimmed(); //mapLine << tableWidget->item(i,1)->text();
// 				in << endl;//qDebug() << qPrintable(fileBits.at(i)) << endl;
			}
		//}
	}
	
	file.close();
	accept();
}

void CustomCommandsEditor::rowUp()
{
	//QString str;
	//qDebug(qPrintable(str.setNum(tableWidget->currentRow())));
	tableWidget->selectRow(tableWidget->currentRow());
	if ((tableWidget->currentRow())>0)//if ((tableWidget->currentRow()-1)>=0)
	{
		rowMove(-1);
		tableWidget->selectRow(tableWidget->currentRow()-1);
		if (!tableHasBeenEdited)
			tableChanged();
	}
}

void CustomCommandsEditor::rowDown()
{
	tableWidget->selectRow(tableWidget->currentRow());
	rowMove(1);
	tableWidget->selectRow(tableWidget->currentRow()+1);
	if (!tableHasBeenEdited)
		tableChanged();
}

void CustomCommandsEditor::rowInsert()
{
	tableWidget->insertRow(tableWidget->currentRow());
	if (!tableHasBeenEdited)
		tableChanged();
}

void CustomCommandsEditor::rowDelete()
{
	tableWidget->removeRow(tableWidget->currentRow());
	if (!tableHasBeenEdited)
		tableChanged();
}

void CustomCommandsEditor::rowMove(int direction)
{
	const int sourceRow = tableWidget->row(tableWidget->selectedItems().at(0));
	//const int destRow = (up ? sourceRow-1 : sourceRow+1);
	const int destRow = (sourceRow+direction);

	 // take whole rows
	QList<QTableWidgetItem*> sourceItems = takeRow(sourceRow);
	QList<QTableWidgetItem*> destItems = takeRow(destRow);
 
    // set back in reverse order
	setRow(sourceRow, destItems);
	setRow(destRow, sourceItems);
	//tableWidget->removeRow(tableWidget->currentRow());
}

// takes and returns the whole row
QList<QTableWidgetItem*> CustomCommandsEditor::takeRow(int row)
{
	QList<QTableWidgetItem*> rowItems;
	for (int col = 0; col < tableWidget->columnCount(); ++col)
	{
		rowItems << tableWidget->takeItem(row, col);
	}
	return rowItems;
}
 
// sets the whole row
void CustomCommandsEditor::setRow(int row, const QList<QTableWidgetItem*>& rowItems)
{
	for (int col = 0; col < tableWidget->columnCount() ; ++col)
	{
		tableWidget->setItem(row, col, rowItems.at(col));
	}
}

// CustomCommandsEditor::~CustomCommandsEditor()
// {
// }


