#include <QtGui/QApplication>
#include <QTranslator>
#include <QLocale>

#include "systrayicon.h"
#include "SettingsInfo.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    a.setApplicationName("qlipper");
    a.setApplicationVersion("1.7");
    a.setOrganizationDomain("qlipper.org");
    a.setOrganizationName("Qlipper");

	QString transfilename = a.applicationName() + "_" +  QLocale::system().name();
	QStringList translocations;
	//translocations.append( a.applicationDirPath() + "/ts/" + transfilename );
	translocations.append( a.applicationDirPath() + "/" + transfilename );
	translocations.append( SettingsInfo::configDir() + "/" + transfilename );
	translocations.append( "/usr/share/" + a.applicationName() + "/translations/" + transfilename );
	translocations.append( "/usr/local/share/" + a.applicationName() + "/translations/" + transfilename );
	QTranslator translator;

	foreach (QString transfile, translocations)
	{
	  if (translator.load(transfile))
	  {
		a.installTranslator(&translator);
		break;
	  }
	}

    SystrayIcon w;
    w.show();
    a.setQuitOnLastWindowClosed(false);
    return a.exec();
}
