#ifndef SYSTRAYICON_H
#define SYSTRAYICON_H

#include <QSystemTrayIcon>
#include <QQueue>
#include <QMimeData>
#include <QFocusEvent>

class QAction;
class QSystemTrayIcon;
class QMimeData;


//class SystrayIcon : public QMainWindow
class SystrayIcon : public QSystemTrayIcon
{
    Q_OBJECT

public:
    SystrayIcon( QObject * parent = 0 );//SystrayIcon(QWidget *parent = 0);
    ~SystrayIcon();

protected:
  //  void focusOutEvent( QFocusEvent* );
  //void keyPressEvent(QKeyEvent *event);
  //bool eventFilter(QObject *obj, QEvent *ev);

private slots:
    void initSystrayMenu();
    void clipTextClicked(int);
    void stickyTextClicked(int);
    void systrayClicked(QSystemTrayIcon::ActivationReason);
    void showAbout();
    void showPrefsDialog();
    void clipSelectionChanged();
	void clearClipboardHistory();
	void updateClipboardMenu();
	void updateStickyMenu();//void clipboardIconMenuActionHovered(QAction *);
	void showStickyDialog();

private:
    QString getDisplayText(QString);
    void saveSettings();

    QQueue<QString> queue;//QQueue<QMimeData*> queue;
    QStringList stickyList;
    QMenu *trayIconMenu;
    QMenu *stickyMenu;
    QMenu *clipboardIconMenu;
    QAction *quitAction;
    QAction *configureAction;
    QAction *aboutAction;
    QAction *clearAction;
    QAction *editStickyEntriesAction;

    QString history_file_name;
	QString sticky_file_name;
	QString latest_clipboard_image_name;
	QString tag_image;
	QString tag_separator;
	QString systray_tooltip;
    int history_max_size;
    int entry_display_max_size;
    bool clipboard_history_save;
    bool ignore_selection;
    bool ignore_images;
	bool activate_sticky;
};

#endif // SYSTRAYICON_H
