# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.40
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.
# This file is compatible with both classic and new-style classes.

"""

Loris is an Open Source sound modeling and processing software package
based on the Reassigned Bandwidth-Enhanced Additive Sound Model. Loris
supports modified resynthesis and manipulations of the model data,
such as time- and frequency-scale modification and sound morphing.


Loris is developed by Kelly Fitz and Lippold Haken at the CERL Sound
Group, and is distributed under the GNU General Public License (GPL).
For more information, please visit

   http://www.cerlsoundgroup.org/Loris/

"""

from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_loris', [dirname(__file__)])
        except ImportError:
            import _loris
            return _loris
        if fp is not None:
            try:
                _mod = imp.load_module('_loris', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _loris = swig_import_helper()
    del swig_import_helper
else:
    import _loris
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _loris.SwigPyIterator_value(self)
    def incr(self, n = 1): return _loris.SwigPyIterator_incr(self, n)
    def decr(self, n = 1): return _loris.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _loris.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _loris.SwigPyIterator_equal(self, *args)
    def copy(self): return _loris.SwigPyIterator_copy(self)
    def next(self): return _loris.SwigPyIterator_next(self)
    def __next__(self): return _loris.SwigPyIterator___next__(self)
    def previous(self): return _loris.SwigPyIterator_previous(self)
    def advance(self, *args): return _loris.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _loris.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _loris.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _loris.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _loris.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _loris.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _loris.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _loris.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

class DoubleVector(_object):
    """Proxy of C++ std::vector<(double)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DoubleVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DoubleVector, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _loris.DoubleVector_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _loris.DoubleVector___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _loris.DoubleVector___bool__(self)

    def __len__(self):
        """__len__(self) -> size_type"""
        return _loris.DoubleVector___len__(self)

    def pop(self):
        """pop(self) -> value_type"""
        return _loris.DoubleVector_pop(self)

    def __getslice__(self, *args):
        """__getslice__(self, i, j) -> DoubleVector"""
        return _loris.DoubleVector___getslice__(self, *args)

    def __setslice__(self, *args):
        """__setslice__(self, i, j, v)"""
        return _loris.DoubleVector___setslice__(self, *args)

    def __delslice__(self, *args):
        """__delslice__(self, i, j)"""
        return _loris.DoubleVector___delslice__(self, *args)

    def __delitem__(self, *args):
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _loris.DoubleVector___delitem__(self, *args)

    def __getitem__(self, *args):
        """
        __getitem__(self, slice) -> DoubleVector
        __getitem__(self, i) -> value_type
        """
        return _loris.DoubleVector___getitem__(self, *args)

    def __setitem__(self, *args):
        """
        __setitem__(self, slice, v)
        __setitem__(self, i, x)
        """
        return _loris.DoubleVector___setitem__(self, *args)

    def append(self, *args):
        """append(self, x)"""
        return _loris.DoubleVector_append(self, *args)

    def empty(self):
        """empty(self) -> bool"""
        return _loris.DoubleVector_empty(self)

    def size(self):
        """size(self) -> size_type"""
        return _loris.DoubleVector_size(self)

    def clear(self):
        """clear(self)"""
        return _loris.DoubleVector_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _loris.DoubleVector_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> allocator_type"""
        return _loris.DoubleVector_get_allocator(self)

    def begin(self):
        """begin(self) -> const_iterator"""
        return _loris.DoubleVector_begin(self)

    def end(self):
        """end(self) -> const_iterator"""
        return _loris.DoubleVector_end(self)

    def rbegin(self):
        """rbegin(self) -> const_reverse_iterator"""
        return _loris.DoubleVector_rbegin(self)

    def rend(self):
        """rend(self) -> const_reverse_iterator"""
        return _loris.DoubleVector_rend(self)

    def pop_back(self):
        """pop_back(self)"""
        return _loris.DoubleVector_pop_back(self)

    def erase(self, *args):
        """
        erase(self, pos) -> iterator
        erase(self, first, last) -> iterator
        """
        return _loris.DoubleVector_erase(self, *args)

    def __init__(self, *args): 
        """
        __init__(self) -> DoubleVector
        __init__(self, arg0) -> DoubleVector
        __init__(self, size) -> DoubleVector
        __init__(self, size, value) -> DoubleVector
        """
        this = _loris.new_DoubleVector(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(self, *args):
        """push_back(self, x)"""
        return _loris.DoubleVector_push_back(self, *args)

    def front(self):
        """front(self) -> value_type"""
        return _loris.DoubleVector_front(self)

    def back(self):
        """back(self) -> value_type"""
        return _loris.DoubleVector_back(self)

    def assign(self, *args):
        """assign(self, n, x)"""
        return _loris.DoubleVector_assign(self, *args)

    def resize(self, *args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _loris.DoubleVector_resize(self, *args)

    def insert(self, *args):
        """
        insert(self, pos, x) -> iterator
        insert(self, pos, n, x)
        """
        return _loris.DoubleVector_insert(self, *args)

    def reserve(self, *args):
        """reserve(self, n)"""
        return _loris.DoubleVector_reserve(self, *args)

    def capacity(self):
        """capacity(self) -> size_type"""
        return _loris.DoubleVector_capacity(self)

    __swig_destroy__ = _loris.delete_DoubleVector
    __del__ = lambda self : None;
DoubleVector_swigregister = _loris.DoubleVector_swigregister
DoubleVector_swigregister(DoubleVector)

class MarkerVector(_object):
    """Proxy of C++ std::vector<(Marker)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MarkerVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MarkerVector, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _loris.MarkerVector_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _loris.MarkerVector___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _loris.MarkerVector___bool__(self)

    def __len__(self):
        """__len__(self) -> size_type"""
        return _loris.MarkerVector___len__(self)

    def pop(self):
        """pop(self) -> value_type"""
        return _loris.MarkerVector_pop(self)

    def __getslice__(self, *args):
        """__getslice__(self, i, j) -> MarkerVector"""
        return _loris.MarkerVector___getslice__(self, *args)

    def __setslice__(self, *args):
        """__setslice__(self, i, j, v)"""
        return _loris.MarkerVector___setslice__(self, *args)

    def __delslice__(self, *args):
        """__delslice__(self, i, j)"""
        return _loris.MarkerVector___delslice__(self, *args)

    def __delitem__(self, *args):
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _loris.MarkerVector___delitem__(self, *args)

    def __getitem__(self, *args):
        """
        __getitem__(self, slice) -> MarkerVector
        __getitem__(self, i) -> value_type
        """
        return _loris.MarkerVector___getitem__(self, *args)

    def __setitem__(self, *args):
        """
        __setitem__(self, slice, v)
        __setitem__(self, i, x)
        """
        return _loris.MarkerVector___setitem__(self, *args)

    def append(self, *args):
        """append(self, x)"""
        return _loris.MarkerVector_append(self, *args)

    def empty(self):
        """empty(self) -> bool"""
        return _loris.MarkerVector_empty(self)

    def size(self):
        """size(self) -> size_type"""
        return _loris.MarkerVector_size(self)

    def clear(self):
        """clear(self)"""
        return _loris.MarkerVector_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _loris.MarkerVector_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> allocator_type"""
        return _loris.MarkerVector_get_allocator(self)

    def begin(self):
        """begin(self) -> const_iterator"""
        return _loris.MarkerVector_begin(self)

    def end(self):
        """end(self) -> const_iterator"""
        return _loris.MarkerVector_end(self)

    def rbegin(self):
        """rbegin(self) -> const_reverse_iterator"""
        return _loris.MarkerVector_rbegin(self)

    def rend(self):
        """rend(self) -> const_reverse_iterator"""
        return _loris.MarkerVector_rend(self)

    def pop_back(self):
        """pop_back(self)"""
        return _loris.MarkerVector_pop_back(self)

    def erase(self, *args):
        """
        erase(self, pos) -> iterator
        erase(self, first, last) -> iterator
        """
        return _loris.MarkerVector_erase(self, *args)

    def __init__(self, *args): 
        """
        __init__(self) -> MarkerVector
        __init__(self, arg0) -> MarkerVector
        __init__(self, size) -> MarkerVector
        __init__(self, size, value) -> MarkerVector
        """
        this = _loris.new_MarkerVector(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(self, *args):
        """push_back(self, x)"""
        return _loris.MarkerVector_push_back(self, *args)

    def front(self):
        """front(self) -> value_type"""
        return _loris.MarkerVector_front(self)

    def back(self):
        """back(self) -> value_type"""
        return _loris.MarkerVector_back(self)

    def assign(self, *args):
        """assign(self, n, x)"""
        return _loris.MarkerVector_assign(self, *args)

    def resize(self, *args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _loris.MarkerVector_resize(self, *args)

    def insert(self, *args):
        """
        insert(self, pos, x) -> iterator
        insert(self, pos, n, x)
        """
        return _loris.MarkerVector_insert(self, *args)

    def reserve(self, *args):
        """reserve(self, n)"""
        return _loris.MarkerVector_reserve(self, *args)

    def capacity(self):
        """capacity(self) -> size_type"""
        return _loris.MarkerVector_capacity(self)

    __swig_destroy__ = _loris.delete_MarkerVector
    __del__ = lambda self : None;
MarkerVector_swigregister = _loris.MarkerVector_swigregister
MarkerVector_swigregister(MarkerVector)


def createF0Estimate(*args):
  """
    createF0Estimate(partials, minFreq, maxFreq, interval) -> LinearEnvelope

    Return a newly-constructed LinearEnvelope that estimates
    the time-varying fundamental frequency of the sound
    represented by the Partials in a PartialList. This uses
    the FundamentalEstimator (FundamentalFromPartials) 
    class to construct an estimator of fundamental frequency, 
    and returns a LinearEnvelope that samples the estimator at the 
    specified time interval (in seconds). Default values are used 
    to configure the estimator. Only estimates in the specified 
    frequency range will be considered valid, estimates outside this 
    range will be ignored.

    Clients are responsible for disposing of the newly-constructed 
    LinearEnvelope.
    """
  return _loris.createF0Estimate(*args)

def dilate(*args):
  """
    dilate(partials, ivec, tvec)

    Dilate Partials in a PartialList according to the given initial
    and target time points. Partial envelopes are stretched and
    compressed so that temporal features at the initial time points
    are aligned with the final time points. Time points are sorted, so
    Partial envelopes are are only stretched and compressed, but
    breakpoints are not reordered. Duplicate time points are allowed.
    There must be the same number of initial and target time points.
    """
  return _loris.dilate(*args)

def exportSdif(*args):
  """
    exportSdif(path, partials)

    Export Partials in a PartialList to a SDIF file at the specified
    file path (or name). SDIF data is written in the Loris RBEP
    format. For more information about SDIF, see the SDIF website at:
    	www.ircam.fr/equipes/analyse-synthese/sdif/  
    """
  return _loris.exportSdif(*args)

def importSdif(*args):
  """
    importSdif(path) -> PartialList

    Import Partials from an SDIF file at the given file path (or
    name), and return them in a PartialList. Loris can import
    SDIF data stored in 1TRC format or in the Loris RBEP format.
    For more information about SDIF, see the SDIF website at:
    	www.ircam.fr/equipes/analyse-synthese/sdif/
    """
  return _loris.importSdif(*args)

def importSpc(*args):
  """
    importSpc(path) -> PartialList

    Import Partials from an Spc file at the given file path (or
    name), and return them in a PartialList.
    """
  return _loris.importSpc(*args)

def enableLogAmpMorphing(*args):
  """
    enableLogAmpMorphing(enableFlag)

    Enable or disable log-domain amplitude and bandwidth morphing.
    """
  return _loris.enableLogAmpMorphing(*args)

def enableLogFreqMorphing(*args):
  """
    enableLogFreqMorphing(enableFlag)

    Enable or disable log-domain frequency morphing.
    """
  return _loris.enableLogFreqMorphing(*args)

def setAmplitudeMorphShape(*args):
  """
    setAmplitudeMorphShape(shape)

    Set the shaping parameter for the amplitude morphing
    function. 

    DEPRECATED - DO NOT USE

    """
  return _loris.setAmplitudeMorphShape(*args)

def crop(*args):
  """
    crop(partials, t1, t2)

    Trim Partials by removing Breakpoints outside a specified time span.
    Insert a Breakpoint at the boundary when cropping occurs.

    """
  return _loris.crop(*args)

def copyLabeled(*args):
  """
    copyLabeled(partials, label) -> PartialList

    Copy Partials in the source PartialList having the specified label
    into a new PartialList. The source PartialList is unmodified.

    """
  return _loris.copyLabeled(*args)

def extractLabeled(*args):
  """
    extractLabeled(partials, label) -> PartialList

    Extract Partials in the source PartialList having the specified
    label and return them in a new PartialList.
    """
  return _loris.extractLabeled(*args)

def removeLabeled(*args):
  """
    removeLabeled(partials, label)

    Remove from a PartialList all Partials having the specified label.
    """
  return _loris.removeLabeled(*args)

def quantize(*args):
  """
    quantize(partials, interval)

    Quantize the Breakpoint times in the specified Partials.
    Each Breakpoint in the Partials is replaced by a Breakpoint
    constructed by resampling the Partial at the nearest
    integer multiple of the of the resampling interval.

    In previous versions of Loris, this was called sparse resampling.

    """
  return _loris.quantize(*args)

def shiftTime(*args):
  """
    shiftTime(partials, offset)

    Shift the time of all the Breakpoints in a Partial by a constant
    amount (in seconds).
    """
  return _loris.shiftTime(*args)

def sortByLabel(*args):
  """
    sortByLabel(partials)

    Sort the Partials in a PartialList in order of increasing label.
    The sort is stable; Partials having the same label are not
    reordered.
    """
  return _loris.sortByLabel(*args)

def avgAmplitude(*args):
  """
    avgAmplitude(p) -> double

    Return the average amplitude over all Breakpoints in this Partial.
    Return zero if the Partial has no Breakpoints.
    """
  return _loris.avgAmplitude(*args)

def avgFrequency(*args):
  """
    avgFrequency(p) -> double

    Return the average frequency over all Breakpoints in this Partial.
    Return zero if the Partial has no Breakpoints.
    """
  return _loris.avgFrequency(*args)

def peakAmplitude(*args):
  """
    peakAmplitude(p) -> double

    Return the maximum amplitude achieved by a Partial.
    """
  return _loris.peakAmplitude(*args)

def timeSpan(*args):
  """
    timeSpan(partials)

    Return the minimum start time and maximum end time
    of all Partials in this PartialList.
    """
  return _loris.timeSpan(*args)

def weightedAvgFrequency(*args):
  """
    weightedAvgFrequency(p) -> double

    Return the average frequency over all Breakpoints in this Partial, 
    weighted by the Breakpoint amplitudes. Return zero if the Partial 
    has no Breakpoints.
    """
  return _loris.weightedAvgFrequency(*args)

def fixPhaseAfter(*args):
  """
    fixPhaseAfter(partials, time)

    Recompute phases of all Breakpoints later than the specified 
    time so that the synthesized phases of those later Breakpoints 
    matches the stored phase, as long as the synthesized phase at 
    the specified time matches the stored (not recomputed) phase.

    Phase fixing is only applied to non-null (nonzero-amplitude) 
    Breakpoints, because null Breakpoints are interpreted as phase 
    reset points in Loris. If a null is encountered, its phase is 
    corrected from its non-Null successor, if it has one, otherwise 
    it is unmodified.
    """
  return _loris.fixPhaseAfter(*args)

def fixPhaseAt(*args):
  """
    fixPhaseAt(partials, time)

    Recompute phases of all Breakpoints in a Partial
    so that the synthesized phases match the stored phases, 
    and the synthesized phase at (nearest) the specified
    time matches the stored (not recomputed) phase.

    Backward phase-fixing stops if a null (zero-amplitude) 
    Breakpoint is encountered, because nulls are interpreted as 
    phase reset points in Loris. If a null is encountered, the 
    remainder of the Partial (the front part) is fixed in the 
    forward direction, beginning at the start of the Partial. 
    Forward phase fixing is only applied to non-null 
    (nonzero-amplitude) Breakpoints. If a null is encountered, 
    its phase is corrected from its non-Null successor, if 
    it has one, otherwise it is unmodified.
    """
  return _loris.fixPhaseAt(*args)

def fixPhaseBefore(*args):
  """
    fixPhaseBefore(partials, time)

    Recompute phases of all Breakpoints earlier than the specified 
    time so that the synthesized phases of those earlier Breakpoints 
    matches the stored phase, and the synthesized phase at the 
    specified time matches the stored (not recomputed) phase.

    Backward phase-fixing stops if a null (zero-amplitude) Breakpoint
    is encountered, because nulls are interpreted as phase reset 
    points in Loris. If a null is encountered, the remainder of the 
    Partial (the front part) is fixed in the forward direction, 
    beginning at the start of the Partial.
    """
  return _loris.fixPhaseBefore(*args)

def fixPhaseBetween(*args):
  """
    fixPhaseBetween(partials, tbeg, tend)

    Fix the phase travel between two times by adjusting the
    frequency and phase of Breakpoints between those two times.

    This algorithm assumes that there is nothing interesting 
    about the phases of the intervening Breakpoints, and modifies 
    their frequencies as little as possible to achieve the correct 
    amount of phase travel such that the frequencies and phases at 
    the specified times match the stored values. The phases of all 
    the Breakpoints between the specified times are recomputed.
    """
  return _loris.fixPhaseBetween(*args)

def fixPhaseForward(*args):
  """
    fixPhaseForward(partials, tbeg, tend)

    Recompute phases of all Breakpoints later than the specified 
    time so that the synthesized phases of those later Breakpoints 
    matches the stored phase, as long as the synthesized phase at 
    the specified time matches the stored (not recomputed) phase. 
    Breakpoints later than tend are unmodified.

    Phase fixing is only applied to non-null (nonzero-amplitude) 
    Breakpoints, because null Breakpoints are interpreted as phase 
    reset points in Loris. If a null is encountered, its phase is 
    corrected from its non-Null successor, if it has one, otherwise 
    it is unmodified.
    """
  return _loris.fixPhaseForward(*args)

def version():
  """
    version() -> char

    Return a string describing the Loris version number.
    """
  return _loris.version()
class Marker(_object):
    """
    Class Marker represents a labeled time point in a set of Partials
    or a vector of samples. Collections of Markers (see the MarkerContainer
    definition below) are held by the File I/O classes in Loris (AiffFile,
    SdifFile, and SpcFile) to identify temporal features in imported
    and exported data.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Marker, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Marker, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> Marker
        __init__(self, t, s) -> Marker
        __init__(self, other) -> Marker

        Initialize a Marker with the specified time (in seconds) and name,
        or copy the time and name from another Marker. If unspecified, time 
        is zero and the label is empty.
        """
        this = _loris.new_Marker(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Marker
    __del__ = lambda self : None;
    def name(self):
        """
        name(self) -> char

        Return the name of this Marker.
        """
        return _loris.Marker_name(self)

    def time(self):
        """
        time(self) -> double

        Return the time (in seconds) associated with this Marker.
        """
        return _loris.Marker_time(self)

    def setName(self, *args):
        """
        setName(self, s)

        Set the name of the Marker.
        """
        return _loris.Marker_setName(self, *args)

    def setTime(self, *args):
        """
        setTime(self, t)

        Set the time (in seconds) associated with this Marker.
        """
        return _loris.Marker_setTime(self, *args)

Marker_swigregister = _loris.Marker_swigregister
Marker_swigregister(Marker)

def channelize(*args):
  """
    channelize(partials, refFreqEnvelope, refLabel)
    channelize(partials, refFreq)

    Label Partials in a PartialList with the integer nearest to the
    amplitude-weighted average ratio of their frequency envelope to a
    reference frequency envelope. If a reference frequency is specified,
    then the reference envelope is constant at that frequency.

    The frequency spectrum is partitioned into non-overlapping channels
    whose time-varying center frequencies track the reference frequency
    envelope. The reference label indicates which channel's center
    frequency is exactly equal to the reference envelope frequency, and
    other channels' center frequencies are multiples of the reference
    envelope frequency divided by the reference label. Each Partial in the
    PartialList is labeled with the number of the channel that best fits
    its frequency envelope. Partials are labeled, but otherwise
    unmodified.

    For finer control over channelization, including harmonic stretching
    for stiff strings, and amplitude weighting for determining the
    best-fitting channel, use the Channelizer class.
    """
  return _loris.channelize(*args)

def collate(*args):
  """
    collate(partials, fadeTime = Collator::DefaultFadeTimeMs/1000.0, 
        gapTime = Collator::DefaultSilentTimeMs/1000.0)
    collate(partials, fadeTime = Collator::DefaultFadeTimeMs/1000.0)
    collate(partials)

    Collate unlabeled (zero-labeled) Partials into the smallest-possible 
    number of Partials that does not combine any overlapping Partials.
    Collated Partials assigned labels higher than any label in the original 
    list, and appear at the end of the sequence, after all previously-labeled
    Partials. Optionally specify the fade and gap times, else default values
    are used.
    """
  return _loris.collate(*args)

def createFreqReference(*args):
  """
    createFreqReference(partials, minFreq, maxFreq, numSamps) -> LinearEnvelope
    createFreqReference(partials, minFreq, maxFreq) -> LinearEnvelope

    Return a newly-constructed LinearEnvelope using the legacy 
    FrequencyReference class. The envelope will have approximately
    the specified number of samples. The specified number of samples 
    must be greater than 1. Uses the FundamentalEstimator 
    (FundamentalFromPartials) class to construct an estimator of 
    fundamental frequency, configured to emulate the behavior of
    the FrequencyReference class in Loris 1.4-1.5.2. If numSamps
    is unspecified, construct the reference envelope from fundamental 
    estimates taken every five milliseconds.

    For simple sounds, this frequency reference may be a 
    good first approximation to a reference envelope for
    channelization (see channelize()).
    """
  return _loris.createFreqReference(*args)

def distill(*args):
  """
    distill(partials, fadeTime = Distiller::DefaultFadeTimeMs/1000.0, 
        gapTime = Distiller::DefaultSilentTimeMs/1000.0)
    distill(partials, fadeTime = Distiller::DefaultFadeTimeMs/1000.0)
    distill(partials)

    Distill labeled (channelized) Partials in a PartialList into a 
    PartialList containing at most one Partial per label. Unlabeled 
    (zero-labeled) Partials are left unmodified at the end of the 
    distilled Partials. Optionally specify the fade and gap times, 
    defaults are 5ms and 1ms.

    """
  return _loris.distill(*args)

def exportAiff(*args):
  """
    exportAiff(path, samples, samplerate = 44100, bitsPerSamp = 16, 
        nchansignored = 1)
    exportAiff(path, samples, samplerate = 44100, bitsPerSamp = 16)
    exportAiff(path, samples, samplerate = 44100)
    exportAiff(path, samples)
    exportAiff(path, partials, samplerate = 44100, bitsPerSamp = 16)
    exportAiff(path, partials, samplerate = 44100)
    exportAiff(path, partials)

    Export audio samples stored in a vector to an AIFF file having the
    specified number of channels and sample rate at the given file
    path (or name). The floating point samples in the vector are
    clamped to the range (-1.,1.) and converted to integers having
    bitsPerSamp bits. The default values for the sample rate and
    sample size, if unspecified, are 44100 Hz (CD quality) and 16 bits
    per sample, respectively. If neither is specified, then the 
    default synthesis parameters (see SynthesisParameters) are used.

    If a PartialList is specified, the Partials are rendered at the
    specified sample rate and then exported.

    Only mono files can be exported, the last argument is ignored, 
    and is included only for backward compatability
    """
  return _loris.exportAiff(*args)

def exportSpc(*args):
  """
    exportSpc(path, partials, midiPitch, enhanced, endApproachTime)
    exportSpc(path, partials, midiPitch, enhanced)
    exportSpc(path, partials, midiPitch)

    Export Partials in a PartialList to a Spc file at the specified
    file path (or name). The fractional MIDI pitch must be specified.
    The optional enhanced parameter defaults to true (for
    bandwidth-enhanced spc files), but an be specified false for
    pure-sines spc files. The optional endApproachTime parameter is in
    seconds; its default value is zero (and has no effect). A nonzero
    endApproachTime indicates that the PartialList does not include a
    release, but rather ends in a static spectrum corresponding to the
    final breakpoint values of the partials. The endApproachTime
    specifies how long before the end of the sound the amplitude,
    frequency, and bandwidth values are to be modified to make a
    gradual transition to the static spectrum.
    """
  return _loris.exportSpc(*args)

def harmonify(*args):
  """
    harmonify(partials, refLabel, env, threshold_dB)
    harmonify(partials, refLabel, threshold_dB)

    Apply a reference Partial to fix the frequencies of Breakpoints
    whose amplitude is below threshold_dB. Threshold 0 harmonifies all
    Partials. To apply only to quiet Partials, specify a lower 
    threshold (like -90). The reference Partial is the first Partial
    in the PartialList labeled refLabel (usually 1). The Envelope,
    if specified, is a time-varying weighting on the harmonifing process. 
    When 1, harmonic frequencies are used, when 0, breakpoint frequencies are 
    unmodified. 
    """
  return _loris.harmonify(*args)

def morph(*args):
  """
    morph(src0, src1, ffreq, famp, fbw) -> PartialList
    morph(src0, src1, freqweight, ampweight, bwweight) -> PartialList
    morph(src0, src1, src0RefLabel, src1RefLabel, ffreq, famp, 
        fbw) -> PartialList
    morph(src0, src1, src0RefLabel, src1RefLabel, freqweight, 
        ampweight, bwweight) -> PartialList

    Morph labeled Partials in two PartialLists according to the
    given frequency, amplitude, and bandwidth (noisiness) morphing
    envelopes, and return the morphed Partials in a PartialList.

    Optionally specify the labels of the Partials to be used as 
    reference Partial for the two morph sources. The reference 
    partial is used to compute frequencies for very low-amplitude 
    Partials whose frequency estimates are not considered reliable. 
    The reference Partial is considered to have good frequency 
    estimates throughout. A reference label of 0 indicates that 
    no reference Partial should be used for the corresponding
    morph source.

    Loris morphs Partials by interpolating frequency, amplitude,
    and bandwidth envelopes of corresponding Partials in the
    source PartialLists. For more information about the Loris
    morphing algorithm, see the Loris website:
    	www.cerlsoundgroup.org/Loris/
    """
  return _loris.morph(*args)
cvar = _loris.cvar
LORIS_DEFAULT_AMPMORPHSHAPE = cvar.LORIS_DEFAULT_AMPMORPHSHAPE
LORIS_LINEAR_AMPMORPHSHAPE = cvar.LORIS_LINEAR_AMPMORPHSHAPE

def resample(*args):
  """
    resample(partials, interval, denseResampling = True, phaseCorrect = True)
    resample(partials, interval, denseResampling = True)
    resample(partials, interval)
    resample(partials, timing, interval, phaseCorrect = False)
    resample(partials, timing, interval)

    Resample all Partials in a PartialList using the specified
    sampling interval, so that the Breakpoints in the Partial
    envelopes will all lie on a common temporal grid. 

    The Breakpoint times in resampled Partials will comprise a
    contiguous sequence of ALL integer multiples of the sampling interval
    (a lot of data, but useful for some third-party tools, like the CNMAT
    sinusoids~ external for Max/MSP). 

    If a timing envelope is specified, then that envelope represents
    a warping of the time axis that is applied during resampling. The
    Breakpoint times in resampled Partials will a comprise contiguous 
    sequence of all integer multiples of the sampling interval between 
    the first and last breakpoints in the timing envelope, and each 
    Breakpoint will represent the parameters of the original Partial 
    at the time that is the value of the timing envelope at that instant.
    This can be used to achieve effects similar to dilation (see dilate),
    but can also be used to achieve time-reveral and scrubbing effects.

    If phase correct resampling is selected, Partial frequencies are
    altered slightly to match, as nearly as possible, the Breakpoint
    phases after resampling. Phases are updated so that the Partial
    frequencies and phases are consistent after resampling. The
    default is phase correct resampling, unless a timing envelope
    is specified, in which case it is better to explcitly match
    phases at known critical points.

    See also quantize, which was previously described as sparse
    resampling.
    """
  return _loris.resample(*args)

def scaleAmp(*args):
  """
    scaleAmp(partials, ampEnv)
    scaleAmp(partials, val)

    Bad old name for scaleAmplitude.
    """
  return _loris.scaleAmp(*args)

def scaleAmplitude(*args):
  """
    scaleAmplitude(partials, ampEnv)
    scaleAmplitude(p, ampEnv)
    scaleAmplitude(partials, val)
    scaleAmplitude(p, val)

    Scale the amplitude of a Partial, or all Partials in a PartialList, according 
    to an envelope representing a time-varying amplitude scale value.
    """
  return _loris.scaleAmplitude(*args)

def scaleBandwidth(*args):
  """
    scaleBandwidth(partials, bwEnv)
    scaleBandwidth(partials, val)
    scaleBandwidth(p, bwEnv)
    scaleBandwidth(p, val)

    Scale the bandwidth of a Partial, or all Partials in a PartialList, according 
    to an envelope representing a time-varying bandwidth scale value.
    """
  return _loris.scaleBandwidth(*args)

def scaleFrequency(*args):
  """
    scaleFrequency(partials, freqEnv)
    scaleFrequency(partials, val)
    scaleFrequency(p, freqEnv)
    scaleFrequency(p, val)

    Scale the frequency of a Partial, or all Partials in a PartialList, according 
    to an envelope representing a time-varying frequency scale value.
    """
  return _loris.scaleFrequency(*args)

def scaleNoiseRatio(*args):
  """
    scaleNoiseRatio(partials, noiseEnv)
    scaleNoiseRatio(partials, val)
    scaleNoiseRatio(p, noiseEnv)
    scaleNoiseRatio(p, val)

    Scale the relative noise content of a Partial, or all Partials in a PartialList,
    according to an envelope representing a (time-varying) noise energy 
    scale value.
    """
  return _loris.scaleNoiseRatio(*args)

def setBandwidth(*args):
  """
    setBandwidth(partials, bwEnv)
    setBandwidth(partials, val)
    setBandwidth(p, bwEnv)
    setBandwidth(p, val)

    Set the bandwidth of a Partial, or all Partials in a PartialList, according 
    to an envelope representing a time-varying bandwidth value.
    """
  return _loris.setBandwidth(*args)

def shapeSpectrum(*args):
  """
    shapeSpectrum(partials, surface, stretchFreq, stretchTime)
    shapeSpectrum(partials, surface)

    Scale the amplitudes of a set of Partials by applying 
    a spectral suface constructed from another set.
    If frequency and time stretch factors are specified,
    then the spectral surface is stretched by those 
    factors before the surface is used to shape the 
    Partial amplitudes.
    """
  return _loris.shapeSpectrum(*args)

def shiftPitch(*args):
  """
    shiftPitch(partials, pitchEnv)
    shiftPitch(partials, val)

    Shift the pitch of all Partials in a PartialList according to 
    the given pitch envelope. The pitch envelope is assumed to have 
    units of cents (1/100 of a halfstep).
    """
  return _loris.shiftPitch(*args)

def sift(*args):
  """
    sift(partials, fadeTime = Sieve::DefaultFadeTimeMs/1000.0)
    sift(partials)

    Eliminate overlapping Partials having the same label
    (except zero). If any two partials with same label
    overlap in time, keep only the longer of the two.
    Set the label of the shorter duration partial to zero.
    Optionally specify the fade time, default is 1ms.
    """
  return _loris.sift(*args)

class AiffFile(_object):
    """
    An AiffFile represents a sample file (on disk) in the Audio Interchange
    File Format. The file is read from disk and the samples stored in memory
    upon construction of an AiffFile instance. The samples are accessed by 
    the samples() method, which converts them to double precision floats and
    returns them in a vector.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AiffFile, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AiffFile, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, filename) -> AiffFile
        __init__(self, vec, samplerate) -> AiffFile
        __init__(self, vec_left, vec_right, samplerate) -> AiffFile
        __init__(self, l, sampleRate = 44100, fadeTime = .001) -> AiffFile
        __init__(self, l, sampleRate = 44100) -> AiffFile
        __init__(self, l) -> AiffFile

        An AiffFile instance can be initialized in any of the following ways:

        Initialize a new AiffFile from a vector of samples and sample rate.

        Initialize a new AiffFile from two vectors of samples, for left and right
        channels, and sample rate.

        Initialize a new AiffFile using data read from a named file.

        Initialize an instance of AiffFile having the specified sample 
        rate, accumulating samples rendered at that sample rate from
        all Partials in the specified PartialList with the (optionally) 
        specified Partial fade time (see Synthesizer.h for an explanation 
        of fade time). 

        """
        this = _loris.new_AiffFile(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_AiffFile
    __del__ = lambda self : None;
    def sampleRate(self):
        """
        sampleRate(self) -> double

        Return the sample rate in Hz for this AiffFile.
        """
        return _loris.AiffFile_sampleRate(self)

    def midiNoteNumber(self):
        """
        midiNoteNumber(self) -> double

        Return the MIDI note number for this AiffFile. The defaul
        note number is 60, corresponding to middle C.
        """
        return _loris.AiffFile_midiNoteNumber(self)

    def sampleFrames(self):
        """
        sampleFrames(self) -> unsigned long

        Return the number of sample frames (equal to the number of samples
        in a single channel file) stored by this AiffFile.
        """
        return _loris.AiffFile_sampleFrames(self)

    def addPartial(self, *args):
        """
        addPartial(self, p, fadeTime = .001)
        addPartial(self, p)

        Render the specified Partial using the (optionally) specified
        Partial fade time, and accumulate the resulting samples into
        the sample vector for this AiffFile.
        """
        return _loris.AiffFile_addPartial(self, *args)

    def setMidiNoteNumber(self, *args):
        """
        setMidiNoteNumber(self, nn)

        Set the fractional MIDI note number assigned to this AiffFile. 
        If the sound has no definable pitch, use note number 60.0 
        (the default).
        """
        return _loris.AiffFile_setMidiNoteNumber(self, *args)

    def write(self, *args):
        """
        write(self, filename, bps = 16)
        write(self, filename)

        Export the sample data represented by this AiffFile to
        the file having the specified filename or path. Export
        signed integer samples of the specified size, in bits
        (8, 16, 24, or 32).
        """
        return _loris.AiffFile_write(self, *args)

    def samples(self):
        """
        samples(self) -> DoubleVector

        Return a copy of the samples (as floating point numbers
        on the range -1,1) stored in this AiffFile.
        """
        return _loris.AiffFile_samples(self)

    def channels(self):
        """
        channels(self) -> int

        The number of channels is always 1. 
        Loris only deals in mono AiffFiles
        """
        return _loris.AiffFile_channels(self)

    def addPartials(self, *args):
        """
        addPartials(self, l, fadeTime = 0.001)
        addPartials(self, l)

        Render all Partials on the specified half-open (STL-style) range
        with the (optionally) specified Partial fade time (see Synthesizer.h
        for an examplanation of fade time), and accumulate the resulting 
        samples.
        """
        return _loris.AiffFile_addPartials(self, *args)

    def markers(self):
        """
        markers(self) -> MarkerVector

        Return the (possibly empty) collection of Markers for 
        this AiffFile.
        """
        return _loris.AiffFile_markers(self)

    def addMarkers(self, *args):
        """
        addMarkers(self, markers)

        Append a collection of Markers for to the existing
        set of Markers for this AiffFile.
        """
        return _loris.AiffFile_addMarkers(self, *args)

    def setMarkers(self, *args):
        """
        setMarkers(self, markers)

        Specify a new (possibly empty) collection of Markers for
        this AiffFile.
        """
        return _loris.AiffFile_setMarkers(self, *args)

AiffFile_swigregister = _loris.AiffFile_swigregister
AiffFile_swigregister(AiffFile)

class Analyzer(_object):
    """
    An Analyzer represents a configuration of parameters for
    performing Reassigned Bandwidth-Enhanced Additive Analysis
    of sampled waveforms. This analysis process yields a collection 
    of Partials, each having a trio of synchronous, non-uniformly-
    sampled breakpoint envelopes representing the time-varying 
    frequency, amplitude, and noisiness of a single bandwidth-
    enhanced sinusoid. 

    For more information about Reassigned Bandwidth-Enhanced 
    Analysis and the Reassigned Bandwidth-Enhanced Additive Sound 
    Model, refer to the Loris website: 

    	http://www.cerlsoundgroup.org/Loris/

    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Analyzer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Analyzer, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, resolutionHz) -> Analyzer
        __init__(self, resolutionHz, windowWidthHz) -> Analyzer
        __init__(self, resolutionEnv, windowWidthHz) -> Analyzer
        __init__(self, another) -> Analyzer

        Construct and return a new Analyzer configured with the given	
        frequency resolution (minimum instantaneous frequency	
        difference between Partials) and analysis window main 
        lobe width (between zeros). All other Analyzer parameters 	
        are computed from the specified resolution and window
        width. If the window width is not specified, 
        then it is set to twice the resolution. If an envelope is
        provided for the frequency resolution, then it describes
        the time-varying analysis resolution in Hz. 

        An Analyzer configuration can also be copied from another
        instance.
        """
        this = _loris.new_Analyzer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Analyzer
    __del__ = lambda self : None;
    def analyze(self, *args):
        """
        analyze(self, vec, srate) -> PartialList
        analyze(self, vec, srate, env) -> PartialList

        Analyze a vector of (mono) samples at the given sample rate 	  	
        (in Hz) and return the resulting Partials in a PartialList.
        If specified, use a frequency envelope as a fundamental reference for
        Partial formation.
        """
        return _loris.Analyzer_analyze(self, *args)

    def ampFloor(self):
        """
        ampFloor(self) -> double

        Return the amplitude floor (lowest detected spectral amplitude),              
        in (negative) dB, for this Analyzer.
        """
        return _loris.Analyzer_ampFloor(self)

    def cropTime(self):
        """
        cropTime(self) -> double

        Return the crop time (maximum temporal displacement of a time-
        frequency data point from the time-domain center of the analysis
        window, beyond which data points are considered "unreliable")
        for this Analyzer.
        """
        return _loris.Analyzer_cropTime(self)

    def freqDrift(self):
        """
        freqDrift(self) -> double

        Return the maximum allowable frequency difference between                     
        consecutive Breakpoints in a Partial envelope for this Analyzer.
        """
        return _loris.Analyzer_freqDrift(self)

    def freqFloor(self):
        """
        freqFloor(self) -> double

        Return the frequency floor (minimum instantaneous Partial                  
        frequency), in Hz, for this Analyzer.
        """
        return _loris.Analyzer_freqFloor(self)

    def freqResolution(self, time = 0.0):
        """
        freqResolution(self, time = 0.0) -> double
        freqResolution(self) -> double

        Return the frequency resolution (minimum instantaneous frequency          
        difference between Partials) for this Analyzer at the specified
        time in seconds. If no time is specified, then the initial resolution
        (at 0 seconds) is returned.
        """
        return _loris.Analyzer_freqResolution(self, time)

    def hopTime(self):
        """
        hopTime(self) -> double

        Return the hop time (which corresponds approximately to the 
        average density of Partial envelope Breakpoint data) for this 
        Analyzer.
        """
        return _loris.Analyzer_hopTime(self)

    def sidelobeLevel(self):
        """
        sidelobeLevel(self) -> double

        Return the sidelobe attenutation level for the Kaiser analysis window in
        positive dB. Higher numbers (e.g. 90) give very good sidelobe 
        rejection but cause the window to be longer in time. Smaller 
        numbers raise the level of the sidelobes, increasing the likelihood
        of frequency-domain interference, but allow the window to be shorter
        in time.
        """
        return _loris.Analyzer_sidelobeLevel(self)

    def windowWidth(self):
        """
        windowWidth(self) -> double

        Return the frequency-domain main lobe width (measured between 
        zero-crossings) of the analysis window used by this Analyzer.
        """
        return _loris.Analyzer_windowWidth(self)

    def phaseCorrect(self):
        """
        phaseCorrect(self) -> bool

        Return true if the phases and frequencies of the constructed
         partials should be modified to be consistent at the end of the
         analysis, and false otherwise. (Default is true.)
        """
        return _loris.Analyzer_phaseCorrect(self)

    def setAmpFloor(self, *args):
        """
        setAmpFloor(self, x)

        Set the amplitude floor (lowest detected spectral amplitude), in              
        (negative) dB, for this Analyzer.
        """
        return _loris.Analyzer_setAmpFloor(self, *args)

    def setBwRegionWidth(self, *args):
        """
        setBwRegionWidth(self, x)

        Deprecated, use storeResidueBandwidth instead.
        """
        return _loris.Analyzer_setBwRegionWidth(self, *args)

    def setCropTime(self, *args):
        """
        setCropTime(self, x)

        Set the crop time (maximum temporal displacement of a time-
        frequency data point from the time-domain center of the analysis
        window, beyond which data points are considered "unreliable")
        for this Analyzer.
        """
        return _loris.Analyzer_setCropTime(self, *args)

    def setFreqDrift(self, *args):
        """
        setFreqDrift(self, x)

        Set the maximum allowable frequency difference between                     
        consecutive Breakpoints in a Partial envelope for this Analyzer.
        """
        return _loris.Analyzer_setFreqDrift(self, *args)

    def setFreqFloor(self, *args):
        """
        setFreqFloor(self, x)

        Set the amplitude floor (minimum instantaneous Partial                  
        frequency), in Hz, for this Analyzer.
        """
        return _loris.Analyzer_setFreqFloor(self, *args)

    def setFreqResolution(self, *args):
        """
        setFreqResolution(self, x)
        setFreqResolution(self, e)

        Set the frequency resolution (minimum instantaneous frequency          
        difference between Partials) for this Analyzer. (Does not cause     
        other parameters to be recomputed.)
        """
        return _loris.Analyzer_setFreqResolution(self, *args)

    def setHopTime(self, *args):
        """
        setHopTime(self, x)

        Set the hop time (which corresponds approximately to the average
        density of Partial envelope Breakpoint data) for this Analyzer.
        """
        return _loris.Analyzer_setHopTime(self, *args)

    def setSidelobeLevel(self, *args):
        """
        setSidelobeLevel(self, x)

        Set the sidelobe attenutation level for the Kaiser analysis window in
        positive dB. Larger numbers (e.g. 90) give very good sidelobe 
        rejection but cause the window to be longer in time. Smaller 
        numbers raise the level of the sidelobes, increasing the likelihood
        of frequency-domain interference, but allow the window to be shorter
        in time.
        """
        return _loris.Analyzer_setSidelobeLevel(self, *args)

    def setWindowWidth(self, *args):
        """
        setWindowWidth(self, x)

        Set the frequency-domain main lobe width (measured between 
        zero-crossings) of the analysis window used by this Analyzer.
        """
        return _loris.Analyzer_setWindowWidth(self, *args)

    def setPhaseCorrect(self, TF = True):
        """
        setPhaseCorrect(self, TF = True)
        setPhaseCorrect(self)

        Indicate whether the phases and frequencies of the constructed
         partials should be modified to be consistent at the end of the
         analysis. (Default is true.)
        """
        return _loris.Analyzer_setPhaseCorrect(self, TF)

    def storeResidueBandwidth(self, *args):
        """
        storeResidueBandwidth(self, regionWidth = Analyzer::Default_ResidueBandwidth_RegionWidth)
        storeResidueBandwidth(self)

        Construct Partial bandwidth envelopes during analysis
        by associating residual energy in the spectrum (after
        peak extraction) with the selected spectral peaks that
        are used to construct Partials. 

        regionWidth is the width (in Hz) of the bandwidth 
        association regions used by this process, must be positive.
        If unspecified, a default value is used.
        """
        return _loris.Analyzer_storeResidueBandwidth(self, *args)

    def storeConvergenceBandwidth(self, *args):
        """
        storeConvergenceBandwidth(self, tolerance = 0.01*Analyzer::Default_ConvergenceBandwidth_TolerancePct)

        Construct Partial bandwidth envelopes during analysis
        by storing the mixed derivative of short-time phase, 
        scaled and shifted so that a value of 0 corresponds
        to a pure sinusoid, and a value of 1 corresponds to a
        bandwidth-enhanced sinusoid with maximal energy spread
        (minimum sinusoidal convergence).

        tolerance is the amount of range over which the 
        mixed derivative indicator should be allowed to drift away 
        from a pure sinusoid before saturating. This range is mapped
        to bandwidth values on the range [0,1]. Must be positive and 
        not greater than 1. If unspecified, a default value is used.
        """
        return _loris.Analyzer_storeConvergenceBandwidth(self, *args)

    def storeNoBandwidth(self):
        """
        storeNoBandwidth(self)

        Disable bandwidth envelope construction. Bandwidth 
        will be zero for all Breakpoints in all Partials.
        """
        return _loris.Analyzer_storeNoBandwidth(self)

    def bandwidthIsResidue(self):
        """
        bandwidthIsResidue(self) -> bool

        Return true if this Analyzer is configured to compute
        bandwidth envelopes using the spectral residue after
        peaks have been identified, and false otherwise.
        """
        return _loris.Analyzer_bandwidthIsResidue(self)

    def bandwidthIsConvergence(self):
        """
        bandwidthIsConvergence(self) -> bool

        Return true if this Analyzer is configured to compute
        bandwidth envelopes using the mixed derivative convergence
        indicator, and false otherwise.
        """
        return _loris.Analyzer_bandwidthIsConvergence(self)

    def bwRegionWidth(self):
        """
        bwRegionWidth(self) -> double

        Return the width (in Hz) of the Bandwidth Association regions
        used by this Analyzer, only if the spectral residue method is
        used to compute bandwidth envelopes. Return zero if the mixed
        derivative method is used, or if no bandwidth is computed.
        """
        return _loris.Analyzer_bwRegionWidth(self)

    def bwConvergenceTolerance(self):
        """
        bwConvergenceTolerance(self) -> double

        Return the mixed derivative convergence tolerance
        only if the convergence indicator is used to compute
        bandwidth envelopes. Return zero if the spectral residue
        method is used or if no bandwidth is computed.
        """
        return _loris.Analyzer_bwConvergenceTolerance(self)

    def fundamentalEnv(self):
        """
        fundamentalEnv(self) -> LinearEnvelope

        Return the fundamental frequency estimate envelope constructed
        during the most recent analysis performed by this Analyzer.
        Will be empty unless buildFundamentalEnv was invoked to enable the
        construction of this envelope during analysis.
        """
        return _loris.Analyzer_fundamentalEnv(self)

    def ampEnv(self):
        """
        ampEnv(self) -> LinearEnvelope

        Return the overall amplitude estimate envelope constructed
        during the most recent analysis performed by this Analyzer.
        """
        return _loris.Analyzer_ampEnv(self)

    def buildAmpEnv(self, TF = True):
        """
        buildAmpEnv(self, TF = True)
        buildAmpEnv(self)

        Legacy support, do not use. The amplitude and frequency envelopes
        are always estimated.
        """
        return _loris.Analyzer_buildAmpEnv(self, TF)

    def buildFundamentalEnv(self, *args):
        """
        buildFundamentalEnv(self, fmin, fmax, threshDb = -60, threshHz = 8000)
        buildFundamentalEnv(self, fmin, fmax, threshDb = -60)
        buildFundamentalEnv(self, fmin, fmax)
        buildFundamentalEnv(self, TF = True)
        buildFundamentalEnv(self)

        Configure the fundamental frequency estimator.

        fmin is the lower bound on the fundamental frequency estimate.
        fmax is the upper bound on the fundamental frequency estimate
        threshDb is the lower bound on the amplitude of a spectral peak
        that will constribute to the fundamental frequency estimate (very
        low amplitude peaks tend to have less reliable frequency estimates).
        Default is -60 dB.
        threshHz is the upper bound on the frequency of a spectral
        peak that will constribute to the fundamental frequency estimate.
        Default is 8 kHz.

        The fundamental frequency estimate can be accessed by
        fundamentalEnv() after the analysis is complete.

        """
        return _loris.Analyzer_buildFundamentalEnv(self, *args)

Analyzer_swigregister = _loris.Analyzer_swigregister
Analyzer_swigregister(Analyzer)

class SdifFile(_object):
    """
    Class SdifFile represents reassigned bandwidth-enhanced Partial 
    data in a SDIF-format data file. Construction of an SdifFile 
    from a stream or filename automatically imports the Partial
    data.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SdifFile, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SdifFile, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_SdifFile
    __del__ = lambda self : None;
    def write(self, *args):
        """
        write(self, path)

        Export the Partials represented by this SdifFile to
        the file having the specified filename or path.
        """
        return _loris.SdifFile_write(self, *args)

    def write1TRC(self, *args):
        """
        write1TRC(self, path)

        Export the envelope Partials represented by this SdifFile to
        the file having the specified filename or path in the 1TRC
        format, resampled, and without phase or bandwidth information.
        """
        return _loris.SdifFile_write1TRC(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, filename) -> SdifFile
        __init__(self) -> SdifFile
        __init__(self, l) -> SdifFile

        Initialize an instance of SdifFile by importing Partial data from
        the file having the specified filename or path, 
        or initialize an instance of SdifFile storing the Partials in
        the specified PartialList. If no PartialList is specified,
        construct an empty SdifFile.
        """
        this = _loris.new_SdifFile(*args)
        try: self.this.append(this)
        except: self.this = this
    def partials(self):
        """
        partials(self) -> PartialList

        Return a copy of the Partials represented by this SdifFile.
        """
        return _loris.SdifFile_partials(self)

    def addPartials(self, *args):
        """
        addPartials(self, l)

        Add all the Partials in a PartialList to this SdifFile.
        """
        return _loris.SdifFile_addPartials(self, *args)

    def markers(self):
        """
        markers(self) -> MarkerVector

        Return the (possibly empty) collection of Markers for 
        this SdifFile.
        """
        return _loris.SdifFile_markers(self)

    def addMarkers(self, *args):
        """
        addMarkers(self, markers)

        Append a collection of Markers for to the existing
        set of Markers for this SdifFile.
        """
        return _loris.SdifFile_addMarkers(self, *args)

    def setMarkers(self, *args):
        """
        setMarkers(self, markers)

        Specify a new (possibly empty) collection of Markers for
        this SdifFile.
        """
        return _loris.SdifFile_setMarkers(self, *args)

SdifFile_swigregister = _loris.SdifFile_swigregister
SdifFile_swigregister(SdifFile)

class SpcFile(_object):
    """
    Class SpcFile represents a collection of reassigned bandwidth-enhanced
    Partial data in a SPC-format envelope stream data file, used by the
    real-time bandwidth-enhanced additive synthesizer implemented on the
    Symbolic Sound Kyma Sound Design Workstation. Class SpcFile manages 
    file I/O and conversion between Partials and envelope parameter streams.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpcFile, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SpcFile, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_SpcFile
    __del__ = lambda self : None;
    def sampleRate(self):
        """
        sampleRate(self) -> double

        Return the sample rate for this SpcFile in Hz.
        """
        return _loris.SpcFile_sampleRate(self)

    def midiNoteNumber(self):
        """midiNoteNumber(self) -> double"""
        return _loris.SpcFile_midiNoteNumber(self)

    def addPartial(self, *args):
        """
        addPartial(self, p)
        addPartial(self, p, label)

        Add the specified Partial to the enevelope parameter streams
        represented by this SpcFile. If a label is specified, use that
        label, instead of the Partial's label, for the Partial added to
        the SpcFile.

        A SpcFile can contain only one Partial having any given (non-zero) 
        label, so an added Partial will replace a Partial having the 
        same label, if such a Partial exists.

        This may throw an InvalidArgument exception if an attempt is made
        to add unlabeled Partials, or Partials labeled higher than the
        allowable maximum.   

        """
        return _loris.SpcFile_addPartial(self, *args)

    def setMidiNoteNumber(self, *args):
        """
        setMidiNoteNumber(self, nn)

        Set the fractional MIDI note number assigned to this SpcFile. 
        If the sound has no definable pitch, use note number 60.0 (the default).
        """
        return _loris.SpcFile_setMidiNoteNumber(self, *args)

    def setSampleRate(self, *args):
        """
        setSampleRate(self, rate)

        Set the sampling freqency in Hz for the spc data in this
        SpcFile. This is the rate at which Kyma must be running to ensure
        proper playback of bandwidth-enhanced Spc data.
        The default sample rate is 44100 Hz.
        """
        return _loris.SpcFile_setSampleRate(self, *args)

    def write(self, *args):
        """
        write(self, filename, enhanced = True, endApproachTime = 0)
        write(self, filename, enhanced = True)
        write(self, filename)

        Export the envelope parameter streams represented by this SpcFile to
        the file having the specified filename or path. Export phase-correct 
        bandwidth-enhanced envelope parameter streams if enhanced is true 
        (the default), or pure sinsoidal streams otherwise.

        A nonzero endApproachTime indicates that the Partials do not include a
        release or decay, but rather end in a static spectrum corresponding to the
        final Breakpoint values of the partials. The endApproachTime specifies how
        long before the end of the sound the amplitude, frequency, and bandwidth
        values are to be modified to make a gradual transition to the static spectrum.

        If the endApproachTime is not specified, it is assumed to be zero, 
        corresponding to Partials that decay or release normally.
        """
        return _loris.SpcFile_write(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, filename) -> SpcFile
        __init__(self, midiNoteNum = 60) -> SpcFile
        __init__(self) -> SpcFile
        __init__(self, l, midiNoteNum = 60) -> SpcFile
        __init__(self, l) -> SpcFile

        Construct and return a new SpcFile by importing envelope parameter 
        streams from the file having the specified filename or path, 
        or initialize an instance of SpcFile having the specified fractional
        MIDI note number. If a PartialList is specified, add those
        Partials to the file. Otherwise, the new SpcFile contains 
        no Partials (or envelope parameter streams).
        The default MIDI note number is 60 (middle C).
        """
        this = _loris.new_SpcFile(*args)
        try: self.this.append(this)
        except: self.this = this
    def partials(self):
        """
        partials(self) -> PartialList

        Return a copy of the Partials represented by this SdifFile.
        """
        return _loris.SpcFile_partials(self)

    def addPartials(self, *args):
        """
        addPartials(self, l)

        Add all the Partials in a PartialList to this SpcFile.
        			
        A SpcFile can contain only one Partial having any given (non-zero) 
        label, so an added Partial will replace a Partial having the 
        same label, if such a Partial exists.

        This may throw an InvalidArgument exception if an attempt is made
        to add unlabeled Partials, or Partials labeled higher than the
        allowable maximum.
        """
        return _loris.SpcFile_addPartials(self, *args)

    def markers(self):
        """
        markers(self) -> MarkerVector

        Return the (possibly empty) collection of Markers for 
        this SpcFile.
        """
        return _loris.SpcFile_markers(self)

    def addMarkers(self, *args):
        """
        addMarkers(self, markers)

        Append a collection of Markers for to the existing
        set of Markers for this SpcFile.
        """
        return _loris.SpcFile_addMarkers(self, *args)

    def setMarkers(self, *args):
        """
        setMarkers(self, markers)

        Specify a new (possibly empty) collection of Markers for
        this SpcFile.
        """
        return _loris.SpcFile_setMarkers(self, *args)

SpcFile_swigregister = _loris.SpcFile_swigregister
SpcFile_swigregister(SpcFile)

class PartialListIterator(_object):
    """
    An iterator over a PartialList. Access Partials
    in a PartialList by invoking next until atEnd 
    returns true.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PartialListIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PartialListIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_PartialListIterator
    __del__ = lambda self : None;
    def atEnd(self):
        """
        atEnd(self) -> bool

        Return true if there are no more Partials in the PartialList.
        """
        return _loris.PartialListIterator_atEnd(self)

    def next(self):
        """
        next(self) -> Partial

        Return the next Partial in the PartialList that has not yet
        been returned by this iterator.
        """
        return _loris.PartialListIterator_next(self)

PartialListIterator_swigregister = _loris.PartialListIterator_swigregister
PartialListIterator_swigregister(PartialListIterator)

class PartialIterator(_object):
    """Proxy of C++ SwigPartialIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PartialIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PartialIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_PartialIterator
    __del__ = lambda self : None;
    def atEnd(self):
        """
        atEnd(self) -> bool

        Return true if there are no more Breakpoints in the Partial.
        """
        return _loris.PartialIterator_atEnd(self)

    def next(self):
        """
        next(self) -> BreakpointPosition

        Return the next Breakpoint in the Partial that has not yet
        been returned by this iterator.
        """
        return _loris.PartialIterator_next(self)

PartialIterator_swigregister = _loris.PartialIterator_swigregister
PartialIterator_swigregister(PartialIterator)

class PartialList(_object):
    """
    A PartialList represents a collection of Bandwidth-Enhanced 
    Partials, each having a trio of synchronous, non-uniformly-
    sampled breakpoint envelopes representing the time-varying 
    frequency, amplitude, and noisiness of a single bandwidth-
    enhanced sinusoid.

    For more information about Bandwidth-Enhanced Partials and the  
    Reassigned Bandwidth-Enhanced Additive Sound Model, refer to
    the Loris website: www.cerlsoundgroup.org/Loris/
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PartialList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PartialList, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> PartialList
        __init__(self, rhs) -> PartialList

        Construct a new empty PartialList, or a PartialList
        that is a copy of another (containing identical copies
        of the Partials in another).
        """
        this = _loris.new_PartialList(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_PartialList
    __del__ = lambda self : None;
    def clear(self):
        """
        clear(self)

        Remove all the Partials from this PartialList.
        """
        return _loris.PartialList_clear(self)

    def size(self):
        """
        size(self) -> unsigned long

        Return the number of Partials in this PartialList.
        """
        return _loris.PartialList_size(self)

    def iterator(self):
        """
        iterator(self) -> PartialListIterator

        Return an iterator on the Partials in this PartialList.
        """
        return _loris.PartialList_iterator(self)

    def __iter__(self):
        """
        __iter__(self) -> PartialListIterator

        Return an iterator on the Partials in this PartialList.
        """
        return _loris.PartialList___iter__(self)

    def __len__(self):
        """
        __len__(self) -> unsigned long

        Return the number of Partials in this PartialList.
        """
        return _loris.PartialList___len__(self)

    def append(self, *args):
        """
        append(self, partial)
        append(self, other)

        Append a copy of a Partial, or copies of all the Partials in
        another PartialList, to this PartialList.
        """
        return _loris.PartialList_append(self, *args)

    def remove(self, *args):
        """
        remove(self, partial)

        Remove the specified Partial from this PartialList. An
        exception is raised if the specified Partial is not a member
        of this PartialList. The Partial itself must be a member, not
        merely identical to a Partial in this PartialList.
        """
        return _loris.PartialList_remove(self, *args)

    def first(self):
        """
        first(self) -> Partial

        Return the first Partial this PartialList, or 0 if this
        PartialList is empty.
        """
        return _loris.PartialList_first(self)

    def last(self):
        """
        last(self) -> Partial

        Return the last Partial this PartialList, or 0 if this
        PartialList is empty.
        """
        return _loris.PartialList_last(self)

    def copy(self):
        """
        copy(self) -> PartialList

        Construct a new a PartialList that is a copy of 
        another (containing identical copies of the Partials 
        in another). 

        This member is deprecated, use the normal copy constructor:
           plist_copy = PartialList( plist )

        """
        return _loris.PartialList_copy(self)

PartialList_swigregister = _loris.PartialList_swigregister
PartialList_swigregister(PartialList)

class Partial(_object):
    """
    A Partial represents a single component in the
    reassigned bandwidth-enhanced additive model. A Partial
    consists of a chain of Breakpoints describing the
    time-varying frequency, amplitude, and bandwidth (or
    noisiness) envelopes of the component, and a 4-byte
    label. The Breakpoints are non-uniformly distributed in
    time. For more information about Reassigned
    Bandwidth-Enhanced Analysis and the Reassigned
    Bandwidth-Enhanced Additive Sound Model, refer to the
    Loris website: 
        www.cerlsoundgroup.org/Loris/

    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Partial, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Partial, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> Partial
        __init__(self, arg0) -> Partial

        Construct a new empty Partial, having no Breakpoints,
        or a Partial that is a copy of another (containing
        identical of the Breakpoints in another).
        """
        this = _loris.new_Partial(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Partial
    __del__ = lambda self : None;
    def label(self):
        """
        label(self) -> int

        Return the label (an integer) for this Partial. The
        default label is 0.
        """
        return _loris.Partial_label(self)

    def initialPhase(self):
        """
        initialPhase(self) -> double

        Return the starting phase (in radians) for this
        Partial. An exception is raised if there are no
        Breakpoints in this Partial.
        """
        return _loris.Partial_initialPhase(self)

    def startTime(self):
        """
        startTime(self) -> double

        Return the time (in seconds) of the first Breakpoint in
        this Partial. An exception is raised if there are no
        Breakpoints in this Partial.
        """
        return _loris.Partial_startTime(self)

    def endTime(self):
        """
        endTime(self) -> double

        Return the time (in seconds) of the last Breakpoint in
        this Partial. An exception is raised if there are no
        Breakpoints in this Partial.
        """
        return _loris.Partial_endTime(self)

    def duration(self):
        """
        duration(self) -> double

        Return the difference in time (in seconds) between the 
        first and last Breakpoints in this Partial.
        """
        return _loris.Partial_duration(self)

    def numBreakpoints(self):
        """
        numBreakpoints(self) -> long

        Return the number of Breakpoints in this Partial.
        """
        return _loris.Partial_numBreakpoints(self)

    def setLabel(self, *args):
        """
        setLabel(self, l)

        Set the label (an integer) for this Partial. Unlabeled
        Partials have the default label of 0.
        """
        return _loris.Partial_setLabel(self, *args)

    def frequencyAt(self, *args):
        """
        frequencyAt(self, time) -> double

        Return the interpolated frequency (in Hz) of this
        Partial at the specified time in seconds. The frequency
        at times earlier than the first Breakpoint is the
        frequency of the first Breakpoint. The frequency at
        times later than the last Breakpoint is the frequency of
        the last Breakpoint. An exception is raised if there are
        no Breakpoints in this Partial.
        """
        return _loris.Partial_frequencyAt(self, *args)

    def amplitudeAt(self, *args):
        """
        amplitudeAt(self, time) -> double

        Return the interpolated amplitude of this Partial at
        the specified time in seconds. The amplitude at times
        earlier than the first Breakpoint and at times later
        than the last Breakpoint is zero. An exception is raised
        if there are no Breakpoints in this Partial.
        """
        return _loris.Partial_amplitudeAt(self, *args)

    def bandwidthAt(self, *args):
        """
        bandwidthAt(self, time) -> double

        Return the interpolated bandwidth (between 0 and 1) of
        this Partial at the specified time in seconds. The
        bandwidth at times earlier than the first Breakpoint and
        at times later than the last Breakpoint is zero. An
        exception is raised if there are no Breakpoints in this
        Partial.
        """
        return _loris.Partial_bandwidthAt(self, *args)

    def phaseAt(self, *args):
        """
        phaseAt(self, time) -> double

        Return the interpolated phase (in radians) of this
        Partial at the specified time in seconds. The phase at
        times earlier than the first Breakpoint is extrapolated
        from phase of the first Breakpoint assuming constant
        frequency. The phase at times later than the last
        Breakpoint is the extrapolated from the phase of the
        last Breakpoint assuming constant frequency. An
        exception is raised if there are no Breakpoints in this
        Partial.
        """
        return _loris.Partial_phaseAt(self, *args)

    def iterator(self, *args):
        """
        iterator(self) -> PartialIterator
        iterator(self, startHere) -> PartialIterator

        Return an iterator on the BreakpointPositions in this
        Partial. Optionally, specify the initial BreakpointPosition
        for the new iterator.
        """
        return _loris.Partial_iterator(self, *args)

    def __iter__(self):
        """
        __iter__(self) -> PartialIterator

        Return an iterator on the BreakpointPositions in this 
        Partial.
        """
        return _loris.Partial___iter__(self)

    def remove(self, *args):
        """
        remove(self, pos)

        Remove the specified Breakpoint from this Partial. An
        exception is raised if the specified Breakpoint is not a
        member of this Partial. The Breakpoint itself must be a
        member, not merely identical to a Breakpoint in this
        Partial.
        """
        return _loris.Partial_remove(self, *args)

    def first(self):
        """
        first(self) -> Breakpoint

        Return the first Breakpoint this Partial, or 0 if this
        Partial is empty.
        """
        return _loris.Partial_first(self)

    def last(self):
        """
        last(self) -> Breakpoint

        Return the last Breakpoint this Partial, or 0 if this
        Partial is empty.
        """
        return _loris.Partial_last(self)

    def insert(self, *args):
        """
        insert(self, time, bp)

        Insert a copy of the Breakpoint bp into this Partial at
        the specified time in seconds. Return nothing.
        """
        return _loris.Partial_insert(self, *args)

    def findAfter(self, *args):
        """
        findAfter(self, time) -> BreakpointPosition

        Return a BreakpointPosition positioned at
        the first Breakpoint in this Partial that is later than
        the specified time. The iterator might be at its end
        (return no more Breakpoints) if there are no Breakpoints
        in this Partial later than the specified time.
        """
        return _loris.Partial_findAfter(self, *args)

    def findNearest(self, *args):
        """
        findNearest(self, time) -> BreakpointPosition

        Return a BreakpointPosition positioned at
        the Breakpoint in this Partial that is nearest to the
        specified time.
        """
        return _loris.Partial_findNearest(self, *args)

Partial_swigregister = _loris.Partial_swigregister
Partial_swigregister(Partial)

class Breakpoint(_object):
    """
    A Breakpoint represents a single breakpoint in the
    time-varying frequency, amplitude, and bandwidth
    envelope of a Reassigned Bandwidth-Enhanced Partial.

    Instantaneous phase is also stored, but is only used at
    the onset of a partial, or when it makes a transition
    from zero to nonzero amplitude.

    A Partial represents a Reassigned Bandwidth-Enhanced
    model component. For more information about
    Bandwidth-Enhanced Partials and the Reassigned
    Bandwidth-Enhanced Additive Sound Model, refer to the
    Loris website:
        www.cerlsoundgroup.org/Loris/

    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Breakpoint, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Breakpoint, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, f, a, b, p = 0.) -> Breakpoint
        __init__(self, f, a, b) -> Breakpoint
        __init__(self, rhs) -> Breakpoint

        A Breakpoint represents a single breakpoint in the
        time-varying frequency, amplitude, and bandwidth
        envelope of a Reassigned Bandwidth-Enhanced Partial.

        Instantaneous phase is also stored, but is only used at
        the onset of a partial, or when it makes a transition
        from zero to nonzero amplitude.

        A Partial represents a Reassigned Bandwidth-Enhanced
        model component. For more information about
        Bandwidth-Enhanced Partials and the Reassigned
        Bandwidth-Enhanced Additive Sound Model, refer to the
        Loris website:
            www.cerlsoundgroup.org/Loris/

        """
        this = _loris.new_Breakpoint(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Breakpoint
    __del__ = lambda self : None;
    def frequency(self):
        """
        frequency(self) -> double

        Return the frequency (in Hz) of this Breakpoint.
        """
        return _loris.Breakpoint_frequency(self)

    def amplitude(self):
        """
        amplitude(self) -> double

        Return the amplitude (absolute) of this Breakpoint.
        """
        return _loris.Breakpoint_amplitude(self)

    def bandwidth(self):
        """
        bandwidth(self) -> double

        Return the bandwidth, or noisiness (0 to 1) of 
        this Breakpoint.
        """
        return _loris.Breakpoint_bandwidth(self)

    def phase(self):
        """
        phase(self) -> double

        Return the phase (in radians) of this Breakpoint.
        """
        return _loris.Breakpoint_phase(self)

    def setFrequency(self, *args):
        """
        setFrequency(self, x)

        Set the frequency (in Hz) of this Breakpoint.
        """
        return _loris.Breakpoint_setFrequency(self, *args)

    def setAmplitude(self, *args):
        """
        setAmplitude(self, x)

        Set the amplitude (absolute) of this Breakpoint.
        """
        return _loris.Breakpoint_setAmplitude(self, *args)

    def setBandwidth(self, *args):
        """
        setBandwidth(self, x)

        Set the bandwidth, or noisiness (0 to 1) of 
        this Breakpoint.
        """
        return _loris.Breakpoint_setBandwidth(self, *args)

    def setPhase(self, *args):
        """
        setPhase(self, x)

        Set the phase (in radians) of this Breakpoint.
        """
        return _loris.Breakpoint_setPhase(self, *args)

Breakpoint_swigregister = _loris.Breakpoint_swigregister
Breakpoint_swigregister(Breakpoint)

class BreakpointPosition(_object):
    """
    A BreakpointPosition represents the position of a 
    Breakpoint within a Partial.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BreakpointPosition, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BreakpointPosition, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_BreakpointPosition
    __del__ = lambda self : None;
    def time(self):
        """
        time(self) -> double

        Return the time (in seconds) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_time(self)

    def breakpoint(self):
        """
        breakpoint(self) -> Breakpoint

        Return the Breakpoint (not a copy!) at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_breakpoint(self)

    def frequency(self):
        """
        frequency(self) -> double

        Return the frequency (in Hz) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_frequency(self)

    def amplitude(self):
        """
        amplitude(self) -> double

        Return the amplitude (absolute) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_amplitude(self)

    def bandwidth(self):
        """
        bandwidth(self) -> double

        Return the bandwidth, or noisiness (0 to 1) of the
        Breakpoint at this BreakpointPosition.
        """
        return _loris.BreakpointPosition_bandwidth(self)

    def phase(self):
        """
        phase(self) -> double

        Return the phase (in radians) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_phase(self)

    def setFrequency(self, *args):
        """
        setFrequency(self, x)

        Set the frequency (in Hz) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_setFrequency(self, *args)

    def setAmplitude(self, *args):
        """
        setAmplitude(self, x)

        Set the amplitude (absolute) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_setAmplitude(self, *args)

    def setBandwidth(self, *args):
        """
        setBandwidth(self, x)

        Set the bandwidth, or noisiness (0 to 1) of the
        Breakpoint at this BreakpointPosition.
        """
        return _loris.BreakpointPosition_setBandwidth(self, *args)

    def setPhase(self, *args):
        """
        setPhase(self, x)

        Set the phase (in radians) of the Breakpoint at this
        BreakpointPosition.
        """
        return _loris.BreakpointPosition_setPhase(self, *args)

BreakpointPosition_swigregister = _loris.BreakpointPosition_swigregister
BreakpointPosition_swigregister(BreakpointPosition)

class F0Estimate(_object):
    """
    Represents a configuration of an iterative alrogithm for computing an 
    estimate of fundamental frequency from a sequence of sinusoidal
    frequencies and amplitudes using a likelihood estimator adapted
    from Quatieri's Speech Signal Processing text.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, F0Estimate, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, F0Estimate, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, amps, freqs, fmin, fmax, resolution) -> F0Estimate

        Construct from parameters of the iterative F0 estimation 
        algorithm. Find candidate F0 estimates as integer divisors
        of the peak frequencies, pick the highest frequency of the
        most likely candidates, and refine that estiamte using the
        secant method. 

        Store the frequency and the normalized value of the 
        likelihood function at that frequency (1.0 indicates that
        all the peaks are perfect harmonics of the estimated
        frequency).
        """
        this = _loris.new_F0Estimate(*args)
        try: self.this.append(this)
        except: self.this = this
    def frequency(self):
        """
        frequency(self) -> double

        Return the F0 frequency estimate, in Hz, for this estimate.
        """
        return _loris.F0Estimate_frequency(self)

    def confidence(self):
        """
        confidence(self) -> double

        Return the normalized confidence for this estimate, 
        equal to 1.0 when all frequencies are perfect
        harmonics of this estimate's frequency.
        """
        return _loris.F0Estimate_confidence(self)

    __swig_destroy__ = _loris.delete_F0Estimate
    __del__ = lambda self : None;
F0Estimate_swigregister = _loris.F0Estimate_swigregister
F0Estimate_swigregister(F0Estimate)

class FundamentalEstimator(_object):
    """
    Base class for fundamental estimation, common storage for member
    variable parameters, type definitions, and constants.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FundamentalEstimator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FundamentalEstimator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    DefaultAmpFloor = _loris.FundamentalEstimator_DefaultAmpFloor
    DefaultAmpRange = _loris.FundamentalEstimator_DefaultAmpRange
    DefaultFreqCeiling = _loris.FundamentalEstimator_DefaultFreqCeiling
    DefaultPrecisionOver100 = _loris.FundamentalEstimator_DefaultPrecisionOver100
    DefaultMinConfidencePct = _loris.FundamentalEstimator_DefaultMinConfidencePct
    def ampFloor(self):
        """
        ampFloor(self) -> double

        Return the absolute amplitude threshold in (negative) dB, 
        below which spectral peaks will not be considered in the 
        estimation of the fundamental (default is 30 dB).
        """
        return _loris.FundamentalEstimator_ampFloor(self)

    def ampRange(self):
        """
        ampRange(self) -> double

        Return the amplitude range in dB, 
        relative to strongest peak in a frame, floating
        amplitude threshold (negative) below which spectral
        peaks will not be considered in the estimation of 
        the fundamental (default is 30 dB).	
        """
        return _loris.FundamentalEstimator_ampRange(self)

    def freqCeiling(self):
        """
        freqCeiling(self) -> double

        Return the frequency ceiling in Hz, the
        frequency threshold above which spectral
        peaks will not be considered in the estimation of 
        the fundamental (default is 10 kHz).  
        """
        return _loris.FundamentalEstimator_freqCeiling(self)

    def precision(self):
        """
        precision(self) -> double

        Return the precision of the estimate in Hz, the
        fundamental frequency will be estimated to 
        within this range (default is 0.1 Hz).
        """
        return _loris.FundamentalEstimator_precision(self)

    def setAmpFloor(self, *args):
        """
        setAmpFloor(self, x)

        Set the absolute amplitude threshold in (negative) dB, 
        below which spectral peaks will not be considered i
        """
        return _loris.FundamentalEstimator_setAmpFloor(self, *args)

    def setAmpRange(self, *args):
        """
        setAmpRange(self, x)

        Set the amplitude range in dB, 
        relative to strongest peak in a frame, floating
        amplitude threshold (negative) below which spectral
        peaks will not be considered in the estimation of 
        the fundamental (default is 30 dB).	
        """
        return _loris.FundamentalEstimator_setAmpRange(self, *args)

    def setFreqCeiling(self, *args):
        """
        setFreqCeiling(self, x)

        Set the frequency ceiling in Hz, the
        frequency threshold above which spectral
        peaks will not be considered in the estimation of 
        the fundamental (default is 10 kHz). Must be
        greater than the lower bound.
        """
        return _loris.FundamentalEstimator_setFreqCeiling(self, *args)

    def setPrecision(self, *args):
        """
        setPrecision(self, x)

        Set the precision of the estimate in Hz, the
        fundamental frequency will be estimated to 
        within this range (default is 0.1 Hz)
        """
        return _loris.FundamentalEstimator_setPrecision(self, *args)

    __swig_destroy__ = _loris.delete_FundamentalEstimator
    __del__ = lambda self : None;
FundamentalEstimator_swigregister = _loris.FundamentalEstimator_swigregister
FundamentalEstimator_swigregister(FundamentalEstimator)

class FundamentalFromPartials(FundamentalEstimator):
    """
    Class FundamentalFromPartials represents an algorithm for 
    time-varying fundamental frequency estimation from instantaneous
    Partial amplitudes and frequencies based on a likelihood
    estimator adapted from Quatieri's Speech Signal Processing text.
    """
    __swig_setmethods__ = {}
    for _s in [FundamentalEstimator]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FundamentalFromPartials, name, value)
    __swig_getmethods__ = {}
    for _s in [FundamentalEstimator]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FundamentalFromPartials, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, precisionHz = FundamentalEstimator::DefaultPrecisionOver100*0.01) -> FundamentalFromPartials
        __init__(self) -> FundamentalFromPartials

        Construct a new estimator.

        The specified precision is used to terminate the iterative
        estimation procedure. If unspecified, the default value,
        DefaultPrecisionOver100 * 100 is used. 

        precisionHz is the precision in Hz with which the 
        fundamental estimates will be made.
        """
        this = _loris.new_FundamentalFromPartials(*args)
        try: self.this.append(this)
        except: self.this = this
    def buildEnvelope(self, *args):
        """
        buildEnvelope(self, partials, tbeg, tend, interval, lowerFreqBound, upperFreqBound, 
            confidenceThreshold) -> LinearEnvelope

        Construct a linear envelope from fundamental frequency 
        estimates taken at the specified interval in seconds 
        starting at tbeg (seconds) and ending before tend (seconds).

        	partials is the sequence of Partials
        	
        	tbeg is the beginning of the time interval (in seconds)
        	
        	tend is the end of the time interval (in seconds)
        	
        	interval is the time between breakpoints in the
        	fundamental frequency envelope (in seconds)
        	
        	lowerFreqBound is the lower bound on the fundamental
        	frequency estimate (in Hz)
        	
        	upperFreqBound is the lower bound on the fundamental
        	frequency estimate (in Hz)
        	
        	confidenceThreshold is the minimum confidence level
        	resuired for a fundamental frequency estimate to be
        	added to the envelope. Lower confidence estimates are
        	not added, the envelope returned will not contain
        	breakpoints at times associated with low confidence 
        	estimates
        	
        	Returns a LinearEnvelope composed of breakpoints corresponding to
        	the fundamental frequency estimates at samples of the span
        	tbeg to tend at the specified sampling interval, only estimates
        	having confidence level exceeding the specified confidence
        	threshold are added to the envelope

        """
        return _loris.FundamentalFromPartials_buildEnvelope(self, *args)

    def estimateAt(self, *args):
        """
        estimateAt(self, partials, time, lowerFreqBound, upperFreqBound) -> value_type

        Return an estimate of the fundamental frequency computed 
        at the specified time. The F0Estimate returned stores the
        estimate of the fundamental frequency (in Hz) and the 
        relative confidence (from 0 to 1) associated with that
        estimate.

        	partials is the sequence of Partials
        	
        	time is the time in seconds at which to attempt to estimate
        	the fundamental frequency
        	
        	lowerFreqBound is the lower bound on the fundamental
        	frequency estimate (in Hz)

        	upperFreqBound is the lower bound on the fundamental
        	frequency estimate (in Hz)
        	
        	Return the estimate of fundamental frequency in Hz and the 
        	confidence associated with that estimate (see 
        	F0Estimate.h)

        """
        return _loris.FundamentalFromPartials_estimateAt(self, *args)

    __swig_destroy__ = _loris.delete_FundamentalFromPartials
    __del__ = lambda self : None;
FundamentalFromPartials_swigregister = _loris.FundamentalFromPartials_swigregister
FundamentalFromPartials_swigregister(FundamentalFromPartials)

class FundamentalFromSamples(FundamentalEstimator):
    """
    Class FundamentalFromSamples represents an algorithm for 
    time-varying fundamental frequency estimation based on
    time-frequency reassigned spectral analysis of a sequence
    of samples. This class is adapted from the Analyzer class 
    (see Analyzer.h), and performs the same spectral analysis 
    and peak extraction, but does not form Partials.

    For more information about Reassigned Bandwidth-Enhanced 
    Analysis and the Reassigned Bandwidth-Enhanced Additive Sound 
    Model, refer to the Loris website: www.cerlsoundgroup.org/Loris/.
    """
    __swig_setmethods__ = {}
    for _s in [FundamentalEstimator]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FundamentalFromSamples, name, value)
    __swig_getmethods__ = {}
    for _s in [FundamentalEstimator]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FundamentalFromSamples, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, winWidthHz, precisionHz = FundamentalEstimator::DefaultPrecisionOver100*0.01) -> FundamentalFromSamples
        __init__(self, winWidthHz) -> FundamentalFromSamples

        Construct a new estimator configured with the given  
        analysis window width (main lobe, zero-to-zero). All other 
        spectrum analysis parameters are computed from the specified 
        window width. 

        The specified precision is used to terminate the iterative
        estimation procedure. If unspecified, the default value,
        DefaultPrecisionOver100 * 100 is used. 

        	windowWidthHz is the main lobe width of the Kaiser
        	analysis window in Hz.

        	precisionHz is the precision in Hz with which the 
        	fundamental estimates will be made.

        """
        this = _loris.new_FundamentalFromSamples(*args)
        try: self.this.append(this)
        except: self.this = this
    def buildEnvelope(self, *args):
        """
        buildEnvelope(self, samps, sampleRate, tbeg, tend, interval, lowerFreqBound, 
            upperFreqBound, confidenceThreshold) -> LinearEnvelope

        Construct a linear envelope from fundamental frequency 
        estimates taken at the specified interval in seconds
        starting at tbeg (seconds) and ending before tend (seconds).

        	samps is the sequence of samples
        	
        	sampleRate is the sampling rate (in Hz) associated
        	with the sequence of samples (used to compute frequencies
        	in Hz, and to convert the time from seconds to samples)

        	tbeg is the beginning of the time interval (in seconds)

        	tend is the end of the time interval (in seconds)

        	interval is the time between breakpoints in the
        	fundamental frequency envelope (in seconds)
        	
        	lowerFreqBound is the lower bound on the fundamental
        	frequency estimate (in Hz)

        	upperFreqBound is the lower bound on the fundamental
        	frequency estimate (in Hz)

        	confidenceThreshold is the minimum confidence level
        	resuired for a fundamental frequency estimate to be
        	added to the envelope. Lower confidence estimates are
        	not added, the envelope returned will not contain
        	breakpoints at times associated with low confidence 
        	estimates

        	Returns a LinearEnvelope composed of breakpoints corresponding to
        	the fundamental frequency estimates at samples of the span
        	tbeg to tend at the specified sampling interval, only estimates
        	having confidence level exceeding the specified confidence
        	threshold are added to the envelope    

        """
        return _loris.FundamentalFromSamples_buildEnvelope(self, *args)

    def estimateAt(self, *args):
        """
        estimateAt(self, samps, sampleRate, time, lowerFreqBound, upperFreqBound) -> value_type

        Return an estimate of the fundamental frequency computed 
        at the specified time. The F0Estimate returned stores the
        estimate of the fundamental frequency (in Hz) and the 
        relative confidence (from 0 to 1) associated with that
        estimate.

        	samps is the sequence of samples

        	sampleRate is the sampling rate (in Hz) associated
        	with the sequence of samples (used to compute frequencies
        	in Hz, and to convert the time from seconds to samples)

        	time is the time in seconds at which to attempt to estimate
        	the fundamental frequency

        	lowerFreqBound is the lower bound on the fundamental
        	frequency estimate (in Hz)

        	upperFreqBound is the lower bound on the fundamental
        	frequency estimate (in Hz)

        	Returns the estimate of fundamental frequency in Hz and the 
        	confidence associated with that estimate (see 
        	F0Estimate.h)

        """
        return _loris.FundamentalFromSamples_estimateAt(self, *args)

    def windowWidth(self):
        """
        windowWidth(self) -> double

        Return the frequency-domain main lobe width (in Hz measured 
        between zero-crossings) of the analysis window used in spectral
        analysis.
        """
        return _loris.FundamentalFromSamples_windowWidth(self)

    def setWindowWidth(self, *args):
        """
        setWindowWidth(self, w)

        Set the frequency-domain main lobe width (in Hz measured 
        between zero-crossings) of the analysis window used in spectral
        analysis.
        """
        return _loris.FundamentalFromSamples_setWindowWidth(self, *args)

    __swig_destroy__ = _loris.delete_FundamentalFromSamples
    __del__ = lambda self : None;
FundamentalFromSamples_swigregister = _loris.FundamentalFromSamples_swigregister
FundamentalFromSamples_swigregister(FundamentalFromSamples)

class Envelope(_object):
    """
    Envelope is an abstract base class for all time-varying envelopes
    and parameters, representing a single-valued funtion of one variable
    (usually time).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Envelope, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Envelope, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def Envelope(self, *args):
        """
        Envelope(self, other) -> Envelope

        Envelope is an abstract base class for all time-varying envelopes
        and parameters, representing a single-valued funtion of one variable
        (usually time).
        """
        return _loris.Envelope_Envelope(self, *args)

    __swig_destroy__ = _loris.delete_Envelope
    __del__ = lambda self : None;
Envelope_swigregister = _loris.Envelope_swigregister
Envelope_swigregister(Envelope)

class LinearEnvelope(Envelope):
    """
    A LinearEnvelope represents a linear segment breakpoint 
    function with infinite extension at each end (that is, the 
    values past either end of the breakpoint function have the 
    values at the nearest end).
    """
    __swig_setmethods__ = {}
    for _s in [Envelope]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearEnvelope, name, value)
    __swig_getmethods__ = {}
    for _s in [Envelope]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearEnvelope, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> LinearEnvelope
        __init__(self, arg0) -> LinearEnvelope
        __init__(self, initialValue) -> LinearEnvelope

        Construct and return a new LinearEnvelope, empty,
        or having a single breakpoint at time 0 with the 
        specified value.

        An LinearEnvelope can also be copied from another
        instance.
        """
        this = _loris.new_LinearEnvelope(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_LinearEnvelope
    __del__ = lambda self : None;
    def insertBreakpoint(self, *args):
        """
        insertBreakpoint(self, time, value)

        Insert a new breakpoint into the envelope at the specified
        time and value.
        """
        return _loris.LinearEnvelope_insertBreakpoint(self, *args)

    def insert(self, *args):
        """
        insert(self, time, value)

        Insert a new breakpoint into the envelope at the specified
        time and value.
        """
        return _loris.LinearEnvelope_insert(self, *args)

    def valueAt(self, *args):
        """
        valueAt(self, x) -> double

        Return the (linearly-interpolated) value of the envelope
        at the specified time.
        """
        return _loris.LinearEnvelope_valueAt(self, *args)

    def size(self):
        """
        size(self) -> unsigned int

        Return the number of breakpoints in this LinearEnvelope.
        """
        return _loris.LinearEnvelope_size(self)

    def __iadd__(self, *args):
        """
        __iadd__(self, offset) -> LinearEnvelope

        Add a constant value to this LinearEnvelope and return a reference
        to self.
        """
        return _loris.LinearEnvelope___iadd__(self, *args)

    def __isub__(self, *args):
        """
        __isub__(self, offset) -> LinearEnvelope

        Subtract a constant value from this LinearEnvelope and return a reference
        to self.
        """
        return _loris.LinearEnvelope___isub__(self, *args)

    def __imul__(self, *args):
        """
        __imul__(self, scale) -> LinearEnvelope

        Scale this LinearEnvelope by a constant value and return a reference
        to self.
        """
        return _loris.LinearEnvelope___imul__(self, *args)

    def __idiv__(self, *args):
        """__idiv__(self, div) -> LinearEnvelope"""
        return _loris.LinearEnvelope___idiv__(self, *args)

    def __add__(self, *args):
        """
        __add__(self, offset) -> LinearEnvelope
        __add__(self, rhs) -> LinearEnvelope

        Add a constant value or a LinearEnvelope to this LinearEnvelope 
        and return a new LinearEnvelope.
        """
        return _loris.LinearEnvelope___add__(self, *args)

    def __sub__(self, *args):
        """
        __sub__(self, offset) -> LinearEnvelope
        __sub__(self, rhs) -> LinearEnvelope
        """
        return _loris.LinearEnvelope___sub__(self, *args)

    def __mul__(self, *args):
        """
        __mul__(self, scale) -> LinearEnvelope

        Scale a LinearEnvelope by a constant value and return a new 
        LinearEnvelope.
        """
        return _loris.LinearEnvelope___mul__(self, *args)

    def __div__(self, *args):
        """
        __div__(self, div) -> LinearEnvelope

        Divide a LinearEnvelope by a constant value and return a new 
        LinearEnvelope.
        """
        return _loris.LinearEnvelope___div__(self, *args)

    def iterator(self, *args):
        """
        iterator(self) -> LinearEnvelopeIterator
        iterator(self, startHere) -> LinearEnvelopeIterator

        Return an iterator on the positions in this
        LinearEnvelope. Optionally, specify the initial position
        for the new iterator.
        """
        return _loris.LinearEnvelope_iterator(self, *args)

    def __iter__(self):
        """
        __iter__(self) -> LinearEnvelopeIterator

        Return an iterator on the positions in this 
        LinearEnvelope.
        """
        return _loris.LinearEnvelope___iter__(self)

LinearEnvelope_swigregister = _loris.LinearEnvelope_swigregister
LinearEnvelope_swigregister(LinearEnvelope)

class LinearEnvelopePosition(_object):
    """
    A LinearEnvelopePosition represents a breakpoint, a value
    associated with a particular time in a LinearEnvelope.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearEnvelopePosition, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LinearEnvelopePosition, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_LinearEnvelopePosition
    __del__ = lambda self : None;
    def time(self):
        """
        time(self) -> double

        Return the time (in seconds) of the corresponding to this
        LinearEnvelopePosition.
        """
        return _loris.LinearEnvelopePosition_time(self)

    def value(self):
        """
        value(self) -> double

        Return the value (arbitrary units) associated with this
        LinearEnvelopePosition.
        """
        return _loris.LinearEnvelopePosition_value(self)

    def setValue(self, *args):
        """
        setValue(self, x)

        Assign the value (arbitrary units) associated with this
        LinearEnvelopePosition.
        """
        return _loris.LinearEnvelopePosition_setValue(self, *args)

LinearEnvelopePosition_swigregister = _loris.LinearEnvelopePosition_swigregister
LinearEnvelopePosition_swigregister(LinearEnvelopePosition)

class LinearEnvelopeIterator(_object):
    """
    An iterator over a LinearEnvelope. Access time-value pairs
    in a LinearEnvelope by invoking next until atEnd 
    returns true.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearEnvelopeIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LinearEnvelopeIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _loris.delete_LinearEnvelopeIterator
    __del__ = lambda self : None;
    def atEnd(self):
        """
        atEnd(self) -> bool

        Return true if there are no more time-value pairs in the LinearEnvelope.
        """
        return _loris.LinearEnvelopeIterator_atEnd(self)

    def next(self):
        """
        next(self) -> LinearEnvelopePosition

        Return the next time-value pair in the LinearEnvelope that has not yet
        been returned by this iterator.
        """
        return _loris.LinearEnvelopeIterator_next(self)

LinearEnvelopeIterator_swigregister = _loris.LinearEnvelopeIterator_swigregister
LinearEnvelopeIterator_swigregister(LinearEnvelopeIterator)


def BreakpointEnvelopeWithValue(*args):
  """
    BreakpointEnvelopeWithValue(initialValue) -> LinearEnvelope

    BreakpointEnvelopeWithValue is deprecated, use LinearEnvelope instead.
    """
  return _loris.BreakpointEnvelopeWithValue(*args)
class SynthesisParameters(_object):
    """
    Access to Loris bandwidth-enhanced sinusoidal synthesis parameters. 
    Parameters assigned here are the default parameters used in Loris 
    synthesis. Some functions allow these parameters to be overridden
    (see e.g. loris.synthesize).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SynthesisParameters, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SynthesisParameters, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def fadeTime():
        """
        fadeTime() -> double

        Return the Loris Synthesizer's Partial fade time, in seconds.
        """
        return _loris.SynthesisParameters_fadeTime()

    if _newclass:fadeTime = staticmethod(fadeTime)
    __swig_getmethods__["fadeTime"] = lambda x: fadeTime
    def setFadeTime(*args):
        """
        setFadeTime(t)

        Set the Loris Synthesizer's fade time to the specified value 
        (in seconds, must be non-negative).

        	t is the new Partial fade time in seconds.

        """
        return _loris.SynthesisParameters_setFadeTime(*args)

    if _newclass:setFadeTime = staticmethod(setFadeTime)
    __swig_getmethods__["setFadeTime"] = lambda x: setFadeTime
    def sampleRate():
        """
        sampleRate() -> double

        Return the sampling rate (in Hz) for the Loris Synthesizer.
        """
        return _loris.SynthesisParameters_sampleRate()

    if _newclass:sampleRate = staticmethod(sampleRate)
    __swig_getmethods__["sampleRate"] = lambda x: sampleRate
    def setSampleRate(*args):
        """
        setSampleRate(rate)

        Set the Loris Synthesizer's sample rate to the specified value 
        (in Hz, must be positive).

        	rate is the new synthesis sample rate.

        """
        return _loris.SynthesisParameters_setSampleRate(*args)

    if _newclass:setSampleRate = staticmethod(setSampleRate)
    __swig_getmethods__["setSampleRate"] = lambda x: setSampleRate
    def filterCoefsNumerator():
        """
        filterCoefsNumerator() -> DoubleVector

        Return the numerator coefficients in the filter used by the Loris 
        Synthesizer in bandwidth-enhanced sinusoidal synthesis.
        """
        return _loris.SynthesisParameters_filterCoefsNumerator()

    if _newclass:filterCoefsNumerator = staticmethod(filterCoefsNumerator)
    __swig_getmethods__["filterCoefsNumerator"] = lambda x: filterCoefsNumerator
    def filterCoefsDenominator():
        """
        filterCoefsDenominator() -> DoubleVector

        Return the denominator coefficients in the filter used by the Loris 
        Synthesizer in bandwidth-enhanced sinusoidal synthesis.
        """
        return _loris.SynthesisParameters_filterCoefsDenominator()

    if _newclass:filterCoefsDenominator = staticmethod(filterCoefsDenominator)
    __swig_getmethods__["filterCoefsDenominator"] = lambda x: filterCoefsDenominator
    def setFilterCoefs(*args):
        """
        setFilterCoefs(num, den)

        Set the coefficients in the filter used by the Loris 
        Synthesizer in bandwidth-enhanced sinusoidal synthesis.

            num is the new numerator coefficients
            den is the new denominator coefficients
            
        The zeroeth denominator coefficient must be non-zero. If it is not
        equal to 1.0, all the other coefficients are scaled by its inverse.

        """
        return _loris.SynthesisParameters_setFilterCoefs(*args)

    if _newclass:setFilterCoefs = staticmethod(setFilterCoefs)
    __swig_getmethods__["setFilterCoefs"] = lambda x: setFilterCoefs
SynthesisParameters_swigregister = _loris.SynthesisParameters_swigregister
SynthesisParameters_swigregister(SynthesisParameters)

def BreakpointEnvelope(*args):
  """
    BreakpointEnvelope() -> LinearEnvelope
    BreakpointEnvelope(rhs) -> LinearEnvelope
    BreakpointEnvelope(initialValue) -> LinearEnvelope

    BreakpointEnvelope is deprecated, use LinearEnvelope instead.
    """
  return _loris.BreakpointEnvelope(*args)

def SynthesisParameters_fadeTime():
  """
    SynthesisParameters_fadeTime() -> double

    Return the Loris Synthesizer's Partial fade time, in seconds.
    """
  return _loris.SynthesisParameters_fadeTime()

def SynthesisParameters_setFadeTime(*args):
  """
    SynthesisParameters_setFadeTime(t)

    Set the Loris Synthesizer's fade time to the specified value 
    (in seconds, must be non-negative).

    	t is the new Partial fade time in seconds.

    """
  return _loris.SynthesisParameters_setFadeTime(*args)

def SynthesisParameters_sampleRate():
  """
    SynthesisParameters_sampleRate() -> double

    Return the sampling rate (in Hz) for the Loris Synthesizer.
    """
  return _loris.SynthesisParameters_sampleRate()

def SynthesisParameters_setSampleRate(*args):
  """
    SynthesisParameters_setSampleRate(rate)

    Set the Loris Synthesizer's sample rate to the specified value 
    (in Hz, must be positive).

    	rate is the new synthesis sample rate.

    """
  return _loris.SynthesisParameters_setSampleRate(*args)

def SynthesisParameters_filterCoefsNumerator():
  """
    SynthesisParameters_filterCoefsNumerator() -> DoubleVector

    Return the numerator coefficients in the filter used by the Loris 
    Synthesizer in bandwidth-enhanced sinusoidal synthesis.
    """
  return _loris.SynthesisParameters_filterCoefsNumerator()

def SynthesisParameters_filterCoefsDenominator():
  """
    SynthesisParameters_filterCoefsDenominator() -> DoubleVector

    Return the denominator coefficients in the filter used by the Loris 
    Synthesizer in bandwidth-enhanced sinusoidal synthesis.
    """
  return _loris.SynthesisParameters_filterCoefsDenominator()

def SynthesisParameters_setFilterCoefs(*args):
  """
    SynthesisParameters_setFilterCoefs(num, den)

    Set the coefficients in the filter used by the Loris 
    Synthesizer in bandwidth-enhanced sinusoidal synthesis.

        num is the new numerator coefficients
        den is the new denominator coefficients
        
    The zeroeth denominator coefficient must be non-zero. If it is not
    equal to 1.0, all the other coefficients are scaled by its inverse.

    """
  return _loris.SynthesisParameters_setFilterCoefs(*args)

class Channelizer(_object):
    """
    Class Channelizer represents an algorithm for automatic labeling of
    a sequence of Partials. Partials must be labeled in
    preparation for morphing (see Morpher) to establish correspondences
    between Partials in the morph source and target sounds. 

    Channelized partials are labeled according to their adherence to a
    harmonic frequency structure with a time-varying fundamental
    frequency. The frequency spectrum is partitioned into
    non-overlapping channels having time-varying center frequencies that
    are harmonic (integer) multiples of a specified reference frequency
    envelope, and each channel is identified by a unique label equal to
    its harmonic number. Each Partial is assigned the label
    corresponding to the channel containing the greatest portion of its
    (the Partial's) energy. 

    A reference frequency Envelope for channelization and the channel
    number to which it corresponds (1 for an Envelope that tracks the
    Partial at the fundamental frequency) must be specified. The
    reference Envelope can be constructed explcitly, point by point
    (using, for example, the BreakpointEnvelope class), or constructed
    automatically using the FrequencyReference class. 

    The Channelizer can be configured with a stretch factor, to accomodate
    detuned harmonics, as in the case of piano tones. The static member
    computeStretchFactor can compute the apppropriate stretch factor, given
    a pair of partials. This computation is based on formulae given in 
    'Understanding the complex nature of the piano tone' by Martin Keane
    at the Acoustics Research Centre at the University of Aukland (Feb 2004).
    The stretching factor must be non-negative (and is zero for perfectly
    tunes harmonics). Even in the case of stretched harmonics, the
    reference frequency envelope is assumed to track the frequency of
    one of the partials, and the center frequency of the corresponding
    channel, even though it may represent a stretched harmonic.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Channelizer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Channelizer, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, refChanFreq, refChanLabel, stretchFactor = 0) -> Channelizer
        __init__(self, refChanFreq, refChanLabel) -> Channelizer
        __init__(self, refFreq, stretchFactor = 0) -> Channelizer
        __init__(self, refFreq) -> Channelizer

        Construct a new Channelizer having a constant reference frequency.
        The specified frequency is the center frequency of the lowest-frequency
        channel (for a harmonic sound, the channel containing the fundamental 
        Partial.

            refFreq is the reference frequency (in Hz) corresponding
            to the first frequency channel.
          
            stretchFactor is a stretching factor to account for detuned 
            harmonics, default is 0. 

        """
        this = _loris.new_Channelizer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _loris.delete_Channelizer
    __del__ = lambda self : None;
    def channelize(self, *args):
        """
        channelize(self, partial)
        channelize(self, partials)

        Assign each Partial in the specified half-open (STL-style) range
        the label corresponding to the frequency channel containing the
        greatest portion of its (the Partial's) energy.

            partials is the list of Partials to channelize

        """
        return _loris.Channelizer_channelize(self, *args)

    def channelFrequencyAt(self, *args):
        """
        channelFrequencyAt(self, time, channel) -> double

        Compute the center frequency of one a channel at the specified
        time. For non-stretched harmonics, this is simply the value
        of the reference envelope scaled by the ratio of the specified
        channel number to the reference channel number. For stretched
        harmonics, the channel center frequency is computed using the
        stretch factor. See Martin Keane, 'Understanding
        the complex nature of the piano tone', 2004, for a discussion
        and the source of the mode frequency stretching algorithms 
        implemented here.

            time is the time (in seconds) at which to evalute 
            the reference envelope

            channel is the frequency channel (or harmonic, or vibrational     
            mode) number whose frequency is to be determined
            
            Returns the center frequency in Hz of the specified frequency channel
            at the specified time

        """
        return _loris.Channelizer_channelFrequencyAt(self, *args)

    def computeChannelNumber(self, *args):
        """
        computeChannelNumber(self, time, frequency) -> int

        Compute the (fractional) channel number estimate for a Partial having a
        given frequency at a specified time. For ordinary harmonics, this
        is simply the ratio of the specified frequency to the reference
        frequency at the specified time. For stretched harmonics (as in 
        a piano), the stretching factor is used to compute the frequency
        of the corresponding modes of a massy string. See Martin Keane, 
        'Understanding the complex nature of the piano tone', 2004, for 
        the source of the mode frequency stretching algorithms 
        implemented here.

            time is the time (in seconds) at which to evalute 
            the reference envelope
            
            frequency is the frequency (in Hz) for wihch the channel
            number is to be determined

            returns the channel number corresponding to the specified
            frequency and time

        """
        return _loris.Channelizer_computeChannelNumber(self, *args)

    def computeFractionalChannelNumber(self, *args):
        """
        computeFractionalChannelNumber(self, time, frequency) -> double

        Compute the (fractional) channel number estimate for a Partial having a
        given frequency at a specified time. For ordinary harmonics, this
        is simply the ratio of the specified frequency to the reference
        frequency at the specified time. For stretched harmonics (as in 
        a piano), the stretching factor is used to compute the frequency
        of the corresponding modes of a massy string. See Martin Keane, 
        'Understanding the complex nature of the piano tone', 2004, for 
        the source of the mode frequency stretching algorithms 
        implemented here.

        The fractional channel number is used internally to determine
        a best estimate for the channel number (label) for a Partial
        having time-varying frequency. 

            time is the time (in seconds) at which to evalute 
            the reference envelope

            frequency is the frequency (in Hz) for wihch the channel
            number is to be determined

            returns the fractional channel number corresponding to the specified
            frequency and time

        """
        return _loris.Channelizer_computeFractionalChannelNumber(self, *args)

    def referenceFrequencyAt(self, *args):
        """
        referenceFrequencyAt(self, time) -> double

        Compute the reference frequency at the specified time. For non-stretched 
        harmonics, this is simply the ratio of the reference envelope evaluated 
        at that time to the reference channel number, and is the center frequecy
        for the lowest channel. For stretched harmonics, the reference frequency 
        is NOT equal to the center frequency of any of the channels, and is also
        a function of the stretch factor. 

            time is the time (in seconds) at which to evalute 
            the reference envelope

        """
        return _loris.Channelizer_referenceFrequencyAt(self, *args)

    def amplitudeWeighting(self):
        """
        amplitudeWeighting(self) -> double

        Return the exponent applied to amplitude before weighting
        the instantaneous estimate of the frequency channel number
        for a Partial. zero (default) for no weighting, 1 for linear
        amplitude weighting, 2 for power weighting, etc.
        Amplitude weighting is a bad idea for many sounds, particularly
        those with transients, for which it may emphasize the part of
        the Partial having the least reliable frequency estimate.

        """
        return _loris.Channelizer_amplitudeWeighting(self)

    def setAmplitudeWeighting(self, *args):
        """
        setAmplitudeWeighting(self, expon)

        Set the exponent applied to amplitude before weighting
        the instantaneous estimate of the frequency channel number
        for a Partial. zero (default) for no weighting, 1 for linear
        amplitude weighting, 2 for power weighting, etc.
        Amplitude weighting is a bad idea for many sounds, particularly
        those with transients, for which it may emphasize the part of
        the Partial having the least reliable frequency estimate.

        """
        return _loris.Channelizer_setAmplitudeWeighting(self, *args)

    def stretchFactor(self):
        """
        stretchFactor(self) -> double

        Return the stretching factor used to account for detuned
        harmonics, as in a piano tone. Normally set to 0 for 
        in-tune harmonics.

        The stretching factor is a small positive number for 
        heavy vibrating strings (as in pianos) for which the
        mass of the string significantly affects the frequency
        of the vibrating modes. See Martin Keane, 'Understanding
        the complex nature of the piano tone', 2004, for a discussion
        and the source of the mode frequency stretching algorithms 
        implemented here.

        """
        return _loris.Channelizer_stretchFactor(self)

    def setStretchFactor(self, *args):
        """
        setStretchFactor(self, stretch)

        Set the stretching factor used to account for detuned
        harmonics, as in a piano tone. Normally set to 0 for 
        in-tune harmonics. The stretching factor for massy 
        vibrating strings (like pianos) can be computed from 
        the physical characteristics of the string, or using 
        computeStretchFactor(). 

        The stretching factor is a small positive number for 
        heavy vibrating strings (as in pianos) for which the
        mass of the string significantly affects the frequency
        of the vibrating modes. See Martin Keane, 'Understanding
        the complex nature of the piano tone', 2004, for a discussion
        and the source of the mode frequency stretching algorithms 
        implemented here.

        """
        return _loris.Channelizer_setStretchFactor(self, *args)

    def computeStretchFactor(*args):
        """
        computeStretchFactor(fm, m, fn, n) -> double

        the stretching factor used to account for (consistently) 
        detuned harmonics, as in a piano tone, from a pair of 
        mode (harmonic) frequencies and numbers.

        The stretching factor is a small positive number for 
        heavy vibrating strings (as in pianos) for which the
        mass of the string significantly affects the frequency
        of the vibrating modes. See Martin Keane, 'Understanding
        the complex nature of the piano tone', 2004, for a discussion
        and the source of the mode frequency stretching algorithms 
        implemented here.

        The stretching factor is computed using computeStretchFactor,
        but only a valid stretch factor will ever be assigned. If an
        invalid (negative) stretching factor is computed for the
        specified frequencies and mode numbers, the stretch factor
        will be set to zero.

            fm is the frequency of the Mth stretched harmonic

            m is the harmonic number of the harmonic whose frequnecy is fm

            fn is the frequency of the Nth stretched harmonic

            n is the harmonic number of the harmonic whose frequnecy is fn
            
            returns    the stretching factor, usually a very small positive
            floating point number, or 0 for pefectly tuned harmonics
            (that is, if fn = n*f1).
            
            Use as argument to Channelizer.setStretchFactor()


        """
        return _loris.Channelizer_computeStretchFactor(*args)

    if _newclass:computeStretchFactor = staticmethod(computeStretchFactor)
    __swig_getmethods__["computeStretchFactor"] = lambda x: computeStretchFactor
Channelizer_swigregister = _loris.Channelizer_swigregister
Channelizer_swigregister(Channelizer)

def synthesize(*args):
  """
    synthesize(partials, srate) -> DoubleVector
    synthesize(partials) -> DoubleVector

    Synthesize Partials in a PartialList at the given sample rate, and
    return the (floating point) samples in a vector. The vector is
    sized to hold as many samples as are needed for the complete
    synthesis of all the Partials in the PartialList. 

    If the sample rate is unspecified, the sample rate in the default 
    SynthesisParameters is used. (See loris.SynthesisParameters.)
    """
  return _loris.synthesize(*args)

def Channelizer_computeStretchFactor(*args):
  """
    Channelizer_computeStretchFactor(fm, m, fn, n) -> double

    the stretching factor used to account for (consistently) 
    detuned harmonics, as in a piano tone, from a pair of 
    mode (harmonic) frequencies and numbers.

    The stretching factor is a small positive number for 
    heavy vibrating strings (as in pianos) for which the
    mass of the string significantly affects the frequency
    of the vibrating modes. See Martin Keane, 'Understanding
    the complex nature of the piano tone', 2004, for a discussion
    and the source of the mode frequency stretching algorithms 
    implemented here.

    The stretching factor is computed using computeStretchFactor,
    but only a valid stretch factor will ever be assigned. If an
    invalid (negative) stretching factor is computed for the
    specified frequencies and mode numbers, the stretch factor
    will be set to zero.

        fm is the frequency of the Mth stretched harmonic

        m is the harmonic number of the harmonic whose frequnecy is fm

        fn is the frequency of the Nth stretched harmonic

        n is the harmonic number of the harmonic whose frequnecy is fn
        
        returns    the stretching factor, usually a very small positive
        floating point number, or 0 for pefectly tuned harmonics
        (that is, if fn = n*f1).
        
        Use as argument to Channelizer.setStretchFactor()


    """
  return _loris.Channelizer_computeStretchFactor(*args)



