config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
for file in etc/cups/*.new ; do
  config $file
done
config etc/dbus-1/system.d/cups.conf.new

# Leave any new rc.cups with the same permissions as the old one:
# This is a kludge, but it's because there's no --reference option
# on busybox's 'chmod':
if [ -e etc/rc.d/rc.cups ]; then
  if [ -x etc/rc.d/rc.cups ]; then
    chmod 755 etc/rc.d/rc.cups.new
  else
    chmod 644 etc/rc.d/rc.cups.new
  fi
fi
# Then config() it:
config etc/rc.d/rc.cups.new
( cd usr/bin ; rm -rf lp )
( cd usr/bin ; ln -sf lp-cups lp )
( cd usr/bin ; rm -rf lpq )
( cd usr/bin ; ln -sf lpq-cups lpq )
( cd usr/bin ; rm -rf lpr )
( cd usr/bin ; ln -sf lpr-cups lpr )
( cd usr/bin ; rm -rf lprm )
( cd usr/bin ; ln -sf lprm-cups lprm )
( cd usr/bin ; rm -rf cancel )
( cd usr/bin ; ln -sf cancel-cups cancel )
( cd usr/bin ; rm -rf lpstat )
( cd usr/bin ; ln -sf lpstat-cups lpstat )
( cd usr/doc ; rm -rf cups )
( cd usr/doc ; ln -sf cups-1.3.9 cups )
( cd usr/man/man1 ; rm -rf lp.1.gz )
( cd usr/man/man1 ; ln -sf lp-cups.1.gz lp.1.gz )
( cd usr/man/man1 ; rm -rf lprm.1.gz )
( cd usr/man/man1 ; ln -sf lprm-cups.1.gz lprm.1.gz )
( cd usr/man/man1 ; rm -rf cancel.1.gz )
( cd usr/man/man1 ; ln -sf cancel-cups.1.gz cancel.1.gz )
( cd usr/man/man1 ; rm -rf lpstat.1.gz )
( cd usr/man/man1 ; ln -sf lpstat-cups.1.gz lpstat.1.gz )
( cd usr/man/man1 ; rm -rf lpq.1.gz )
( cd usr/man/man1 ; ln -sf lpq-cups.1.gz lpq.1.gz )
( cd usr/man/man1 ; rm -rf lpr.1.gz )
( cd usr/man/man1 ; ln -sf lpr-cups.1.gz lpr.1.gz )
( cd usr/man/man8 ; rm -rf cupsdisable.8.gz )
( cd usr/man/man8 ; ln -sf cupsenable.8.gz cupsdisable.8.gz )
( cd usr/man/man8 ; rm -rf reject.8.gz )
( cd usr/man/man8 ; ln -sf accept.8.gz reject.8.gz )
( cd usr/man/man8 ; rm -rf lpc.8.gz )
( cd usr/man/man8 ; ln -sf lpc-cups.8.gz lpc.8.gz )
( cd usr/sbin ; rm -rf lpc )
( cd usr/sbin ; ln -sf lpc-cups lpc )
( cd usr/sbin ; rm -rf cupsenable )
( cd usr/sbin ; ln -sf accept cupsenable )
( cd usr/sbin ; rm -rf cupsdisable )
( cd usr/sbin ; ln -sf accept cupsdisable )
( cd usr/sbin ; rm -rf reject )
( cd usr/sbin ; ln -sf accept reject )
( cd usr/lib64/cups/filter ; rm -rf rastertodymo )
( cd usr/lib64/cups/filter ; ln -sf rastertolabel rastertodymo )
( cd usr/lib64/cups/backend ; rm -rf smb )
( cd usr/lib64/cups/backend ; ln -sf /usr/bin/smbspool smb )
( cd usr/lib64/cups/backend ; rm -rf http )
( cd usr/lib64/cups/backend ; ln -sf ipp http )
( cd usr/lib64 ; rm -rf libcupsimage.so )
( cd usr/lib64 ; ln -sf libcupsimage.so.2 libcupsimage.so )
( cd usr/lib64 ; rm -rf libcups.so )
( cd usr/lib64 ; ln -sf libcups.so.2 libcups.so )
