/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

class TablePrintable
implements Printable {
    private JTable table;
    private JTableHeader header;
    private TableColumnModel colModel;
    private int totalColWidth;
    private JTable.PrintMode printMode;
    private MessageFormat headerFormat;
    private MessageFormat footerFormat;
    private int last = -1;
    private int row = 0;
    private int col = 0;
    private final Rectangle clip = new Rectangle(0, 0, 0, 0);
    private final Rectangle hclip = new Rectangle(0, 0, 0, 0);
    private final Rectangle tempRect = new Rectangle(0, 0, 0, 0);
    private static final int H_F_SPACE = 8;
    private static final float HEADER_FONT_SIZE = 18.0f;
    private static final float FOOTER_FONT_SIZE = 12.0f;
    private Font headerFont;
    private Font footerFont;

    public TablePrintable(JTable jTable, JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) {
        this.table = jTable;
        this.header = jTable.getTableHeader();
        this.colModel = jTable.getColumnModel();
        this.totalColWidth = this.colModel.getTotalColumnWidth();
        if (this.header != null) {
            this.hclip.height = this.header.getHeight();
        }
        this.printMode = printMode;
        this.headerFormat = messageFormat;
        this.footerFormat = messageFormat2;
        this.headerFont = jTable.getFont().deriveFont(1, 18.0f);
        this.footerFont = jTable.getFont().deriveFont(0, 12.0f);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)pageFormat.getImageableHeight();
        if (n2 <= 0) {
            throw new PrinterException("Width of printable area is too small.");
        }
        Object[] objectArray = new Object[]{new Integer(n + 1)};
        String string = null;
        if (this.headerFormat != null) {
            string = this.headerFormat.format(objectArray);
        }
        String string2 = null;
        if (this.footerFormat != null) {
            string2 = this.footerFormat.format(objectArray);
        }
        Rectangle2D rectangle2D = null;
        Rectangle2D rectangle2D2 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = n3;
        if (string != null) {
            graphics.setFont(this.headerFont);
            rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
            n4 = (int)Math.ceil(rectangle2D.getHeight());
            n6 -= n4 + 8;
        }
        if (string2 != null) {
            graphics.setFont(this.footerFont);
            rectangle2D2 = graphics.getFontMetrics().getStringBounds(string2, graphics);
            n5 = (int)Math.ceil(rectangle2D2.getHeight());
            n6 -= n5 + 8;
        }
        if (n6 <= 0) {
            throw new PrinterException("Height of printable area is too small.");
        }
        double d = 1.0;
        if (this.printMode == JTable.PrintMode.FIT_WIDTH && this.totalColWidth > n2) {
            assert (n2 > 0);
            assert (this.totalColWidth > 1);
            d = (double)n2 / (double)this.totalColWidth;
        }
        assert (d > 0.0);
        while (this.last < n) {
            if (this.row >= this.table.getRowCount() && this.col == 0) {
                return 1;
            }
            int n7 = (int)((double)n2 / d);
            int n8 = (int)((double)(n6 - this.hclip.height) / d);
            this.findNextClip(n7, n8);
            ++this.last;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        if (string2 != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(0, n3 - n5);
            this.printText(graphics2D, string2, rectangle2D2, this.footerFont, n2);
            graphics2D.setTransform(affineTransform);
        }
        if (string != null) {
            this.printText(graphics2D, string, rectangle2D, this.headerFont, n2);
            graphics2D.translate(0, n4 + 8);
        }
        this.tempRect.x = 0;
        this.tempRect.y = 0;
        this.tempRect.width = n2;
        this.tempRect.height = n6;
        graphics2D.clip(this.tempRect);
        if (d != 1.0) {
            graphics2D.scale(d, d);
        } else {
            int n9 = (n2 - this.clip.width) / 2;
            graphics2D.translate(n9, 0);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        if (this.header != null) {
            this.hclip.x = this.clip.x;
            this.hclip.width = this.clip.width;
            graphics2D.translate(-this.hclip.x, 0);
            graphics2D.clip(this.hclip);
            this.header.print(graphics2D);
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            graphics2D.translate(0, this.hclip.height);
        }
        graphics2D.translate(-this.clip.x, -this.clip.y);
        graphics2D.clip(this.clip);
        this.table.print(graphics2D);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, this.clip.width, this.hclip.height + this.clip.height);
        return 0;
    }

    private void printText(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, Font font, int n) {
        int n2 = rectangle2D.getWidth() < (double)n ? (int)(((double)n - rectangle2D.getWidth()) / 2.0) : (this.table.getComponentOrientation().isLeftToRight() ? 0 : -((int)(Math.ceil(rectangle2D.getWidth()) - (double)n)));
        int n3 = (int)Math.ceil(Math.abs(rectangle2D.getY()));
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(font);
        graphics2D.drawString(string, n2, n3);
    }

    private void findNextClip(int n, int n2) {
        int n3;
        int n4;
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        if (this.col == 0) {
            this.clip.x = bl ? 0 : this.totalColWidth;
            this.clip.y += this.clip.height;
            this.clip.width = 0;
            this.clip.height = 0;
            n4 = this.table.getRowCount();
            n3 = this.table.getRowHeight(this.row);
            do {
                this.clip.height += n3;
            } while (++this.row < n4 && this.clip.height + (n3 = this.table.getRowHeight(this.row)) <= n2);
        }
        if (this.printMode == JTable.PrintMode.FIT_WIDTH) {
            this.clip.x = 0;
            this.clip.width = this.totalColWidth;
            return;
        }
        if (bl) {
            this.clip.x += this.clip.width;
        }
        this.clip.width = 0;
        n4 = this.table.getColumnCount();
        n3 = this.colModel.getColumn(this.col).getWidth();
        do {
            this.clip.width += n3;
            if (!bl) {
                this.clip.x -= n3;
            }
            if (++this.col < n4) continue;
            this.col = 0;
            break;
        } while (this.clip.width + (n3 = this.colModel.getColumn(this.col).getWidth()) <= n);
    }
}

