#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.samba.new
# This won't be needed.  The point here is to preserve the permissions of the existing
# file, if there is one.  I don't see major new development happening in rc.samba...  ;-)
rm -f etc/rc.d/rc.samba.new
( cd usr/doc/samba-3.0.30/docs ; rm -rf htmldocs )
( cd usr/doc/samba-3.0.30/docs ; ln -sf /usr/share/swat/help htmldocs )
( cd usr/doc/samba-3.0.30/docs ; rm -rf using_samba )
( cd usr/doc/samba-3.0.30/docs ; ln -sf /usr/share/swat/using_samba using_samba )
( cd usr/sbin ; rm -rf mount.smbfs )
( cd usr/sbin ; ln -sf /usr/bin/smbmount mount.smbfs )
( cd usr/lib64/samba ; rm -rf libsmbclient.so )
( cd usr/lib64/samba ; ln -sf ../libsmbclient.so.0.0 libsmbclient.so )
( cd usr/lib64 ; rm -rf libsmbclient.so.0 )
( cd usr/lib64 ; ln -sf libsmbclient.so.0.0 libsmbclient.so.0 )
( cd usr/lib64 ; rm -rf libsmbclient.so )
( cd usr/lib64 ; ln -sf libsmbclient.so.0.0 libsmbclient.so )
( cd sbin ; rm -rf mount.cifs )
( cd sbin ; ln -sf /usr/sbin/mount.cifs mount.cifs )
( cd sbin ; rm -rf mount.smbfs )
( cd sbin ; ln -sf /usr/bin/smbmount mount.smbfs )
( cd lib64 ; rm -rf libnss_winbind.so )
( cd lib64 ; ln -sf libnss_winbind.so.2 libnss_winbind.so )
( cd lib64 ; rm -rf libnss_wins.so )
( cd lib64 ; ln -sf libnss_wins.so.2 libnss_wins.so )
