
/^int kvm_init\(/ { anon_inodes = 1 }

/return 0;/ && anon_inodes {
    print "\tr = kvm_init_anon_inodes();";
    print "\tif (r) {";
    print "\t\t__free_page(bad_page);";
    print "\t\tgoto out;";
    print "\t}";
    print "\tpreempt_notifier_sys_init();";
    printf("\tprintk(\"loaded kvm module (%s)\\n\");\n", version);
    anon_inodes = 0
}

/^void kvm_exit/ { anon_inodes_exit = 1 }

/\}/ && anon_inodes_exit {
    print "\tkvm_exit_anon_inodes();";
    print "\tpreempt_notifier_sys_exit();";
    anon_inodes_exit = 0
}

/MODULE_AUTHOR/ {
    printf("MODULE_INFO(version, \"%s\");\n", version)
}

/^static unsigned long vmcs_readl/ {
    in_vmcs_read = 1
}

/ASM_VMX_VMREAD_RDX_RAX/ && in_vmcs_read {
    printf("\tstart_special_insn();\n")
}

/return/ && in_vmcs_read {
    printf("\tend_special_insn();\n");
    in_vmcs_read = 0
}

/^static void vmcs_writel/ {
    in_vmcs_write = 1
}

/ASM_VMX_VMWRITE_RAX_RDX/ && in_vmcs_write {
    printf("\tstart_special_insn();\n")
}

/if/ && in_vmcs_write {
    printf("\tend_special_insn();\n");
    in_vmcs_write = 0
}

/^static void vmx_load_host_state/ {
    vmx_load_host_state = 1
}

/vmcs_readl\(HOST_GS_BASE\)/ &&  vmx_load_host_state {
    $0 = "\t\twrmsrl(MSR_GS_BASE, gsbase);";
    vmx_load_host_state = 0
}

/atomic_inc\(&kvm->mm->mm_count\);/ { $0 = "//" $0 }

/^\t\.fault = / {
    fcn = gensub(/,/, "", "g", $3)
    $0 = "\t.VMA_OPS_FAULT(fault) = VMA_OPS_FAULT_FUNC(" fcn "),"
}

{ sub(/linux\/mm_types\.h/, "linux/mm.h") }

{ print }

/kvm_x86_ops->run/ {
    print "\tspecial_reload_dr7();"
}

/static void vcpu_put|static int __vcpu_run|static struct kvm_vcpu \*vmx_create_vcpu/ {
    in_tricky_func = 1
}

/preempt_disable|get_cpu/ && in_tricky_func {
    printf("\tin_special_section();\n");
    in_tricky_func = 0
}

/unsigned long flags;/ &&  vmx_load_host_state {
    print "\tunsigned long gsbase;"
}

/local_irq_save/ &&  vmx_load_host_state {
    print "\t\tgsbase = vmcs_readl(HOST_GS_BASE);"
}

