# Handle the incoming configuration files:
config() {
  for infile in $1; do
    NEW="$infile"
    OLD="`dirname $NEW`/`basename $NEW .new`"
    # If there's no config file by that name, mv it over:
    if [ ! -r $OLD ]; then
      mv $NEW $OLD
    elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
      # toss the redundant copy
      rm $NEW
    fi
    # Otherwise, we leave the .new copy for the admin to consider...
  done
}

# Prepare the new configuration files
for file in etc/profile.d/libglib2.csh.new etc/profile.d/libglib2.sh.new ; do
  if test -e $(dirname $file)/$(basename $file .new) ; then
    if [ ! -x $(dirname $file)/$(basename $file .new) ]; then
      chmod 644 $file
     else
      chmod 755 $file
    fi
  fi
  config $file
done
( cd usr/doc/glib-2.16.6 ; rm -rf html )
( cd usr/doc/glib-2.16.6 ; ln -sf /usr/share/gtk-doc/html/gobject html )
( cd usr/lib64 ; rm -rf libglib-2.0.so.0 )
( cd usr/lib64 ; ln -sf libglib-2.0.so.0.1600.6 libglib-2.0.so.0 )
( cd usr/lib64 ; rm -rf libglib-2.0.so )
( cd usr/lib64 ; ln -sf libglib-2.0.so.0.1600.6 libglib-2.0.so )
( cd usr/lib64 ; rm -rf libgmodule-2.0.so.0 )
( cd usr/lib64 ; ln -sf libgmodule-2.0.so.0.1600.6 libgmodule-2.0.so.0 )
( cd usr/lib64 ; rm -rf libgobject-2.0.so.0 )
( cd usr/lib64 ; ln -sf libgobject-2.0.so.0.1600.6 libgobject-2.0.so.0 )
( cd usr/lib64 ; rm -rf libgmodule-2.0.so )
( cd usr/lib64 ; ln -sf libgmodule-2.0.so.0.1600.6 libgmodule-2.0.so )
( cd usr/lib64 ; rm -rf libgio-2.0.so.0 )
( cd usr/lib64 ; ln -sf libgio-2.0.so.0.0.0 libgio-2.0.so.0 )
( cd usr/lib64 ; rm -rf libgthread-2.0.so )
( cd usr/lib64 ; ln -sf libgthread-2.0.so.0.1600.6 libgthread-2.0.so )
( cd usr/lib64 ; rm -rf libgio-2.0.so )
( cd usr/lib64 ; ln -sf libgio-2.0.so.0.0.0 libgio-2.0.so )
( cd usr/lib64 ; rm -rf libgthread-2.0.so.0 )
( cd usr/lib64 ; ln -sf libgthread-2.0.so.0.1600.6 libgthread-2.0.so.0 )
( cd usr/lib64 ; rm -rf libgobject-2.0.so )
( cd usr/lib64 ; ln -sf libgobject-2.0.so.0.1600.6 libgobject-2.0.so )
