#!/bin/sh
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/sensors3.conf.new
( cd usr/lib64 ; rm -rf libsensors.so )
( cd usr/lib64 ; ln -sf libsensors.so.4 libsensors.so )
( cd usr/lib64 ; rm -rf libsensors.so.4 )
( cd usr/lib64 ; ln -sf libsensors.so.4.0.2 libsensors.so.4 )
