#!/bin/sh
# Copyright (C) 2002, 2005  Slackware Linux, Inc.
# Copyright 2005, 2006, 2007  Patrick J. Volkerding, Sebeka, Minnesota, USA
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Swap glibc on the fly.
#
# If we're on a running system we have to handle this _very_ carefully.  :-)
# The tricks involved here get trickier every time...

# OK, now we have to be sure of a few things.  First, you do have a 2.6
# kernel running, right?

if [ -r /proc/ksyms ]; then
  echo "FATAL: you need to be running a 2.6.x kernel in order to upgrade"
  echo "to this version of glibc."
  echo
  sleep 999
  exit 1
fi

# Next, stop using the /lib64/ntpl libraries.  These are now obsolete and
# will break the installation if present:
if [ -d lib64/tls ]; then
  mkdir -p lib64/obsolete
  mv lib64/tls lib64/obsolete
fi
if [ -x sbin/ldconfig ]; then
  sbin/ldconfig -r .
fi

# Install NPTL glibc libraries:
if [ -x /sbin/ldconfig -a -d lib64/incoming ]; then # swap on the fly
  # First create copies of the incoming libraries:
  ( cd lib64/incoming
    for file in * ; do
      if [ ! -r ../${file}.incoming ]; then
        cp -a $file ../${file}.incoming
      fi
    done
  )
  # Then switch to them all at once:
  /sbin/ldconfig -l lib64/*.incoming 2> /dev/null
  # Finally, rename them and clean up:
  ( cd lib64
    for file in *.incoming ; do
      rm -f `basename $file .incoming`
      cp -a $file `basename $file .incoming`
      /sbin/ldconfig -l `basename $file .incoming`
      rm -f $file
    done
  )
else # no ldconfig?  Good, it's safe to just jam it on home (and make links below):
  ( cd lib64/incoming
    for file in * ; do
      cp -a $file ..
    done
  )
fi
# Now, get rid of the temporary directory:
rm -rf lib64/incoming
# Done installing NPTL glibc libraries.

# Timezone stuff:
if [ -L etc/localtime -a ! -r etc/localtime-copied-from ]; then
  mv etc/localtime etc/localtime-copied-from
  chroot . /bin/cp etc/localtime-copied-from etc/localtime
fi
# Add the default timezone in /etc, if none exists:
if [ ! -r etc/localtime ]; then
  ( cd etc ; rm -rf localtime localtime-copied-from )
  ( cd etc ; ln -sf /usr/share/zoneinfo/Factory localtime-copied-from )
  chroot . /bin/cp etc/localtime-copied-from etc/localtime
fi
# Add the default link in /usr/share/zoneinfo, if none exists:
if [ ! -L usr/share/zoneinfo/localtime ]; then
  ( cd usr/share/zoneinfo ; rm -rf localtime )
  ( cd usr/share/zoneinfo ; ln -sf /etc/localtime localtime )
fi
( cd usr/share/zoneinfo ; rm -rf timeconfig )
( cd usr/share/zoneinfo ; ln -sf /usr/sbin/timeconfig timeconfig )

# Handle config files:
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/nscd.conf.new
config etc/profile.d/glibc.csh.new
config etc/profile.d/glibc.sh.new
# Clearly you already decided this issue.  :-)
rm -f etc/profile.d/glibc.csh.new
rm -f etc/profile.d/glibc.sh.new

# In case there's no ldconfig, make the links manually:
if [ ! -x /sbin/ldconfig ]; then
# linuxthreads:
( cd lib64 ; rm -rf libnss_nis.so.2 )
( cd lib64 ; ln -sf libnss_nis-2.7.so libnss_nis.so.2 )
( cd lib64 ; rm -rf libm.so.6 )
( cd lib64 ; ln -sf libm-2.7.so libm.so.6 )
( cd lib64 ; rm -rf libnss_files.so.2 )
( cd lib64 ; ln -sf libnss_files-2.7.so libnss_files.so.2 )
( cd lib64 ; rm -rf libresolv.so.2 )
( cd lib64 ; ln -sf libresolv-2.7.so libresolv.so.2 )
( cd lib64 ; rm -rf libnsl.so.1 )
( cd lib64 ; ln -sf libnsl-2.7.so libnsl.so.1 )
( cd lib64 ; rm -rf libutil.so.1 )
( cd lib64 ; ln -sf libutil-2.7.so libutil.so.1 )
( cd lib64 ; rm -rf libnss_compat.so.2 )
( cd lib64 ; ln -sf libnss_compat-2.7.so libnss_compat.so.2 )
( cd lib64 ; rm -rf libthread_db.so.1 )
( cd lib64 ; ln -sf libthread_db-1.0.so libthread_db.so.1 )
( cd lib64 ; rm -rf libnss_hesiod.so.2 )
( cd lib64 ; ln -sf libnss_hesiod-2.7.so libnss_hesiod.so.2 )
( cd lib64 ; rm -rf libanl.so.1 )
( cd lib64 ; ln -sf libanl-2.7.so libanl.so.1 )
( cd lib64 ; rm -rf libcrypt.so.1 )
( cd lib64 ; ln -sf libcrypt-2.7.so libcrypt.so.1 )
( cd lib64 ; rm -rf libBrokenLocale.so.1 )
( cd lib64 ; ln -sf libBrokenLocale-2.7.so libBrokenLocale.so.1 )
( cd lib64 ; rm -rf ld-linux-x86-64.so.2 )
( cd lib64 ; ln -sf ld-2.7.so ld-linux-x86-64.so.2 )
( cd lib64 ; rm -rf libdl.so.2 )
( cd lib64 ; ln -sf libdl-2.7.so libdl.so.2 )
( cd lib64 ; rm -rf libnss_dns.so.2 )
( cd lib64 ; ln -sf libnss_dns-2.7.so libnss_dns.so.2 )
( cd lib64 ; rm -rf libpthread.so.0 )
( cd lib64 ; ln -sf libpthread-2.7.so libpthread.so.0 )
( cd lib64 ; rm -rf libnss_nisplus.so.2 )
( cd lib64 ; ln -sf libnss_nisplus-2.7.so libnss_nisplus.so.2 )
( cd lib64 ; rm -rf libc.so.6 )
( cd lib64 ; ln -sf libc-2.7.so libc.so.6 )
( cd lib64 ; rm -rf librt.so.1 )
( cd lib64 ; ln -sf librt-2.7.so librt.so.1 )
fi

# More links:
( cd usr/lib64 ; rm -rf libnss_nisplus.so )
( cd usr/lib64 ; ln -sf ../../lib64/libnss_nisplus.so.2 libnss_nisplus.so )
# This is now a linker script:
#( cd usr/lib64 ; rm -rf libpthread.so )
#( cd usr/lib64 ; ln -sf ../../lib64/libpthread.so.0 libpthread.so )
( cd usr/lib64 ; rm -rf libresolv.so )
( cd usr/lib64 ; ln -sf ../../lib64/libresolv.so.2 libresolv.so )
( cd usr/lib64 ; rm -rf libnsl.so )
( cd usr/lib64 ; ln -sf ../../lib64/libnsl.so.1 libnsl.so )
( cd usr/lib64 ; rm -rf libnss_hesiod.so )
( cd usr/lib64 ; ln -sf ../../lib64/libnss_hesiod.so.2 libnss_hesiod.so )
( cd usr/lib64 ; rm -rf libnss_files.so )
( cd usr/lib64 ; ln -sf ../../lib64/libnss_files.so.2 libnss_files.so )
( cd usr/lib64 ; rm -rf libm.so )
( cd usr/lib64 ; ln -sf ../../lib64/libm.so.6 libm.so )
( cd usr/lib64 ; rm -rf libutil.so )
( cd usr/lib64 ; ln -sf ../../lib64/libutil.so.1 libutil.so )
( cd usr/lib64 ; rm -rf libnss_compat.so )
( cd usr/lib64 ; ln -sf ../../lib64/libnss_compat.so.2 libnss_compat.so )
( cd usr/lib64 ; rm -rf libthread_db.so )
( cd usr/lib64 ; ln -sf ../../lib64/libthread_db.so.1 libthread_db.so )
( cd usr/lib64 ; rm -rf libcrypt.so )
( cd usr/lib64 ; ln -sf ../../lib64/libcrypt.so.1 libcrypt.so )
( cd usr/lib64 ; rm -rf libBrokenLocale.so )
( cd usr/lib64 ; ln -sf ../../lib64/libBrokenLocale.so.1 libBrokenLocale.so )
( cd usr/lib64 ; rm -rf libdl.so )
( cd usr/lib64 ; ln -sf ../../lib64/libdl.so.2 libdl.so )
( cd usr/lib64 ; rm -rf libnss_dns.so )
( cd usr/lib64 ; ln -sf ../../lib64/libnss_dns.so.2 libnss_dns.so )
( cd usr/lib64 ; rm -rf librt.so )
( cd usr/lib64 ; ln -sf ../../lib64/librt.so.1 librt.so )
( cd usr/lib64 ; rm -rf libanl.so )
( cd usr/lib64 ; ln -sf ../../lib64/libanl.so.1 libanl.so )
( cd usr/lib64 ; rm -rf libnss_nis.so )
( cd usr/lib64 ; ln -sf ../../lib64/libnss_nis.so.2 libnss_nis.so )
( cd usr/share/zoneinfo ; rm -rf localtime )
( cd usr/share/zoneinfo ; ln -sf /etc/localtime localtime )
( cd bin ; rm -rf sln )
( cd bin ; ln -sf /sbin/sln sln )
