#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.samba.new
# This won't be needed.  The point here is to preserve the permissions of the existing
# file, if there is one.  I don't see major new development happening in rc.samba...  ;-)
rm -f etc/rc.d/rc.samba.new
( cd usr/bin ; rm -rf smbmount )
( cd usr/bin ; ln -sf /sbin/mount.smbfs smbmount )
( cd usr/doc/samba-3.2.7/docs ; rm -rf htmldocs )
( cd usr/doc/samba-3.2.7/docs ; ln -sf /usr/share/swat/help htmldocs )
( cd usr/doc/samba-3.2.7/docs ; rm -rf using_samba )
( cd usr/doc/samba-3.2.7/docs ; ln -sf /usr/share/swat/using_samba using_samba )
( cd usr/lib64 ; rm -rf libsmbsharemodes.so )
( cd usr/lib64 ; ln -sf libsmbsharemodes.so.0 libsmbsharemodes.so )
( cd usr/lib64 ; rm -rf libtdb.so )
( cd usr/lib64 ; ln -sf libtdb.so.1 libtdb.so )
( cd usr/lib64 ; rm -rf libsmbclient.so )
( cd usr/lib64 ; ln -sf libsmbclient.so.0 libsmbclient.so )
( cd usr/lib64 ; rm -rf libwbclient.so )
( cd usr/lib64 ; ln -sf libwbclient.so.0 libwbclient.so )
( cd usr/lib64 ; rm -rf libnetapi.so )
( cd usr/lib64 ; ln -sf libnetapi.so.0 libnetapi.so )
( cd usr/lib64 ; rm -rf libtalloc.so )
( cd usr/lib64 ; ln -sf libtalloc.so.1 libtalloc.so )
( cd sbin ; rm -rf mount.cifs )
( cd sbin ; ln -sf /usr/sbin/mount.cifs mount.cifs )
( cd lib64 ; rm -rf libnss_winbind.so )
( cd lib64 ; ln -sf libnss_winbind.so.2 libnss_winbind.so )
( cd lib64 ; rm -rf libnss_wins.so )
( cd lib64 ; ln -sf libnss_wins.so.2 libnss_wins.so )
