#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
     mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
     rm $NEW
  fi
# Otherwise, we leave the .new copy for the admin to consider...
}

#Check if the .fluxbox directory exist in the user HOME
if [ ! -d /root/.fluxbox ] ; then
   mkdir /root/.fluxbox
fi

if [ ! -d /root/.xbmc ] ; then
   mkdir /root/.xbmc
fi

if [ ! -d /root/.xbmc/userdata ] ; then
   mkdir /root/.xbmc/userdata
fi

#Remove files that might exist in /tmp matching out filenames!
if [ -f /tmp/startup.new ] ; then
   rm -f /tmp/startup.new
fi

if [ -f /tmp/menu.new ] ; then
   rm -f /tmp/menu.new
fi

if [ -f /tmp/autostart.sh.new ] ; then
   rm -f /tmp/autostart.sh.new
fi

config root/.fluxbox/startup.new
config root/.fluxbox/menu.new
config root/.fluxbox/autostart.sh.new
config root/.xbmc/userdata/advancedsettings.xml.new
