/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.org.mozilla.javascript.internal.Callable;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.IdFunctionObject;
import sun.org.mozilla.javascript.internal.IdScriptableObject;
import sun.org.mozilla.javascript.internal.NativeArray;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.Undefined;

public class NativeObject
extends IdScriptableObject
implements Map {
    static final long serialVersionUID = -6345305608474346996L;
    private static final Object OBJECT_TAG = "Object";
    private static final int ConstructorId_getPrototypeOf = -1;
    private static final int ConstructorId_keys = -2;
    private static final int ConstructorId_getOwnPropertyNames = -3;
    private static final int ConstructorId_getOwnPropertyDescriptor = -4;
    private static final int ConstructorId_defineProperty = -5;
    private static final int ConstructorId_isExtensible = -6;
    private static final int ConstructorId_preventExtensions = -7;
    private static final int ConstructorId_defineProperties = -8;
    private static final int ConstructorId_create = -9;
    private static final int ConstructorId_isSealed = -10;
    private static final int ConstructorId_isFrozen = -11;
    private static final int ConstructorId_seal = -12;
    private static final int ConstructorId_freeze = -13;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int Id_toSource = 8;
    private static final int Id___defineGetter__ = 9;
    private static final int Id___defineSetter__ = 10;
    private static final int Id___lookupGetter__ = 11;
    private static final int Id___lookupSetter__ = 12;
    private static final int MAX_PROTOTYPE_ID = 12;

    static void init(Scriptable scriptable, boolean bl) {
        NativeObject nativeObject = new NativeObject();
        nativeObject.exportAsJSClass(12, scriptable, bl);
    }

    @Override
    public String getClassName() {
        return "Object";
    }

    public String toString() {
        return ScriptRuntime.defaultObjectToString(this);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -1, "getPrototypeOf", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -2, "keys", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -3, "getOwnPropertyNames", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -4, "getOwnPropertyDescriptor", 2);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -5, "defineProperty", 3);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -6, "isExtensible", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -7, "preventExtensions", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -8, "defineProperties", 2);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -9, "create", 2);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -10, "isSealed", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -11, "isFrozen", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -12, "seal", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -13, "freeze", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            case 5: {
                n2 = 1;
                string = "hasOwnProperty";
                break;
            }
            case 6: {
                n2 = 1;
                string = "propertyIsEnumerable";
                break;
            }
            case 7: {
                n2 = 1;
                string = "isPrototypeOf";
                break;
            }
            case 8: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 9: {
                n2 = 2;
                string = "__defineGetter__";
                break;
            }
            case 10: {
                n2 = 2;
                string = "__defineSetter__";
                break;
            }
            case 11: {
                n2 = 1;
                string = "__lookupGetter__";
                break;
            }
            case 12: {
                n2 = 1;
                string = "__lookupSetter__";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(OBJECT_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(OBJECT_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (scriptable2 != null) {
                    return idFunctionObject.construct(context, scriptable, objectArray);
                }
                if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
                    return new NativeObject();
                }
                return ScriptRuntime.toObject(context, scriptable, objectArray[0]);
            }
            case 2: 
            case 3: {
                if (context.hasFeature(4)) {
                    String string = ScriptRuntime.defaultObjectToSource(context, scriptable, scriptable2, objectArray);
                    int n2 = string.length();
                    if (n2 != 0 && string.charAt(0) == '(' && string.charAt(n2 - 1) == ')') {
                        string = string.substring(1, n2 - 1);
                    }
                    return string;
                }
                return ScriptRuntime.defaultObjectToString(scriptable2);
            }
            case 4: {
                return scriptable2;
            }
            case 5: {
                boolean bl;
                if (objectArray.length == 0) {
                    bl = false;
                } else {
                    String string = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                    if (string == null) {
                        int n3 = ScriptRuntime.lastIndexResult(context);
                        bl = scriptable2.has(n3, scriptable2);
                    } else {
                        bl = scriptable2.has(string, scriptable2);
                    }
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 6: {
                boolean bl;
                if (objectArray.length == 0) {
                    bl = false;
                } else {
                    String string = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                    if (string == null) {
                        int n4 = ScriptRuntime.lastIndexResult(context);
                        bl = scriptable2.has(n4, scriptable2);
                        if (bl && scriptable2 instanceof ScriptableObject) {
                            ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                            int n5 = scriptableObject.getAttributes(n4);
                            bl = (n5 & 2) == 0;
                        }
                    } else {
                        bl = scriptable2.has(string, scriptable2);
                        if (bl && scriptable2 instanceof ScriptableObject) {
                            ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                            int n6 = scriptableObject.getAttributes(string);
                            bl = (n6 & 2) == 0;
                        }
                    }
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 7: {
                boolean bl = false;
                if (objectArray.length != 0 && objectArray[0] instanceof Scriptable) {
                    Scriptable scriptable3 = (Scriptable)objectArray[0];
                    do {
                        if ((scriptable3 = scriptable3.getPrototype()) != scriptable2) continue;
                        bl = true;
                        break;
                    } while (scriptable3 != null);
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 8: {
                return ScriptRuntime.defaultObjectToSource(context, scriptable, scriptable2, objectArray);
            }
            case 9: 
            case 10: {
                if (objectArray.length < 2 || !(objectArray[1] instanceof Callable)) {
                    Object object = objectArray.length >= 2 ? objectArray[1] : Undefined.instance;
                    throw ScriptRuntime.notFunctionError(object);
                }
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw Context.reportRuntimeError2("msg.extend.scriptable", scriptable2.getClass().getName(), String.valueOf(objectArray[0]));
                }
                ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                String string = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                int n7 = string != null ? 0 : ScriptRuntime.lastIndexResult(context);
                Callable callable = (Callable)objectArray[1];
                boolean bl = n == 10;
                scriptableObject.setGetterOrSetter(string, n7, callable, bl);
                if (scriptableObject instanceof NativeArray) {
                    ((NativeArray)scriptableObject).setDenseOnly(false);
                }
                return Undefined.instance;
            }
            case 11: 
            case 12: {
                Scriptable scriptable4;
                Object object;
                boolean bl;
                if (objectArray.length < 1 || !(scriptable2 instanceof ScriptableObject)) {
                    return Undefined.instance;
                }
                ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                String string = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                int n8 = string != null ? 0 : ScriptRuntime.lastIndexResult(context);
                boolean bl2 = bl = n == 12;
                while ((object = scriptableObject.getGetterOrSetter(string, n8, bl)) == null && (scriptable4 = scriptableObject.getPrototype()) != null && scriptable4 instanceof ScriptableObject) {
                    scriptableObject = (ScriptableObject)scriptable4;
                }
                if (object != null) {
                    return object;
                }
                return Undefined.instance;
            }
            case -1: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable5 = this.ensureScriptable(object);
                return scriptable5.getPrototype();
            }
            case -2: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable6 = this.ensureScriptable(object);
                Object[] objectArray2 = scriptable6.getIds();
                for (int i = 0; i < objectArray2.length; ++i) {
                    objectArray2[i] = ScriptRuntime.toString(objectArray2[i]);
                }
                return context.newArray(scriptable, objectArray2);
            }
            case -3: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                Object[] objectArray3 = scriptableObject.getAllIds();
                for (int i = 0; i < objectArray3.length; ++i) {
                    objectArray3[i] = ScriptRuntime.toString(objectArray3[i]);
                }
                return context.newArray(scriptable, objectArray3);
            }
            case -4: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                Object object2 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                String string = ScriptRuntime.toString(object2);
                ScriptableObject scriptableObject2 = scriptableObject.getOwnPropertyDescriptor(context, string);
                return scriptableObject2 == null ? Undefined.instance : scriptableObject2;
            }
            case -5: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                Object object3 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                Object object4 = objectArray.length < 3 ? Undefined.instance : objectArray[2];
                ScriptableObject scriptableObject3 = this.ensureScriptableObject(object4);
                scriptableObject.defineOwnProperty(context, object3, scriptableObject3);
                return scriptableObject;
            }
            case -6: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                return scriptableObject.isExtensible();
            }
            case -7: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                scriptableObject.preventExtensions();
                return scriptableObject;
            }
            case -8: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                Object object5 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                Scriptable scriptable7 = Context.toObject(object5, this.getParentScope());
                scriptableObject.defineOwnProperties(context, this.ensureScriptableObject(scriptable7));
                return scriptableObject;
            }
            case -9: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable8 = object == null ? null : this.ensureScriptable(object);
                NativeObject nativeObject = new NativeObject();
                nativeObject.setParentScope(this.getParentScope());
                nativeObject.setPrototype(scriptable8);
                if (objectArray.length > 1 && objectArray[1] != Undefined.instance) {
                    Scriptable scriptable9 = Context.toObject(objectArray[1], this.getParentScope());
                    nativeObject.defineOwnProperties(context, this.ensureScriptableObject(scriptable9));
                }
                return nativeObject;
            }
            case -10: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                if (scriptableObject.isExtensible()) {
                    return false;
                }
                for (Object object6 : scriptableObject.getAllIds()) {
                    Object object7 = scriptableObject.getOwnPropertyDescriptor(context, object6).get("configurable");
                    if (!Boolean.TRUE.equals(object7)) continue;
                    return false;
                }
                return true;
            }
            case -11: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                if (scriptableObject.isExtensible()) {
                    return false;
                }
                for (Object object8 : scriptableObject.getAllIds()) {
                    ScriptableObject scriptableObject4 = scriptableObject.getOwnPropertyDescriptor(context, object8);
                    if (Boolean.TRUE.equals(scriptableObject4.get("configurable"))) {
                        return false;
                    }
                    if (!this.isDataDescriptor(scriptableObject4) || !Boolean.TRUE.equals(scriptableObject4.get("writable"))) continue;
                    return false;
                }
                return true;
            }
            case -12: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                for (Object object9 : scriptableObject.getAllIds()) {
                    ScriptableObject scriptableObject5 = scriptableObject.getOwnPropertyDescriptor(context, object9);
                    if (!Boolean.TRUE.equals(scriptableObject5.get("configurable"))) continue;
                    scriptableObject5.put("configurable", (Scriptable)scriptableObject5, (Object)false);
                    scriptableObject.defineOwnProperty(context, object9, scriptableObject5);
                }
                scriptableObject.preventExtensions();
                return scriptableObject;
            }
            case -13: {
                Object object = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = this.ensureScriptableObject(object);
                for (Object object10 : scriptableObject.getAllIds()) {
                    ScriptableObject scriptableObject6 = scriptableObject.getOwnPropertyDescriptor(context, object10);
                    if (this.isDataDescriptor(scriptableObject6) && Boolean.TRUE.equals(scriptableObject6.get("writable"))) {
                        scriptableObject6.put("writable", (Scriptable)scriptableObject6, (Object)false);
                    }
                    if (Boolean.TRUE.equals(scriptableObject6.get("configurable"))) {
                        scriptableObject6.put("configurable", (Scriptable)scriptableObject6, (Object)false);
                    }
                    scriptableObject.defineOwnProperty(context, object10, scriptableObject6);
                }
                scriptableObject.preventExtensions();
                return scriptableObject;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof String) {
            return this.has((String)object, (Scriptable)this);
        }
        if (object instanceof Number) {
            return this.has(((Number)object).intValue(), (Scriptable)this);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        for (Object object2 : this.values()) {
            if (object != object2 && (object == null || !object.equals(object2))) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object object) {
        Object object2 = this.get(object);
        if (object instanceof String) {
            this.delete((String)object);
        } else if (object instanceof Number) {
            this.delete(((Number)object).intValue());
        }
        return object2;
    }

    public Set<Object> keySet() {
        return new KeySet();
    }

    public Collection<Object> values() {
        return new ValueCollection();
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return new EntrySet();
    }

    public Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block14: {
            n = 0;
            String string2 = null;
            switch (string.length()) {
                case 7: {
                    string2 = "valueOf";
                    n = 4;
                    break;
                }
                case 8: {
                    char c = string.charAt(3);
                    if (c == 'o') {
                        string2 = "toSource";
                        n = 8;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "toString";
                    n = 2;
                    break;
                }
                case 11: {
                    string2 = "constructor";
                    n = 1;
                    break;
                }
                case 13: {
                    string2 = "isPrototypeOf";
                    n = 7;
                    break;
                }
                case 14: {
                    char c = string.charAt(0);
                    if (c == 'h') {
                        string2 = "hasOwnProperty";
                        n = 5;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "toLocaleString";
                    n = 3;
                    break;
                }
                case 16: {
                    char c = string.charAt(2);
                    if (c == 'd') {
                        c = string.charAt(8);
                        if (c == 'G') {
                            string2 = "__defineGetter__";
                            n = 9;
                            break;
                        }
                        if (c != 'S') break;
                        string2 = "__defineSetter__";
                        n = 10;
                        break;
                    }
                    if (c != 'l') break;
                    c = string.charAt(8);
                    if (c == 'G') {
                        string2 = "__lookupGetter__";
                        n = 11;
                        break;
                    }
                    if (c != 'S') break;
                    string2 = "__lookupSetter__";
                    n = 12;
                    break;
                }
                case 20: {
                    string2 = "propertyIsEnumerable";
                    n = 6;
                    break;
                }
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block14;
            n = 0;
        }
        return n;
    }

    class ValueCollection
    extends AbstractCollection<Object> {
        ValueCollection() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                Object[] ids;
                Object key;
                int index;
                {
                    this.ids = NativeObject.this.getIds();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.ids.length;
                }

                @Override
                public Object next() {
                    this.key = this.ids[this.index++];
                    return NativeObject.this.get(this.key);
                }

                @Override
                public void remove() {
                    if (this.key == null) {
                        throw new IllegalStateException();
                    }
                    NativeObject.this.remove(this.key);
                    this.key = null;
                }
            };
        }

        @Override
        public int size() {
            return NativeObject.this.size();
        }
    }

    class KeySet
    extends AbstractSet<Object> {
        KeySet() {
        }

        @Override
        public boolean contains(Object object) {
            return NativeObject.this.containsKey(object);
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                Object[] ids;
                Object key;
                int index;
                {
                    this.ids = NativeObject.this.getIds();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.ids.length;
                }

                @Override
                public Object next() {
                    this.key = this.ids[this.index++];
                    return this.key;
                }

                @Override
                public void remove() {
                    if (this.key == null) {
                        throw new IllegalStateException();
                    }
                    NativeObject.this.remove(this.key);
                    this.key = null;
                }
            };
        }

        @Override
        public int size() {
            return NativeObject.this.size();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<Object, Object>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return new Iterator<Map.Entry<Object, Object>>(){
                Object[] ids;
                Object key;
                int index;
                {
                    this.ids = NativeObject.this.getIds();
                    this.key = null;
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.ids.length;
                }

                @Override
                public Map.Entry<Object, Object> next() {
                    final Object object = this.key = this.ids[this.index++];
                    final Object object2 = NativeObject.this.get(this.key);
                    return new Map.Entry<Object, Object>(){

                        @Override
                        public Object getKey() {
                            return object;
                        }

                        @Override
                        public Object getValue() {
                            return object2;
                        }

                        @Override
                        public Object setValue(Object object3) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean equals(Object object3) {
                            if (!(object3 instanceof Map.Entry)) {
                                return false;
                            }
                            Map.Entry entry = (Map.Entry)object3;
                            return (object == null ? entry.getKey() == null : object.equals(entry.getKey())) && (object2 == null ? entry.getValue() == null : object2.equals(entry.getValue()));
                        }

                        @Override
                        public int hashCode() {
                            return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
                        }

                        public String toString() {
                            return object + "=" + object2;
                        }
                    };
                }

                @Override
                public void remove() {
                    if (this.key == null) {
                        throw new IllegalStateException();
                    }
                    NativeObject.this.remove(this.key);
                    this.key = null;
                }
            };
        }

        @Override
        public int size() {
            return NativeObject.this.size();
        }
    }
}

