config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Keep same perms on rc.mysqld.new:
if [ -e etc/rc.d/rc.mysqld ]; then
  cp -a etc/rc.d/rc.mysqld etc/rc.d/rc.mysqld.new.incoming
  cat etc/rc.d/rc.mysqld.new > etc/rc.d/rc.mysqld.new.incoming
  mv etc/rc.d/rc.mysqld.new.incoming etc/rc.d/rc.mysqld.new
fi

config etc/rc.d/rc.mysqld.new
config etc/mysqlaccess.conf.new
config etc/my.cnf.new
config etc/my.cnf.d/client.cnf.new
config etc/my.cnf.d/mysql-clients.cnf.new
config etc/my.cnf.d/server.cnf.new
config etc/logrotate.d/mysql.new

( cd usr/lib ; rm -rf libmysqlclient_r.so )
( cd usr/lib ; ln -sf libmysqlclient.so libmysqlclient_r.so )
( cd usr/lib ; rm -rf libmysqlclient_r.so.18.0.0 )
( cd usr/lib ; ln -sf libmysqlclient.so libmysqlclient_r.so.18.0.0 )
( cd usr/lib ; rm -rf libmysqlclient.so )
( cd usr/lib ; ln -sf libmysqlclient.so.18 libmysqlclient.so )
( cd usr/lib ; rm -rf libmysqlclient_r.so.18 )
( cd usr/lib ; ln -sf libmysqlclient.so libmysqlclient_r.so.18 )
( cd usr/lib ; rm -rf libmysqlclient.so.18 )
( cd usr/lib ; ln -sf libmysqlclient.so.18.0.0 libmysqlclient.so.18 )
( cd usr/lib ; rm -rf libmysqld.so )
( cd usr/lib ; ln -sf libmysqld.so.18 libmysqld.so )
