config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# The GTK+3 theme no longer works, so if gtkrc uses that, back up the old
# file and install the new one:
if grep -q GTK etc/gtk-3.0/gtkrc 2> /dev/null ; then
  mv etc/gtk-3.0/gtkrc etc/gtk-3.0/gtkrc.bak
fi
config etc/gtk-3.0/gtkrc.new
config etc/gtk-3.0/im-multipress.conf.new
rm -f etc/gtk-3.0/gtkrc.new

chroot . rm -f /usr/share/icons/*/icon-theme.cache 1> /dev/null 2> /dev/null

# Run this if we are on an installed system.  Otherwise it will be
# handled on first boot.
if [ -x /usr/bin/update-gtk-immodules-3.0 ]; then
  /usr/bin/update-gtk-immodules-3.0
fi

# In case this is the first run installing the standalone gdk-pixbuf,
# we will run this a second time to fix machines that will not reboot.
chroot . /usr/bin/update-gdk-pixbuf-loaders 1> /dev/null 2> /dev/null

( cd usr/bin ; rm -rf gtk-query-immodules-3.0 )
( cd usr/bin ; ln -sf gtk-query-immodules-3.0-32 gtk-query-immodules-3.0 )
( cd usr/lib ; rm -rf libgtk-3.so.0 )
( cd usr/lib ; ln -sf libgtk-3.so.0.800.2 libgtk-3.so.0 )
( cd usr/lib ; rm -rf libgailutil-3.so )
( cd usr/lib ; ln -sf libgailutil-3.so.0.0.0 libgailutil-3.so )
( cd usr/lib ; rm -rf libgdk-3.so )
( cd usr/lib ; ln -sf libgdk-3.so.0.800.2 libgdk-3.so )
( cd usr/lib ; rm -rf libgdk-3.so.0 )
( cd usr/lib ; ln -sf libgdk-3.so.0.800.2 libgdk-3.so.0 )
( cd usr/lib ; rm -rf libgailutil-3.so.0 )
( cd usr/lib ; ln -sf libgailutil-3.so.0.0.0 libgailutil-3.so.0 )
( cd usr/lib ; rm -rf libgtk-3.so )
( cd usr/lib ; ln -sf libgtk-3.so.0.800.2 libgtk-3.so )
( cd usr/doc/gtk+3-3.8.2 ; rm -rf gtk )
( cd usr/doc/gtk+3-3.8.2 ; ln -sf /usr/share/gtk-doc/html/gtk gtk )
( cd usr/doc/gtk+3-3.8.2 ; rm -rf gail-libgail-util )
( cd usr/doc/gtk+3-3.8.2 ; ln -sf /usr/share/gtk-doc/html/gail-libgail-util gail-libgail-util )
( cd usr/doc/gtk+3-3.8.2 ; rm -rf gdk )
( cd usr/doc/gtk+3-3.8.2 ; ln -sf /usr/share/gtk-doc/html/gdk gdk )
